/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.util.RopeStyles;

@Mod.EventBusSubscriber(modid="vstuff", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientConstraintTracker {
    private static final Map<Integer, ClientRopeData> clientConstraints = new HashMap<Integer, ClientRopeData>();

    public static void addClientConstraint(Integer constraintId, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, RopeStyles.RopeStyle style) {
        clientConstraints.put(constraintId, new ClientRopeData(shipA, shipB, localPosA, localPosB, maxLength, style));
    }

    public static void removeClientConstraint(Integer constraintId) {
        clientConstraints.remove(constraintId);
    }

    public static Map<Integer, ClientRopeData> getClientConstraints() {
        return new HashMap<Integer, ClientRopeData>(clientConstraints);
    }

    public static void clearAllClientConstraints() {
        clientConstraints.clear();
    }

    public static class ClientRopeData {
        public final Long shipA;
        public final Long shipB;
        public final Vector3d localPosA;
        public final Vector3d localPosB;
        public final double maxLength;
        public final RopeStyles.RopeStyle style;

        public ClientRopeData(Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, RopeStyles.RopeStyle style) {
            this.shipA = shipA;
            this.shipB = shipB;
            this.localPosA = new Vector3d((Vector3dc)localPosA);
            this.localPosB = new Vector3d((Vector3dc)localPosB);
            this.maxLength = maxLength;
            this.style = style;
        }

        public Vector3d getWorldPosA(Level level, float partialTick) {
            try {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ == null) {
                    return new Vector3d((Vector3dc)this.localPosA);
                }
                if (this.shipA == null || this.shipA == 0L) {
                    return new Vector3d((Vector3dc)this.localPosA);
                }
                Ship shipObject = VSGameUtilsKt.getShipObjectWorld((ClientLevel)mc.f_91073_).getAllShips().getById(this.shipA.longValue());
                if (shipObject != null) {
                    Vector3d worldPos = new Vector3d();
                    try {
                        ((ClientShip)shipObject).getRenderTransform().getShipToWorld().transformPosition((Vector3dc)this.localPosA, worldPos);
                    }
                    catch (Exception e) {
                        shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)this.localPosA, worldPos);
                    }
                    return worldPos;
                }
                return new Vector3d((Vector3dc)this.localPosA);
            }
            catch (Exception e) {
                return new Vector3d((Vector3dc)this.localPosA);
            }
        }

        public Vector3d getWorldPosB(Level level, float partialTick) {
            try {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ == null) {
                    return new Vector3d((Vector3dc)this.localPosB);
                }
                if (this.shipB == null || this.shipB == 0L) {
                    return new Vector3d((Vector3dc)this.localPosB);
                }
                Ship shipObject = VSGameUtilsKt.getShipObjectWorld((ClientLevel)mc.f_91073_).getAllShips().getById(this.shipB.longValue());
                if (shipObject != null) {
                    Vector3d worldPos = new Vector3d();
                    try {
                        ((ClientShip)shipObject).getRenderTransform().getShipToWorld().transformPosition((Vector3dc)this.localPosB, worldPos);
                    }
                    catch (Exception e) {
                        shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)this.localPosB, worldPos);
                    }
                    return worldPos;
                }
                return new Vector3d((Vector3dc)this.localPosB);
            }
            catch (Exception e) {
                return new Vector3d((Vector3dc)this.localPosB);
            }
        }

        public Vector3d getRawWorldPosA(Level level) {
            try {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ == null) {
                    return new Vector3d((Vector3dc)this.localPosA);
                }
                if (this.shipA == null || this.shipA == 0L) {
                    return new Vector3d((Vector3dc)this.localPosA);
                }
                Ship shipObject = VSGameUtilsKt.getShipObjectWorld((ClientLevel)mc.f_91073_).getAllShips().getById(this.shipA.longValue());
                if (shipObject != null) {
                    Vector3d worldPos = new Vector3d();
                    shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)this.localPosA, worldPos);
                    return worldPos;
                }
                return new Vector3d((Vector3dc)this.localPosA);
            }
            catch (Exception e) {
                return new Vector3d((Vector3dc)this.localPosA);
            }
        }

        public Vector3d getRawWorldPosB(Level level) {
            try {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ == null) {
                    return new Vector3d((Vector3dc)this.localPosB);
                }
                if (this.shipB == null || this.shipB == 0L) {
                    return new Vector3d((Vector3dc)this.localPosB);
                }
                Ship shipObject = VSGameUtilsKt.getShipObjectWorld((ClientLevel)mc.f_91073_).getAllShips().getById(this.shipB.longValue());
                if (shipObject != null) {
                    Vector3d worldPos = new Vector3d();
                    shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)this.localPosB, worldPos);
                    return worldPos;
                }
                return new Vector3d((Vector3dc)this.localPosB);
            }
            catch (Exception e) {
                return new Vector3d((Vector3dc)this.localPosB);
            }
        }
    }
}

