/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.client;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.joml.Vector3d;
import yay.evy.everest.vstuff.util.RopeStyles;
import yay.evy.everest.vstuff.util.packet.ConstraintSyncPacket;
import yay.evy.everest.vstuff.util.packet.RopeSoundPacket;
import yay.evy.everest.vstuff.util.packet.RopeStyleSelectPacket;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("vstuff", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static void registerPackets() {
        INSTANCE.messageBuilder(ConstraintSyncPacket.class, packetId++).decoder(ConstraintSyncPacket::new).encoder(ConstraintSyncPacket::encode).consumerMainThread(ConstraintSyncPacket::handle).add();
        INSTANCE.messageBuilder(RopeSoundPacket.class, packetId++).decoder(RopeSoundPacket::decode).encoder(RopeSoundPacket::encode).consumerMainThread(RopeSoundPacket::handle).add();
        INSTANCE.messageBuilder(RopeStyleSelectPacket.class, packetId++).decoder(RopeStyleSelectPacket::decode).encoder(RopeStyleSelectPacket::encode).consumerMainThread(RopeStyleSelectPacket::handle).add();
    }

    public static void sendConstraintRerender(Integer constraintId, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, RopeStyles.RopeStyle style) {
        ConstraintSyncPacket packet = new ConstraintSyncPacket(constraintId, shipA, shipB, localPosA, localPosB, maxLength, style);
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendConstraintAdd(Integer constraintId, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, RopeStyles.RopeStyle style) {
        ConstraintSyncPacket packet = new ConstraintSyncPacket(constraintId, shipA, shipB, localPosA, localPosB, maxLength, style);
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendConstraintRemove(Integer constraintId) {
        ConstraintSyncPacket packet = new ConstraintSyncPacket(constraintId);
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendConstraintRemoveToPlayer(ServerPlayer player, Integer constraintId) {
        ConstraintSyncPacket packet = new ConstraintSyncPacket(constraintId);
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendConstraintAddToPlayer(ServerPlayer player, Integer constraintId, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, RopeStyles.RopeStyle style) {
        ConstraintSyncPacket packet = new ConstraintSyncPacket(constraintId, shipA, shipB, localPosA, localPosB, maxLength, style);
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendClearAllConstraints() {
        ConstraintSyncPacket packet = new ConstraintSyncPacket();
        INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendClearAllConstraintsToPlayer(ServerPlayer player) {
        ConstraintSyncPacket packet = new ConstraintSyncPacket();
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }
}

