/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.client.ClientConstraintTracker;
import yay.evy.everest.vstuff.rendering.RopeRendererType;
import yay.evy.everest.vstuff.util.RopeStyles;

@Mod.EventBusSubscriber(modid="vstuff", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RopeRendererClient {
    private static final int ROPE_CURVE_SEGMENTS = 32;
    private static final float ROPE_SAG_FACTOR = 1.02f;
    private static final float WIND_STRENGTH = 0.02f;
    private static final Map<Integer, RopePositionCache> positionCache = new ConcurrentHashMap<Integer, RopePositionCache>();

    private static float getRopeWidth() {
        return ((Double)VstuffConfig.ROPE_THICKNESS.get()).floatValue();
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (event.getPartialTick() < 0.1f) {
            RopeRendererClient.cleanupPositionCache();
        }
        try {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level == null) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
            Vec3 cameraPos = event.getCamera().m_90583_();
            float partialTick = event.getPartialTick();
            Map<Integer, ClientConstraintTracker.ClientRopeData> constraints = ClientConstraintTracker.getClientConstraints();
            boolean renderedAny = false;
            for (Map.Entry<Integer, ClientConstraintTracker.ClientRopeData> entry : constraints.entrySet()) {
                try {
                    RopeRendererClient.renderClientRope(poseStack, (MultiBufferSource)bufferSource, entry.getKey(), entry.getValue(), (Level)level, cameraPos, partialTick, entry.getValue().style);
                    renderedAny = true;
                }
                catch (Exception e) {
                    System.err.println("Error rendering client rope: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (renderedAny) {
                bufferSource.m_109911_();
            }
        }
        catch (Exception e) {
            System.err.println("Error in rope rendering: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void cleanupPositionCache() {
        Map<Integer, ClientConstraintTracker.ClientRopeData> constraints = ClientConstraintTracker.getClientConstraints();
        positionCache.entrySet().removeIf(entry -> !constraints.containsKey(entry.getKey()));
    }

    private static void renderClientRope(PoseStack poseStack, MultiBufferSource bufferSource, Integer constraintId, ClientConstraintTracker.ClientRopeData ropeData, Level level, Vec3 cameraPos, float partialTick, RopeStyles.RopeStyle style) {
        if (!level.f_46443_) {
            System.err.println("Warning: Client renderer called on server side!");
            return;
        }
        Vector3d startPos = ropeData.getWorldPosA(level, partialTick);
        Vector3d endPos = ropeData.getWorldPosB(level, partialTick);
        if (startPos != null && endPos != null) {
            double actualRopeLength = startPos.distance((Vector3dc)endPos);
            double maxRopeLength = ropeData.maxLength;
            RopeRendererClient.renderRope(poseStack, bufferSource, startPos, endPos, actualRopeLength, maxRopeLength, cameraPos, partialTick, level, style);
        }
    }

    private static void renderRope(PoseStack poseStack, MultiBufferSource bufferSource, Vector3d startPos, Vector3d endPos, double actualRopeLength, double maxRopeLength, Vec3 cameraPos, float partialTick, Level level, RopeStyles.RopeStyle style) {
        Vec3 start = new Vec3(startPos.x - cameraPos.f_82479_, startPos.y - cameraPos.f_82480_, startPos.z - cameraPos.f_82481_);
        Vec3 end = new Vec3(endPos.x - cameraPos.f_82479_, endPos.y - cameraPos.f_82480_, endPos.z - cameraPos.f_82481_);
        Minecraft mc = Minecraft.m_91087_();
        int renderChunks = (Integer)mc.f_91066_.m_231984_().m_231551_();
        double maxRenderDist = (double)renderChunks * 16.0;
        double distanceToCamera = Math.min(start.m_82553_(), end.m_82553_());
        if (distanceToCamera > maxRenderDist) {
            return;
        }
        double currentDistance = start.m_82554_(end);
        if (currentDistance < 0.1) {
            return;
        }
        poseStack.m_85836_();
        switch (style.getRenderStyle()) {
            case CHAIN: {
                RopeRendererClient.renderChainRope(poseStack, bufferSource, start, end, actualRopeLength, maxRopeLength, partialTick, level, cameraPos, style, style.getTexture());
                break;
            }
            default: {
                boolean underwater = false;
                int samples = 8;
                for (int i = 0; i <= samples; ++i) {
                    double t = (double)i / (double)samples;
                    Vector3d point = new Vector3d((Vector3dc)startPos).lerp((Vector3dc)endPos, t);
                    BlockPos checkPos = new BlockPos((int)Math.floor(point.x()), (int)Math.floor(point.y()), (int)Math.floor(point.z()));
                    if (!level.m_6425_(checkPos).m_205070_(FluidTags.f_13131_)) continue;
                    underwater = true;
                    break;
                }
                RenderType renderType = underwater ? RopeRendererType.ropeRendererUnderwater(style.getTexture()) : RopeRendererType.ropeRenderer(style.getTexture());
                VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
                RopeRendererClient.renderNormalRope(poseStack, vertexConsumer, start, end, actualRopeLength, maxRopeLength, partialTick, level, cameraPos);
            }
        }
        poseStack.m_85849_();
    }

    private static void renderNormalRope(PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 start, Vec3 end, double actualRopeLength, double maxRopeLength, float partialTick, Level level, Vec3 cameraPos) {
        Vec3 worldUp;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Vec3 direction = end.m_82546_(start);
        double currentDistance = direction.m_82553_();
        if (currentDistance < 0.01) {
            return;
        }
        double stretchFactor = Math.min(currentDistance / Math.max(maxRopeLength, 0.1), 1.0);
        double sagAmount = (double)1.02f * (1.0 - stretchFactor * stretchFactor) * currentDistance * 0.35;
        long currentTimeNanos = System.nanoTime();
        float gameTime = (float)(currentTimeNanos % 100000000000L) / 1.0E9f;
        float windOffset = (float)(Math.sin((double)gameTime * 0.8) * 0.3 + Math.sin((double)gameTime * 1.3) * 0.2) * 0.02f;
        Vec3[] curvePoints = new Vec3[33];
        for (int i = 0; i <= 32; ++i) {
            float t = (float)i / 32.0f;
            curvePoints[i] = RopeRendererClient.calculateCatenaryPosition(start, end, t, sagAmount, windOffset, gameTime);
        }
        double totalCurveLength = 0.0;
        for (int i = 0; i < 32; ++i) {
            totalCurveLength += curvePoints[i].m_82554_(curvePoints[i + 1]);
        }
        Vec3 overallDirection = end.m_82546_(start).m_82541_();
        Vec3 right = Math.abs(overallDirection.m_82526_(worldUp = new Vec3(0.0, 1.0, 0.0))) > 0.9 ? new Vec3(1.0, 0.0, 0.0) : overallDirection.m_82537_(worldUp).m_82541_();
        Vec3 up = right.m_82537_(overallDirection).m_82541_();
        Vec3[] topRightStrip = new Vec3[33];
        Vec3[] topLeftStrip = new Vec3[33];
        Vec3[] bottomLeftStrip = new Vec3[33];
        Vec3[] bottomRightStrip = new Vec3[33];
        float halfWidth = RopeRendererClient.getRopeWidth() * 0.6f;
        for (int i = 0; i <= 32; ++i) {
            Vec3 center = curvePoints[i];
            topRightStrip[i] = center.m_82549_(right.m_82490_((double)halfWidth)).m_82549_(up.m_82490_((double)halfWidth));
            topLeftStrip[i] = center.m_82549_(right.m_82490_((double)(-halfWidth))).m_82549_(up.m_82490_((double)halfWidth));
            bottomLeftStrip[i] = center.m_82549_(right.m_82490_((double)(-halfWidth))).m_82549_(up.m_82490_((double)(-halfWidth)));
            bottomRightStrip[i] = center.m_82549_(right.m_82490_((double)halfWidth)).m_82549_(up.m_82490_((double)(-halfWidth)));
        }
        double textureScale = 0.28 / (double)RopeRendererClient.getRopeWidth();
        RopeRendererClient.renderRopeFaceWithGapFilling(vertexConsumer, matrix, topLeftStrip, topRightStrip, up, curvePoints, totalCurveLength, level, cameraPos, textureScale);
        RopeRendererClient.renderRopeFaceWithGapFilling(vertexConsumer, matrix, topRightStrip, bottomRightStrip, right, curvePoints, totalCurveLength, level, cameraPos, textureScale);
        RopeRendererClient.renderRopeFaceWithGapFilling(vertexConsumer, matrix, bottomRightStrip, bottomLeftStrip, up.m_82490_(-1.0), curvePoints, totalCurveLength, level, cameraPos, textureScale);
        RopeRendererClient.renderRopeFaceWithGapFilling(vertexConsumer, matrix, bottomLeftStrip, topLeftStrip, right.m_82490_(-1.0), curvePoints, totalCurveLength, level, cameraPos, textureScale);
        RopeRendererClient.renderRopeFaceWithGapFilling(vertexConsumer, matrix, topLeftStrip, bottomRightStrip, right.m_82549_(up).m_82541_(), curvePoints, totalCurveLength, level, cameraPos, textureScale);
        RopeRendererClient.renderRopeFaceWithGapFilling(vertexConsumer, matrix, topRightStrip, bottomLeftStrip, right.m_82546_(up).m_82541_(), curvePoints, totalCurveLength, level, cameraPos, textureScale);
    }

    private static void renderRopeFaceWithGapFilling(VertexConsumer vertexConsumer, Matrix4f matrix, Vec3[] strip1, Vec3[] strip2, Vec3 normal, Vec3[] curvePoints, double totalCurveLength, Level level, Vec3 cameraPos, double textureScale) {
        int i;
        double[] cumulativeDistances = new double[33];
        cumulativeDistances[0] = 0.0;
        for (i = 0; i < 32; ++i) {
            double segmentLength = curvePoints[i].m_82554_(curvePoints[i + 1]);
            cumulativeDistances[i + 1] = cumulativeDistances[i] + segmentLength;
        }
        for (i = 0; i < 32; ++i) {
            float vStart = (float)(cumulativeDistances[i] * textureScale);
            float vEnd = (float)(cumulativeDistances[i + 1] * textureScale);
            Vec3 p1 = strip1[i];
            Vec3 p2 = strip2[i];
            Vec3 p3 = strip2[i + 1];
            Vec3 p4 = strip1[i + 1];
            int light = RopeRendererClient.calculateDynamicLighting(level, p1, p2, cameraPos);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p1, 0.0f, vStart, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p2, 1.0f, vStart, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p4, 0.0f, vEnd, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p2, 1.0f, vStart, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p3, 1.0f, vEnd, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p4, 0.0f, vEnd, light, normal);
            Vec3 center1 = p1.m_82549_(p2).m_82490_(0.5);
            Vec3 center2 = p3.m_82549_(p4).m_82490_(0.5);
            RopeRendererClient.addRopeVertexWithAlpha(vertexConsumer, matrix, center1, 0.5f, vStart, light, normal, 128);
            RopeRendererClient.addRopeVertexWithAlpha(vertexConsumer, matrix, p2, 1.0f, vStart, light, normal, 128);
            RopeRendererClient.addRopeVertexWithAlpha(vertexConsumer, matrix, center2, 0.5f, vEnd, light, normal, 128);
            RopeRendererClient.addRopeVertexWithAlpha(vertexConsumer, matrix, p1, 0.0f, vStart, light, normal, 128);
            RopeRendererClient.addRopeVertexWithAlpha(vertexConsumer, matrix, center1, 0.5f, vStart, light, normal, 128);
            RopeRendererClient.addRopeVertexWithAlpha(vertexConsumer, matrix, center2, 0.5f, vEnd, light, normal, 128);
        }
    }

    private static void renderChainRope(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 start, Vec3 end, double actualRopeLength, double maxRopeLength, float partialTick, Level level, Vec3 cameraPos, RopeStyles.RopeStyle style, ResourceLocation chainTexture) {
        Vec3 worldUp;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderType renderType = RopeRendererType.ropeRendererChainStyle(chainTexture);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        double stretchFactor = Math.min(actualRopeLength / Math.max(maxRopeLength, 0.1), 1.0);
        double sagAmount = (double)1.02f * (1.0 - stretchFactor * stretchFactor) * actualRopeLength * 0.35;
        long currentTimeNanos = System.nanoTime();
        float gameTime = (float)(currentTimeNanos % 100000000000L) / 1.0E9f;
        float windOffset = (float)(Math.sin((double)gameTime * 0.8) * 0.3 + Math.sin((double)gameTime * 1.3) * 0.2) * 0.02f;
        Vec3[] curvePoints = new Vec3[33];
        for (int i = 0; i <= 32; ++i) {
            float t = (float)i / 32.0f;
            curvePoints[i] = RopeRendererClient.calculateCatenaryPosition(start, end, t, sagAmount, windOffset, gameTime);
        }
        double totalCurveLength = 0.0;
        double[] cumulativeDistances = new double[33];
        cumulativeDistances[0] = 0.0;
        for (int i = 0; i < 32; ++i) {
            double segLength = curvePoints[i].m_82554_(curvePoints[i + 1]);
            cumulativeDistances[i + 1] = totalCurveLength += segLength;
        }
        double repeatInterval = 1.0;
        double textureScale = 1.0 / repeatInterval;
        Vec3 overallDirection = end.m_82546_(start).m_82541_();
        Vec3 right = Math.abs(overallDirection.m_82526_(worldUp = new Vec3(0.0, 1.0, 0.0))) > 0.9 ? new Vec3(1.0, 0.0, 0.0) : overallDirection.m_82537_(worldUp).m_82541_();
        Vec3 up = right.m_82537_(overallDirection).m_82541_();
        Vec3[] topRightStrip = new Vec3[33];
        Vec3[] topLeftStrip = new Vec3[33];
        Vec3[] bottomLeftStrip = new Vec3[33];
        Vec3[] bottomRightStrip = new Vec3[33];
        float halfWidth = RopeRendererClient.getRopeWidth() * 5.0f;
        for (int i = 0; i <= 32; ++i) {
            Vec3 center = curvePoints[i];
            topRightStrip[i] = center.m_82549_(right.m_82490_((double)halfWidth)).m_82549_(up.m_82490_((double)halfWidth));
            topLeftStrip[i] = center.m_82549_(right.m_82490_((double)(-halfWidth))).m_82549_(up.m_82490_((double)halfWidth));
            bottomLeftStrip[i] = center.m_82549_(right.m_82490_((double)(-halfWidth))).m_82549_(up.m_82490_((double)(-halfWidth)));
            bottomRightStrip[i] = center.m_82549_(right.m_82490_((double)halfWidth)).m_82549_(up.m_82490_((double)(-halfWidth)));
        }
        RopeRendererClient.renderRopeFaceWithRepeatingUVs(vertexConsumer, matrix, topLeftStrip, bottomRightStrip, right.m_82549_(up).m_82541_(), curvePoints, cumulativeDistances, textureScale, level, cameraPos);
        RopeRendererClient.renderRopeFaceWithRepeatingUVs(vertexConsumer, matrix, topRightStrip, bottomLeftStrip, right.m_82546_(up).m_82541_(), curvePoints, cumulativeDistances, textureScale, level, cameraPos);
    }

    private static void renderRopeFaceWithRepeatingUVs(VertexConsumer vertexConsumer, Matrix4f matrix, Vec3[] strip1, Vec3[] strip2, Vec3 normal, Vec3[] curvePoints, double[] cumulativeDistances, double textureScale, Level level, Vec3 cameraPos) {
        double linkLength = 1.0;
        double ropeLength = cumulativeDistances[32];
        double textureScalePerBlock = 0.5 / linkLength;
        double leftover = ropeLength % linkLength;
        double uvOffset = -(leftover * 0.5 * textureScalePerBlock);
        for (int i = 0; i < 32; ++i) {
            float vStart = (float)(cumulativeDistances[i] * textureScalePerBlock + uvOffset);
            float vEnd = (float)(cumulativeDistances[i + 1] * textureScalePerBlock + uvOffset);
            Vec3 p1 = strip1[i];
            Vec3 p2 = strip2[i];
            Vec3 p3 = strip2[i + 1];
            Vec3 p4 = strip1[i + 1];
            int light = RopeRendererClient.calculateDynamicLighting(level, p1, p2, cameraPos);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p1, 0.0f, vStart, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p2, 1.0f, vStart, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p4, 0.0f, vEnd, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p2, 1.0f, vStart, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p3, 1.0f, vEnd, light, normal);
            RopeRendererClient.addRopeVertex(vertexConsumer, matrix, p4, 0.0f, vEnd, light, normal);
        }
    }

    private static void addRopeVertex(VertexConsumer consumer, Matrix4f matrix, Vec3 pos, float u, float v, int light, Vec3 normal) {
        float clampedU = Math.max(0.0f, Math.min(1.0f, u));
        consumer.m_252986_(matrix, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_6122_(255, 255, 255, 255).m_7421_(clampedU, v).m_86008_(0).m_85969_(light).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    private static void addRopeVertexWithAlpha(VertexConsumer consumer, Matrix4f matrix, Vec3 pos, float u, float v, int light, Vec3 normal, int alpha) {
        float clampedU = Math.max(0.0f, Math.min(1.0f, u));
        consumer.m_252986_(matrix, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_).m_6122_(255, 255, 255, alpha).m_7421_(clampedU, v).m_86008_(0).m_85969_(light).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    private static Vec3 calculateCatenaryPosition(Vec3 start, Vec3 end, float t, double sagAmount, float windOffset, float gameTime) {
        Vec3 linearPos = start.m_165921_(end, (double)t);
        double sagCurve = Math.sin((double)t * Math.PI) * sagAmount;
        double windSway = Math.sin((double)gameTime * 0.7 + (double)(t * 2.0f)) * (double)windOffset * Math.max(sagAmount, 0.1) * 0.3;
        double windSwayZ = Math.cos((double)gameTime * 0.5 + (double)t * 1.5) * (double)windOffset * Math.max(sagAmount, 0.1) * 0.15;
        return linearPos.m_82520_(windSway, -sagCurve, windSwayZ);
    }

    private static int calculateDynamicLighting(Level level, Vec3 pos1, Vec3 pos2, Vec3 cameraPos) {
        Vec3 worldPos1 = pos1.m_82549_(cameraPos);
        Vec3 worldPos2 = pos2.m_82549_(cameraPos);
        Vec3 midPoint = worldPos1.m_82549_(worldPos2).m_82490_(0.5);
        BlockPos blockPos = new BlockPos((int)midPoint.f_82479_, (int)midPoint.f_82480_, (int)midPoint.f_82481_);
        try {
            int blockLight = level.m_45517_(LightLayer.BLOCK, blockPos);
            int skyLight = level.m_45517_(LightLayer.SKY, blockPos);
            blockLight = Math.max(2, Math.min(15, blockLight));
            skyLight = Math.max(2, Math.min(15, skyLight));
            return skyLight << 20 | blockLight << 4;
        }
        catch (Exception e) {
            return 0x800080;
        }
    }

    private static class RopePositionCache {
        Vector3d prevStartPos = new Vector3d();
        Vector3d prevEndPos = new Vector3d();
        Vector3d currentStartPos = new Vector3d();
        Vector3d currentEndPos = new Vector3d();
        boolean initialized = false;
        private static final double TELEPORT_THRESHOLD = 5.0;

        private RopePositionCache() {
        }

        public void updatePositions(Vector3d newStart, Vector3d newEnd) {
            if (!this.initialized) {
                this.prevStartPos.set((Vector3dc)newStart);
                this.prevEndPos.set((Vector3dc)newEnd);
                this.currentStartPos.set((Vector3dc)newStart);
                this.currentEndPos.set((Vector3dc)newEnd);
                this.initialized = true;
                return;
            }
            double startJump = this.currentStartPos.distance((Vector3dc)newStart);
            double endJump = this.currentEndPos.distance((Vector3dc)newEnd);
            if (startJump > 5.0 || endJump > 5.0) {
                this.prevStartPos.set((Vector3dc)newStart);
                this.prevEndPos.set((Vector3dc)newEnd);
                this.currentStartPos.set((Vector3dc)newStart);
                this.currentEndPos.set((Vector3dc)newEnd);
            } else {
                this.prevStartPos.set((Vector3dc)this.currentStartPos);
                this.prevEndPos.set((Vector3dc)this.currentEndPos);
                this.currentStartPos.set((Vector3dc)newStart);
                this.currentEndPos.set((Vector3dc)newEnd);
            }
        }

        public Vector3d getInterpolatedStartPos(float partialTick) {
            if (!this.initialized) {
                return new Vector3d((Vector3dc)this.currentStartPos);
            }
            return new Vector3d((Vector3dc)this.prevStartPos).lerp((Vector3dc)this.currentStartPos, (double)partialTick);
        }

        public Vector3d getInterpolatedEndPos(float partialTick) {
            if (!this.initialized) {
                return new Vector3d((Vector3dc)this.prevEndPos).lerp((Vector3dc)this.currentEndPos, (double)partialTick);
            }
            return new Vector3d((Vector3dc)this.prevEndPos).lerp((Vector3dc)this.currentEndPos, (double)partialTick);
        }
    }
}

