/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.constraint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSRopeConstraint;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;
import yay.evy.everest.vstuff.util.RopeStyles;

public class ConstraintPersistence
extends SavedData {
    private static final String DATA_NAME = "vstuff_constraints";
    private final Set<String> removedConstraints = new HashSet<String>();
    private final Map<String, PersistedConstraintData> persistedConstraints = new HashMap<String, PersistedConstraintData>();
    private final Set<String> restoredConstraints = new HashSet<String>();
    private boolean hasAttemptedRestore = false;
    private boolean cleanupScheduled = false;
    private int ticksUntilCleanup = 0;
    private ServerLevel cleanupLevel = null;

    public static ConstraintPersistence get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (ConstraintPersistence)storage.m_164861_(ConstraintPersistence::load, ConstraintPersistence::new, DATA_NAME);
    }

    public void markConstraintAsRemoved(String id) {
        this.removedConstraints.add(id);
        this.persistedConstraints.remove(id);
        this.restoredConstraints.remove(id);
        this.m_77762_();
    }

    public static ConstraintPersistence load(CompoundTag tag) {
        int i;
        ConstraintPersistence data = new ConstraintPersistence();
        ListTag constraintsList = tag.m_128437_("constraints", 10);
        ListTag removedList = tag.m_128437_("removedConstraints", 8);
        for (i = 0; i < removedList.size(); ++i) {
            data.removedConstraints.add(removedList.m_128778_(i));
        }
        for (i = 0; i < constraintsList.size(); ++i) {
            CompoundTag constraintTag = constraintsList.m_128728_(i);
            String id = constraintTag.m_128461_("id");
            if (data.removedConstraints.contains(id)) continue;
            long shipALong = constraintTag.m_128454_("shipA");
            long shipBLong = constraintTag.m_128454_("shipB");
            Long shipA = shipALong == 0L ? null : Long.valueOf(shipALong);
            Long shipB = shipBLong == 0L ? null : Long.valueOf(shipBLong);
            boolean shipAIsGround = constraintTag.m_128471_("shipAIsGround");
            boolean shipBIsGround = constraintTag.m_128471_("shipBIsGround");
            Vector3d localPosA = new Vector3d(constraintTag.m_128459_("localPosA_x"), constraintTag.m_128459_("localPosA_y"), constraintTag.m_128459_("localPosA_z"));
            Vector3d localPosB = new Vector3d(constraintTag.m_128459_("localPosB_x"), constraintTag.m_128459_("localPosB_y"), constraintTag.m_128459_("localPosB_z"));
            double maxLength = constraintTag.m_128459_("maxLength");
            double compliance = constraintTag.m_128459_("compliance");
            double maxForce = constraintTag.m_128459_("maxForce");
            ConstraintTracker.RopeConstraintData.ConstraintType constraintType = ConstraintTracker.RopeConstraintData.ConstraintType.GENERIC;
            if (constraintTag.m_128441_("constraintType")) {
                try {
                    constraintType = ConstraintTracker.RopeConstraintData.ConstraintType.valueOf(constraintTag.m_128461_("constraintType"));
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Invalid constraint type in save data, defaulting to GENERIC: " + e.getMessage());
                }
            }
            BlockPos sourceBlockPos = null;
            if (constraintTag.m_128441_("sourceBlockPos_x")) {
                sourceBlockPos = new BlockPos(constraintTag.m_128451_("sourceBlockPos_x"), constraintTag.m_128451_("sourceBlockPos_y"), constraintTag.m_128451_("sourceBlockPos_z"));
            }
            String style = constraintTag.m_128441_("style") ? constraintTag.m_128461_("style") : "normal";
            String primitiveType = constraintTag.m_128441_("primitiveStyle") ? constraintTag.m_128461_("primitiveStyle") : "normal";
            String styleLKey = constraintTag.m_128441_("styleLKey") ? constraintTag.m_128461_("styleLKey") : "";
            RopeStyles.RopeStyle ropeStyle = new RopeStyles.RopeStyle(style, primitiveType, styleLKey);
            data.persistedConstraints.put(id, new PersistedConstraintData(shipA, shipB, localPosA, localPosB, maxLength, compliance, maxForce, shipAIsGround, shipBIsGround, constraintType, sourceBlockPos, new RopeStyles.RopeStyle(style, primitiveType, styleLKey)));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag constraintsList = new ListTag();
        ListTag removedList = new ListTag();
        for (String string : this.removedConstraints) {
            removedList.add((Object)StringTag.m_129297_((String)string));
        }
        tag.m_128365_("removedConstraints", (Tag)removedList);
        for (Map.Entry entry : this.persistedConstraints.entrySet()) {
            String constraintId = (String)entry.getKey();
            if (this.removedConstraints.contains(constraintId)) continue;
            CompoundTag constraintTag = new CompoundTag();
            PersistedConstraintData data = (PersistedConstraintData)entry.getValue();
            constraintTag.m_128359_("id", constraintId);
            constraintTag.m_128356_("shipA", data.shipA != null ? data.shipA : 0L);
            constraintTag.m_128356_("shipB", data.shipB != null ? data.shipB : 0L);
            constraintTag.m_128379_("shipAIsGround", data.shipAIsGround);
            constraintTag.m_128379_("shipBIsGround", data.shipBIsGround);
            constraintTag.m_128347_("localPosA_x", data.localPosA.x);
            constraintTag.m_128347_("localPosA_y", data.localPosA.y);
            constraintTag.m_128347_("localPosA_z", data.localPosA.z);
            constraintTag.m_128347_("localPosB_x", data.localPosB.x);
            constraintTag.m_128347_("localPosB_y", data.localPosB.y);
            constraintTag.m_128347_("localPosB_z", data.localPosB.z);
            constraintTag.m_128347_("maxLength", data.maxLength);
            constraintTag.m_128347_("compliance", data.compliance);
            constraintTag.m_128347_("maxForce", data.maxForce);
            constraintTag.m_128359_("constraintType", data.constraintType.name());
            constraintTag.m_128359_("style", data.style.getStyle());
            constraintTag.m_128359_("primitiveStyle", data.style.getBasicStyle().name().toLowerCase());
            constraintTag.m_128359_("styleLKey", data.style.getLangKey());
            if (data.sourceBlockPos != null) {
                constraintTag.m_128405_("sourceBlockPos_x", data.sourceBlockPos.m_123341_());
                constraintTag.m_128405_("sourceBlockPos_y", data.sourceBlockPos.m_123342_());
                constraintTag.m_128405_("sourceBlockPos_z", data.sourceBlockPos.m_123343_());
            }
            constraintsList.add((Object)constraintTag);
        }
        tag.m_128365_("constraints", (Tag)constraintsList);
        System.out.println("Saved " + this.persistedConstraints.size() + " constraints to disk");
        return tag;
    }

    public void saveNow(ServerLevel level) {
        this.m_77762_();
        level.m_8895_().m_78151_();
    }

    public void addConstraint(String id, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, double compliance, double maxForce, ServerLevel level, ConstraintTracker.RopeConstraintData.ConstraintType constraintType, BlockPos sourceBlockPos, RopeStyles.RopeStyle style) {
        boolean shipAIsGround = false;
        boolean shipBIsGround = false;
        try {
            Long currentGroundBodyId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
            shipAIsGround = shipA != null && shipA.equals(currentGroundBodyId);
            shipBIsGround = shipB != null && shipB.equals(currentGroundBodyId);
        }
        catch (Exception e) {
            System.err.println("Failed to check ground body IDs: " + e.getMessage());
        }
        this.persistedConstraints.put(id, new PersistedConstraintData(shipA, shipB, localPosA, localPosB, maxLength, compliance, maxForce, shipAIsGround, shipBIsGround, constraintType, sourceBlockPos, style));
        this.m_77762_();
    }

    public void removeConstraint(String id) {
        PersistedConstraintData data = this.persistedConstraints.get(id);
        if (data != null && (data.shipAIsGround || data.shipBIsGround)) {
            return;
        }
        if (this.persistedConstraints.remove(id) != null) {
            this.restoredConstraints.remove(id);
            this.markConstraintAsRemoved(id);
            this.m_77762_();
        }
    }

    public Map<String, PersistedConstraintData> getAllConstraints() {
        return new HashMap<String, PersistedConstraintData>(this.persistedConstraints);
    }

    private void restoreLoadedChunkConstraints(ServerLevel level, Long currentGroundBodyId) {
        int successCount = 0;
        int failCount = 0;
        int skipCount = 0;
        HashMap<String, PersistedConstraintData> constraintsCopy = new HashMap<String, PersistedConstraintData>(this.persistedConstraints);
        for (Map.Entry entry : constraintsCopy.entrySet()) {
            String persistenceId = (String)entry.getKey();
            PersistedConstraintData data = (PersistedConstraintData)entry.getValue();
            if (this.removedConstraints.contains(persistenceId)) {
                ++skipCount;
                continue;
            }
            if (this.restoredConstraints.contains(persistenceId)) {
                ++skipCount;
                continue;
            }
            if (this.isConstraintInLoadedChunks(level, data, currentGroundBodyId)) continue;
            System.out.println("Constraint " + persistenceId + " is not in loaded chunks, will restore when chunks load");
            ++skipCount;
        }
        System.out.println("Initial constraint restoration complete: " + successCount + " success, " + failCount + " failed, " + skipCount + " skipped (will restore when chunks load)");
    }

    private boolean isConstraintInLoadedChunks(ServerLevel level, PersistedConstraintData data, Long groundBodyId) {
        try {
            if (data.constraintType == ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY && data.sourceBlockPos != null) {
                return level.m_46749_(data.sourceBlockPos);
            }
            boolean pointALoaded = this.isPositionChunkLoaded(level, data.localPosA, data.shipA, data.shipAIsGround, groundBodyId);
            boolean pointBLoaded = this.isPositionChunkLoaded(level, data.localPosB, data.shipB, data.shipBIsGround, groundBodyId);
            return pointALoaded && pointBLoaded;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isPositionChunkLoaded(ServerLevel level, Vector3d localPos, Long shipId, boolean isGround, Long groundBodyId) {
        try {
            Vector3d worldPos;
            if (isGround) {
                worldPos = new Vector3d((Vector3dc)localPos);
            } else if (shipId != null) {
                Ship ship = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue());
                if (ship == null) {
                    return false;
                }
                worldPos = new Vector3d();
                ship.getTransform().getShipToWorld().transformPosition((Vector3dc)localPos, worldPos);
            } else {
                return false;
            }
            BlockPos blockPos = new BlockPos((int)Math.floor(worldPos.x), (int)Math.floor(worldPos.y), (int)Math.floor(worldPos.z));
            return level.m_46749_(blockPos);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Integer getConstraintIdForBlock(ServerLevel level, BlockPos blockPos) {
        for (Map.Entry<Integer, ConstraintTracker.RopeConstraintData> entry : ConstraintTracker.getActiveConstraints().entrySet()) {
            ConstraintTracker.RopeConstraintData data = entry.getValue();
            if (data.sourceBlockPos == null || !data.sourceBlockPos.equals((Object)blockPos)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void restoreConstraints(ServerLevel level) {
        ConstraintPersistence persistence = ConstraintPersistence.get(level);
        persistence.restoreConstraintsInstance(level);
    }

    public void restoreConstraintsInstance(ServerLevel level) {
        if (this.hasAttemptedRestore) {
            return;
        }
        this.hasAttemptedRestore = true;
        level.m_7654_().execute(() -> {
            Long currentGroundBodyId;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                currentGroundBodyId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
            }
            catch (Exception e) {
                return;
            }
            int successCount = 0;
            int failCount = 0;
            int skipCount = 0;
            for (Map.Entry<String, PersistedConstraintData> entry : this.persistedConstraints.entrySet()) {
                Long actualShipB;
                String persistenceId = entry.getKey();
                PersistedConstraintData data = entry.getValue();
                if (this.removedConstraints.contains(persistenceId)) {
                    ++skipCount;
                    continue;
                }
                if (this.restoredConstraints.contains(persistenceId)) {
                    ++skipCount;
                    continue;
                }
                Long actualShipA = data.shipAIsGround ? currentGroundBodyId : data.shipA;
                Long l = actualShipB = data.shipBIsGround ? currentGroundBodyId : data.shipB;
                if (this.validateShipsAndCreateConstraint(level, persistenceId, data, actualShipA, actualShipB)) {
                    this.restoredConstraints.add(persistenceId);
                    ++successCount;
                    continue;
                }
                ++failCount;
            }
            for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
                ConstraintTracker.syncAllConstraintsToPlayer(player);
            }
        });
    }

    private void cleanupDeadConstraints(ServerLevel level) {
        try {
            Long groundBodyId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
            if (groundBodyId == null) {
                return;
            }
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry<String, PersistedConstraintData> entry : this.persistedConstraints.entrySet()) {
                boolean shipBValid;
                String persistenceId = entry.getKey();
                PersistedConstraintData data = entry.getValue();
                if (this.restoredConstraints.contains(persistenceId) || data.shipAIsGround || data.shipBIsGround) continue;
                Long actualShipA = data.shipAIsGround ? groundBodyId : data.shipA;
                Long actualShipB = data.shipBIsGround ? groundBodyId : data.shipB;
                boolean shipAValid = data.shipAIsGround || actualShipA != null && VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(actualShipA.longValue()) != null;
                boolean bl = shipBValid = data.shipBIsGround || actualShipB != null && VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(actualShipB.longValue()) != null;
                if (shipAValid && shipBValid) continue;
                toRemove.add(persistenceId);
            }
            for (String deadId : toRemove) {
                this.removeConstraint(deadId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void restoreConstraintsForChunk(ServerLevel level, ChunkPos chunkPos) {
        if (this.persistedConstraints.isEmpty()) {
            return;
        }
        Long currentGroundBodyId = null;
        try {
            currentGroundBodyId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
        }
        catch (Exception e) {
            return;
        }
        if (currentGroundBodyId == null) {
            return;
        }
        int restoredCount = 0;
        HashMap<String, PersistedConstraintData> constraintsCopy = new HashMap<String, PersistedConstraintData>(this.persistedConstraints);
        for (Map.Entry entry : constraintsCopy.entrySet()) {
            Long actualShipB;
            Long actualShipA;
            String persistenceId = (String)entry.getKey();
            PersistedConstraintData data = (PersistedConstraintData)entry.getValue();
            if (this.removedConstraints.contains(persistenceId) || this.restoredConstraints.contains(persistenceId) || !this.isConstraintInChunk(level, data, chunkPos, currentGroundBodyId) || !this.validateShipsAndCreateConstraint(level, persistenceId, data, actualShipA = data.shipAIsGround ? currentGroundBodyId : data.shipA, actualShipB = data.shipBIsGround ? currentGroundBodyId : data.shipB)) continue;
            ++restoredCount;
            this.restoredConstraints.add(persistenceId);
        }
        if (restoredCount > 0) {
            // empty if block
        }
    }

    private boolean validateShipsAndCreateConstraint(ServerLevel level, String persistenceId, PersistedConstraintData data, Long actualShipA, Long actualShipB) {
        try {
            boolean shipBValid;
            boolean shipAValid = data.shipAIsGround || actualShipA != null && VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(actualShipA.longValue()) != null;
            boolean bl = shipBValid = data.shipBIsGround || actualShipB != null && VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(actualShipB.longValue()) != null;
            if (!shipAValid || !shipBValid) {
                return false;
            }
            VSRopeConstraint ropeConstraint = new VSRopeConstraint(actualShipA.longValue(), actualShipB.longValue(), data.compliance, (Vector3dc)data.localPosA, (Vector3dc)data.localPosB, data.maxForce, data.maxLength);
            Integer newConstraintId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createNewConstraint((VSConstraint)ropeConstraint);
            if (newConstraintId != null) {
                ConstraintTracker.addConstraintToTracker(level, newConstraintId, actualShipA, actualShipB, data.localPosA, data.localPosB, data.maxLength, data.compliance, data.maxForce, data.constraintType, data.sourceBlockPos, data.style);
                ConstraintTracker.mapConstraintToPersistenceId(newConstraintId, persistenceId);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error restoring constraint " + persistenceId + ": " + e.getMessage());
        }
        return false;
    }

    private boolean isConstraintInChunk(ServerLevel level, PersistedConstraintData data, ChunkPos chunkPos, Long groundBodyId) {
        try {
            if (data.constraintType == ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY && data.sourceBlockPos != null) {
                ChunkPos sourceChunk = new ChunkPos(data.sourceBlockPos);
                return sourceChunk.equals((Object)chunkPos);
            }
            boolean pointAInChunk = this.isPositionInChunk(level, data.localPosA, data.shipA, data.shipAIsGround, chunkPos, groundBodyId);
            boolean pointBInChunk = this.isPositionInChunk(level, data.localPosB, data.shipB, data.shipBIsGround, chunkPos, groundBodyId);
            return pointAInChunk || pointBInChunk;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isPositionInChunk(ServerLevel level, Vector3d localPos, Long shipId, boolean isGround, ChunkPos chunkPos, Long groundBodyId) {
        try {
            Vector3d worldPos;
            if (isGround) {
                worldPos = new Vector3d((Vector3dc)localPos);
            } else if (shipId != null) {
                Ship ship = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue());
                if (ship == null) {
                    return false;
                }
                worldPos = new Vector3d();
                ship.getTransform().getShipToWorld().transformPosition((Vector3dc)localPos, worldPos);
            } else {
                return false;
            }
            ChunkPos posChunk = new ChunkPos((int)Math.floor(worldPos.x) >> 4, (int)Math.floor(worldPos.z) >> 4);
            return posChunk.equals((Object)chunkPos);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class PersistedConstraintData {
        public Long shipA;
        public Long shipB;
        public Vector3d localPosA;
        public Vector3d localPosB;
        public double maxLength;
        public double compliance;
        public double maxForce;
        public boolean shipAIsGround;
        public boolean shipBIsGround;
        public ConstraintTracker.RopeConstraintData.ConstraintType constraintType;
        public BlockPos sourceBlockPos;
        public RopeStyles.RopeStyle style;

        public PersistedConstraintData(Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, double compliance, double maxForce, boolean shipAIsGround, boolean shipBIsGround, RopeStyles.RopeStyle style) {
            this(shipA, shipB, localPosA, localPosB, maxLength, compliance, maxForce, shipAIsGround, shipBIsGround, ConstraintTracker.RopeConstraintData.ConstraintType.GENERIC, null, style);
        }

        public PersistedConstraintData(Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, double compliance, double maxForce, boolean shipAIsGround, boolean shipBIsGround, ConstraintTracker.RopeConstraintData.ConstraintType constraintType, BlockPos sourceBlockPos, RopeStyles.RopeStyle style) {
            this.shipA = shipA;
            this.shipB = shipB;
            this.shipAIsGround = shipAIsGround;
            this.shipBIsGround = shipBIsGround;
            this.localPosA = new Vector3d((Vector3dc)localPosA);
            this.localPosB = new Vector3d((Vector3dc)localPosB);
            this.maxLength = maxLength;
            this.compliance = compliance;
            this.maxForce = maxForce;
            this.constraintType = constraintType != null ? constraintType : ConstraintTracker.RopeConstraintData.ConstraintType.GENERIC;
            this.sourceBlockPos = sourceBlockPos;
            this.style = style;
        }
    }
}

