/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.constraint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.client.NetworkHandler;
import yay.evy.everest.vstuff.content.constraint.ConstraintPersistence;
import yay.evy.everest.vstuff.util.RopeStyles;

@Mod.EventBusSubscriber(modid="vstuff", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConstraintTracker {
    public static final Map<Integer, RopeConstraintData> activeConstraints = new ConcurrentHashMap<Integer, RopeConstraintData>();
    private static final Map<Integer, String> constraintToPersistenceId = new ConcurrentHashMap<Integer, String>();
    private static long lastJoinTime = 0L;
    private static final Map<Integer, Long> delayedValidations = new ConcurrentHashMap<Integer, Long>();
    private static final Map<Integer, FluidConverterLink> fluidConstraints = new ConcurrentHashMap<Integer, FluidConverterLink>();

    public static void addConstraintWithPersistence(ServerLevel level, Integer constraintId, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, double compliance, double maxForce, RopeConstraintData.ConstraintType constraintType, BlockPos sourceBlockPos, RopeStyles.RopeStyle style) {
        boolean existingConstraintFound;
        if (constraintType == RopeConstraintData.ConstraintType.ROPE_PULLEY && sourceBlockPos != null && (existingConstraintFound = activeConstraints.values().stream().anyMatch(existing -> existing.constraintType == RopeConstraintData.ConstraintType.ROPE_PULLEY && existing.sourceBlockPos != null && existing.sourceBlockPos.equals((Object)sourceBlockPos) && existing.style == style))) {
            return;
        }
        RopeConstraintData data = new RopeConstraintData(level, shipA, shipB, localPosA, localPosB, maxLength, compliance, maxForce, constraintType, sourceBlockPos, style);
        activeConstraints.put(constraintId, data);
        ConstraintPersistence persistence = ConstraintPersistence.get(level);
        String persistenceId = UUID.randomUUID().toString();
        constraintToPersistenceId.put(constraintId, persistenceId);
        persistence.addConstraint(persistenceId, shipA, shipB, localPosA, localPosB, maxLength, compliance, maxForce, level, constraintType, sourceBlockPos, style);
        NetworkHandler.sendConstraintAdd(constraintId, shipA, shipB, localPosA, localPosB, maxLength, style);
    }

    public static void addConstraintWithPersistence(ServerLevel level, Integer constraintId, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, double compliance, double maxForce, RopeStyles.RopeStyle style) {
        ConstraintTracker.addConstraintWithPersistence(level, constraintId, shipA, shipB, localPosA, localPosB, maxLength, compliance, maxForce, RopeConstraintData.ConstraintType.GENERIC, null, style);
    }

    public static String persistanceIdViaConstraintId(Integer constraintId) {
        return constraintToPersistenceId.get(constraintId);
    }

    public static void removeConstraintWithPersistence(ServerLevel level, Integer constraintId) {
        RopeConstraintData data = activeConstraints.remove(constraintId);
        if (data != null) {
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).removeConstraint(constraintId.intValue());
            ConstraintPersistence persistence = ConstraintPersistence.get(level);
            String persistenceId = constraintToPersistenceId.remove(constraintId);
            if (persistenceId != null) {
                persistence.markConstraintAsRemoved(persistenceId);
                persistence.m_77762_();
            }
            if (level.m_7654_() != null) {
                for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
                    NetworkHandler.sendConstraintRemoveToPlayer(player, constraintId);
                    level.m_7654_().m_6937_((Runnable)new TickTask(0, () -> NetworkHandler.sendConstraintRemoveToPlayer(player, constraintId)));
                }
            }
            NetworkHandler.sendConstraintRemove(constraintId);
            if (data.constraintType == RopeConstraintData.ConstraintType.ROPE_PULLEY && data.sourceBlockPos != null) {
                ConstraintTracker.cleanupOrphanedConstraints(level, data.sourceBlockPos);
            }
        }
    }

    public static void syncAllConstraintsToPlayer(ServerPlayer player) {
        NetworkHandler.sendClearAllConstraintsToPlayer(player);
        for (Map.Entry<Integer, RopeConstraintData> entry : activeConstraints.entrySet()) {
            RopeConstraintData data = entry.getValue();
            NetworkHandler.sendConstraintAddToPlayer(player, entry.getKey(), data.shipA, data.shipB, data.localPosA, data.localPosB, data.maxLength, data.style);
        }
    }

    public static void mapConstraintToPersistenceId(Integer constraintId, String persistenceId) {
        constraintToPersistenceId.put(constraintId, persistenceId);
    }

    public static Map<Integer, RopeConstraintData> getActiveConstraints() {
        return new HashMap<Integer, RopeConstraintData>(activeConstraints);
    }

    public static void addConstraintToTracker(ServerLevel level, Integer constraintId, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, double compliance, double maxForce, RopeConstraintData.ConstraintType constraintType, BlockPos sourceBlockPos, RopeStyles.RopeStyle style) {
        if (activeConstraints.containsKey(constraintId)) {
            return;
        }
        RopeConstraintData data = new RopeConstraintData(level, shipA, shipB, localPosA, localPosB, maxLength, compliance, maxForce, constraintType, sourceBlockPos, style);
        activeConstraints.put(constraintId, data);
        NetworkHandler.sendConstraintAdd(constraintId, shipA, shipB, localPosA, localPosB, maxLength, style);
    }

    private static boolean isShipValid(ServerLevel level, Long shipId, Long groundBodyId) {
        if (shipId == null) {
            return false;
        }
        if (shipId.equals(groundBodyId)) {
            return true;
        }
        try {
            boolean exists;
            ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
            ServerShip ship = (ServerShip)shipWorld.getAllShips().getById(shipId.longValue());
            boolean bl = exists = ship != null;
            if (!exists) {
                QueryableShipData queryableShipData = shipWorld.getAllShips();
            }
            return exists;
        }
        catch (Exception e) {
            System.err.println("Exception checking ship validity for " + shipId + ": " + e.getMessage());
            return false;
        }
    }

    private static void scheduleDelayedValidation(ServerLevel level, Integer constraintId, long delayMs) {
        delayedValidations.put(constraintId, System.currentTimeMillis() + delayMs);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            for (Map.Entry entry : activeConstraints.entrySet()) {
                Integer constraintId = (Integer)entry.getKey();
                RopeConstraintData data = (RopeConstraintData)entry.getValue();
                NetworkHandler.sendConstraintAddToPlayer(player2, constraintId, data.shipA, data.shipB, data.localPosA, data.localPosB, data.maxLength, data.style);
            }
            NetworkHandler.sendClearAllConstraintsToPlayer(player2);
            ConstraintTracker.syncAllConstraintsToPlayer(player2);
            lastJoinTime = System.currentTimeMillis();
        }
    }

    public static void cleanupOrphanedConstraints(ServerLevel level, BlockPos sourceBlockPos) {
        ArrayList<Integer> constraintsToRemove = new ArrayList<Integer>();
        for (Map.Entry<Integer, RopeConstraintData> entry : activeConstraints.entrySet()) {
            Integer constraintId = entry.getKey();
            RopeConstraintData data = entry.getValue();
            if (data.constraintType != RopeConstraintData.ConstraintType.ROPE_PULLEY || data.sourceBlockPos == null || !data.sourceBlockPos.equals((Object)sourceBlockPos)) continue;
            constraintsToRemove.add(constraintId);
        }
        for (Integer constraintId : constraintsToRemove) {
            try {
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).removeConstraint(constraintId.intValue());
                ConstraintTracker.removeConstraintWithPersistence(level, constraintId);
            }
            catch (Exception exception) {}
        }
    }

    private static boolean areAttachmentChunksLoaded(ServerLevel level, RopeConstraintData data, Long groundBodyId) {
        try {
            Vector3d worldPosA = data.getWorldPosA(level, 0.0f);
            BlockPos blockPosA = new BlockPos((int)Math.floor(worldPosA.x), (int)Math.floor(worldPosA.y), (int)Math.floor(worldPosA.z));
            Vector3d worldPosB = data.getWorldPosB(level, 0.0f);
            BlockPos blockPosB = new BlockPos((int)Math.floor(worldPosB.x), (int)Math.floor(worldPosB.y), (int)Math.floor(worldPosB.z));
            boolean chunkALoaded = level.m_46749_(blockPosA);
            boolean chunkBLoaded = level.m_46749_(blockPosB);
            return chunkALoaded && chunkBLoaded;
        }
        catch (Exception e) {
            System.err.println("Error checking chunk loading status: " + e.getMessage());
            return false;
        }
    }

    public static void validateAndCleanupConstraints(ServerLevel level) {
        Long groundBodyId;
        if (System.currentTimeMillis() - lastJoinTime < 15000L) {
            return;
        }
        ArrayList<Integer> constraintsToRemove = new ArrayList<Integer>();
        try {
            groundBodyId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
        }
        catch (Exception e) {
            return;
        }
        if (groundBodyId == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        ArrayList<Integer> delayedToProcess = new ArrayList<Integer>();
        for (Map.Entry<Integer, Long> entry : delayedValidations.entrySet()) {
            if (currentTime < entry.getValue()) continue;
            delayedToProcess.add(entry.getKey());
        }
        for (Integer n : delayedToProcess) {
            delayedValidations.remove(n);
            RopeConstraintData data = activeConstraints.get(n);
            if (data == null) continue;
            boolean shipAExists = ConstraintTracker.isShipValid(level, data.shipA, groundBodyId);
            boolean shipBExists = ConstraintTracker.isShipValid(level, data.shipB, groundBodyId);
            if (shipAExists && shipBExists) continue;
            constraintsToRemove.add(n);
        }
        for (Map.Entry<Integer, Object> entry : activeConstraints.entrySet()) {
            Integer constraintId = entry.getKey();
            RopeConstraintData data = (RopeConstraintData)entry.getValue();
            if (delayedValidations.containsKey(constraintId)) continue;
            boolean shipAExists = ConstraintTracker.isShipValid(level, data.shipA, groundBodyId);
            boolean shipBExists = ConstraintTracker.isShipValid(level, data.shipB, groundBodyId);
            if (!shipAExists || !shipBExists) {
                ConstraintTracker.scheduleDelayedValidation(level, constraintId, 5000L);
                continue;
            }
            if (!ConstraintTracker.areAttachmentChunksLoaded(level, data, groundBodyId)) continue;
            boolean validA = ConstraintTracker.isValidAttachmentPoint(level, data.localPosA, data.shipA, groundBodyId, data.isShipA);
            boolean validB = ConstraintTracker.isValidAttachmentPoint(level, data.localPosB, data.shipB, groundBodyId, data.isShipB);
            if (validA && validB) continue;
            ConstraintTracker.scheduleDelayedValidation(level, constraintId, 5000L);
        }
        for (Integer n : constraintsToRemove) {
            try {
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).removeConstraint(n.intValue());
                ConstraintTracker.removeConstraintWithPersistence(level, n);
            }
            catch (Exception exception) {}
        }
    }

    public static boolean constraintExists(ServerLevel level, Integer constraintId) {
        if (constraintId == null) {
            return false;
        }
        try {
            ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
            return ConstraintTracker.getActiveConstraints().containsKey(constraintId);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidAttachmentPoint(ServerLevel level, Vector3d localPos, Long shipId, Long groundBodyId, boolean isShip) {
        try {
            if (!isShip) {
                BlockPos blockPos = BlockPos.m_274561_((double)localPos.x, (double)localPos.y, (double)localPos.z);
                if (!level.m_46749_(blockPos)) {
                    return false;
                }
                BlockState state = level.m_8055_(blockPos);
                return !state.m_60795_();
            }
            Ship ship = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue());
            if (ship == null) {
                return false;
            }
            Vector3d worldPos = new Vector3d();
            ship.getTransform().getShipToWorld().transformPosition((Vector3dc)localPos, worldPos);
            BlockPos worldBlockPos = BlockPos.m_274561_((double)worldPos.x, (double)worldPos.y, (double)worldPos.z);
            if (!level.m_46749_(worldBlockPos)) {
                return false;
            }
            BlockState state = level.m_8055_(worldBlockPos);
            return !state.m_60795_();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<FluidConverterLink> getFluidLinks(Level level) {
        ResourceKey dim = level.m_46472_();
        return fluidConstraints.values().stream().filter(link -> link.level().equals((Object)dim)).toList();
    }

    public static void addFluidConstraint(int id, Long shipIdA, Vector3d localPosA, Long shipIdB, Vector3d localPosB, ResourceKey<Level> level) {
        fluidConstraints.put(id, new FluidConverterLink(shipIdA, localPosA, shipIdB, localPosB, level));
    }

    public static void removeFluidConstraint(int constraintId) {
        fluidConstraints.remove(constraintId);
        System.out.println("Removed fluid constraint " + constraintId);
    }

    public static void validateFluidConstraints(ServerLevel level) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        Long groundId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
        for (Map.Entry<Integer, FluidConverterLink> entry : fluidConstraints.entrySet()) {
            boolean existsB;
            FluidConverterLink data = entry.getValue();
            if (!data.level().equals((Object)level.m_46472_())) continue;
            Vector3d worldPosA = data.shipA().equals(groundId) ? data.localA() : ((ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(data.shipA().longValue())).getTransform().getShipToWorld().transformPosition((Vector3dc)data.localA(), new Vector3d());
            Vector3d worldPosB = data.shipB().equals(groundId) ? data.localB() : ((ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(data.shipB().longValue())).getTransform().getShipToWorld().transformPosition((Vector3dc)data.localB(), new Vector3d());
            BlockPos posA = new BlockPos((int)Math.floor(worldPosA.x), (int)Math.floor(worldPosA.y), (int)Math.floor(worldPosA.z));
            BlockPos posB = new BlockPos((int)Math.floor(worldPosB.x), (int)Math.floor(worldPosB.y), (int)Math.floor(worldPosB.z));
            boolean existsA = level.m_46749_(posA) && !level.m_8055_(posA).m_60795_();
            boolean bl = existsB = level.m_46749_(posB) && !level.m_8055_(posB).m_60795_();
            if (existsA && existsB) continue;
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(ConstraintTracker::removeFluidConstraint);
    }

    public static Map<Integer, FluidConverterLink> getFluidConstraints() {
        return new HashMap<Integer, FluidConverterLink>(fluidConstraints);
    }

    public static class RopeConstraintData {
        public final Long shipA;
        public final Long shipB;
        public final Vector3d localPosA;
        public final Vector3d localPosB;
        public final double maxLength;
        public final double compliance;
        public final double maxForce;
        public final ConstraintType constraintType;
        public final BlockPos sourceBlockPos;
        public final BlockPos anchorBlockPosA;
        public final BlockPos anchorBlockPosB;
        public final boolean isShipA;
        public final boolean isShipB;
        public RopeStyles.RopeStyle style;

        public RopeConstraintData(ServerLevel level, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, double compliance, double maxForce, ConstraintType constraintType, BlockPos sourceBlockPos, RopeStyles.RopeStyle style) {
            this.shipA = shipA;
            this.shipB = shipB;
            this.localPosA = new Vector3d((Vector3dc)localPosA);
            this.localPosB = new Vector3d((Vector3dc)localPosB);
            this.maxLength = maxLength;
            this.compliance = compliance;
            this.maxForce = maxForce;
            this.constraintType = constraintType;
            this.sourceBlockPos = sourceBlockPos;
            this.anchorBlockPosA = null;
            this.anchorBlockPosB = null;
            this.style = style;
            Long groundBodyId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
            this.isShipA = !shipA.equals(groundBodyId);
            this.isShipB = !shipB.equals(groundBodyId);
        }

        public RopeConstraintData(ServerLevel level, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, double compliance, double maxForce, RopeStyles.RopeStyle style) {
            this(level, shipA, shipB, localPosA, localPosB, maxLength, compliance, maxForce, ConstraintType.GENERIC, null, style);
        }

        public Vector3d getWorldPosA(ServerLevel level, float partialTick) {
            try {
                Long groundBodyId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
                if (this.shipA.equals(groundBodyId)) {
                    return new Vector3d((Vector3dc)this.localPosA);
                }
                Ship shipObject = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(this.shipA.longValue());
                if (shipObject != null) {
                    Vector3d worldPos = new Vector3d();
                    shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)this.localPosA, worldPos);
                    return worldPos;
                }
                return new Vector3d((Vector3dc)this.localPosA);
            }
            catch (Exception e) {
                return new Vector3d((Vector3dc)this.localPosA);
            }
        }

        public Vector3d getWorldPosB(ServerLevel level, float partialTick) {
            try {
                Long groundBodyId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
                if (this.shipB.equals(groundBodyId)) {
                    return new Vector3d((Vector3dc)this.localPosB);
                }
                Ship shipObject = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(this.shipB.longValue());
                if (shipObject != null) {
                    Vector3d worldPos = new Vector3d();
                    shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)this.localPosB, worldPos);
                    return worldPos;
                }
                return new Vector3d((Vector3dc)this.localPosB);
            }
            catch (Exception e) {
                return new Vector3d((Vector3dc)this.localPosB);
            }
        }

        public static enum ConstraintType {
            ROPE_PULLEY,
            GENERIC;

        }
    }

    public record FluidConverterLink(Long shipA, Vector3d localA, Long shipB, Vector3d localB, ResourceKey<Level> level) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FluidConverterLink)) {
                return false;
            }
            FluidConverterLink other = (FluidConverterLink)obj;
            return Objects.equals(this.shipA, other.shipA) && this.localA.equals((Object)other.localA) && Objects.equals(this.shipB, other.shipB) && this.localB.equals((Object)other.localB) && this.level.equals(other.level);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.shipA, this.localA, this.shipB, this.localB, this.level);
        }

        @Override
        public String toString() {
            return "FluidConverterLink{shipA=" + this.shipA + ", localA=" + this.localA + ", shipB=" + this.shipB + ", localB=" + this.localB + ", level=" + this.level + "}";
        }

        public Vector3d worldA(Level level) {
            Ship ship = VSGameUtilsKt.getShipObjectWorld((Level)level).getAllShips().getById(this.shipA.longValue());
            if (ship == null) {
                return this.localA;
            }
            return ship.getTransform().getShipToWorld().transformPosition((Vector3dc)this.localA, new Vector3d());
        }

        public Vector3d worldB(Level level) {
            Ship ship = VSGameUtilsKt.getShipObjectWorld((Level)level).getAllShips().getById(this.shipB.longValue());
            if (ship == null) {
                return this.localB;
            }
            return ship.getTransform().getShipToWorld().transformPosition((Vector3dc)this.localB, new Vector3d());
        }
    }

    public static class FluidConstraintData {
        public final BlockPos posA;
        public final BlockPos posB;
        public final ResourceKey<Level> dimension;

        public FluidConstraintData(BlockPos posA, BlockPos posB, ResourceKey<Level> dimension) {
            this.posA = posA;
            this.posB = posB;
            this.dimension = dimension;
        }
    }
}

