/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.constraint;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.client.NetworkHandler;
import yay.evy.everest.vstuff.content.constraint.ConstraintPersistence;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;
import yay.evy.everest.vstuff.content.constraint.RopeUtil;
import yay.evy.everest.vstuff.index.VStuffItems;
import yay.evy.everest.vstuff.util.RopeStyles;

public class LeadBreakItem
extends Item {
    public LeadBreakItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ServerLevel serverLevel;
        Integer targetConstraintId;
        ItemStack itemStack = player.m_21120_(hand);
        if (level instanceof ServerLevel && (targetConstraintId = RopeUtil.findTargetedLead(serverLevel = (ServerLevel)level, player)) != null) {
            try {
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).removeConstraint(targetConstraintId.intValue());
                ConstraintTracker.RopeConstraintData data = ConstraintTracker.getActiveConstraints().get(targetConstraintId);
                ConstraintTracker.removeConstraintWithPersistence(serverLevel, targetConstraintId);
                NetworkHandler.sendConstraintRemove(targetConstraintId);
                this.forceRemoveConstraint(serverLevel, targetConstraintId);
                RopeStyles.PrimitiveRopeStyle style = data != null ? data.style.getBasicStyle() : RopeStyles.PrimitiveRopeStyle.NORMAL;
                MutableComponent notif = style == RopeStyles.PrimitiveRopeStyle.CHAIN ? Component.m_237115_((String)"vstuff.message.chain_break") : Component.m_237115_((String)"vstuff.message.rope_break");
                player.m_5661_((Component)notif, true);
                if (((Boolean)VstuffConfig.ROPE_SOUNDS.get()).booleanValue()) {
                    SoundEvent sound = style == RopeStyles.PrimitiveRopeStyle.CHAIN ? SoundEvents.f_11794_ : SoundEvents.f_12033_;
                    serverLevel.m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (data != null && data.sourceBlockPos != null) {
                    ConstraintTracker.cleanupOrphanedConstraints(serverLevel, data.sourceBlockPos);
                }
                if (ConstraintTracker.getActiveConstraints().containsKey(targetConstraintId)) {
                    VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).removeConstraint(targetConstraintId.intValue());
                    ConstraintTracker.removeConstraintWithPersistence(serverLevel, targetConstraintId);
                    NetworkHandler.sendConstraintRemove(targetConstraintId);
                    this.forceRemoveConstraint(serverLevel, targetConstraintId);
                    ConstraintPersistence persistence = ConstraintPersistence.get(serverLevel);
                    persistence.saveNow(serverLevel);
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    player.m_36176_(new ItemStack((ItemLike)VStuffItems.LEAD_CONSTRAINT_ITEM.get()), false);
                }
                return InteractionResultHolder.m_19090_((Object)itemStack);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    private void forceRemoveConstraint(ServerLevel level, int id) {
        ConstraintTracker.RopeConstraintData data = ConstraintTracker.getActiveConstraints().get(id);
        try {
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).removeConstraint(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConstraintPersistence persistence = ConstraintPersistence.get(level);
        persistence.saveNow(level);
        ConstraintTracker.removeConstraintWithPersistence(level, id);
        ConstraintTracker.getActiveConstraints().remove(id);
        NetworkHandler.sendConstraintRemove(id);
        if (data != null) {
            if (data.anchorBlockPosA != null) {
                ConstraintTracker.cleanupOrphanedConstraints(level, data.anchorBlockPosA);
            }
            if (data.anchorBlockPosB != null) {
                ConstraintTracker.cleanupOrphanedConstraints(level, data.anchorBlockPosB);
            }
        }
    }
}

