/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.constraint;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.VStuff;
import yay.evy.everest.vstuff.client.ClientRopeUtil;
import yay.evy.everest.vstuff.content.constraint.Rope;
import yay.evy.everest.vstuff.content.constraint.RopeUtil;
import yay.evy.everest.vstuff.content.pulley.PhysPulleyBlockEntity;
import yay.evy.everest.vstuff.content.pulley.PhysPulleyItem;
import yay.evy.everest.vstuff.content.ropestyler.handler.RopeStyleHandlerServer;
import yay.evy.everest.vstuff.util.RopeStyles;

public class LeadConstraintItem
extends Item {
    private BlockPos firstClickedPos;
    private Long firstShipId;
    private Entity firstEntity;
    private Integer activeConstraintId;
    private ResourceKey<Level> firstClickDimension;

    public LeadConstraintItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        ServerLevel serverLevel;
        Player player;
        BlockPos clickedPos;
        block10: {
            block9: {
                Level level = context.m_43725_();
                clickedPos = context.m_8083_().m_7949_();
                player = context.m_43723_();
                if (level.m_5776_()) {
                    ClientRopeUtil.drawOutline(level, clickedPos);
                    return InteractionResult.SUCCESS;
                }
                if (!(level instanceof ServerLevel)) break block9;
                serverLevel = (ServerLevel)level;
                if (player != null) break block10;
            }
            return InteractionResult.PASS;
        }
        PhysPulleyBlockEntity pulley = PhysPulleyItem.getWaitingPulley(player);
        if (pulley != null) {
            pulley.targetPos = clickedPos;
            pulley.hasTarget = true;
            pulley.waitingForTarget = false;
            pulley.m_6596_();
            pulley.sendData();
            pulley.createManualConstraint();
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7aPulley target set and constraint created!"));
            PhysPulleyItem.clearWaitingPulley(player);
            return InteractionResult.SUCCESS;
        }
        if (this.firstClickedPos == null && this.firstEntity == null) {
            this.firstClickedPos = clickedPos;
            this.firstShipId = this.getShipIdAtPos(serverLevel, clickedPos);
            this.firstClickDimension = serverLevel.m_46472_();
            player.m_5661_((Component)Component.m_237115_((String)"vstuff.message.rope_first"), true);
            return InteractionResult.SUCCESS;
        }
        if (this.firstClickedPos != null && (player.m_6144_() || this.firstClickedPos.equals((Object)clickedPos))) {
            this.resetState();
            player.m_5661_((Component)Component.m_237115_((String)"vstuff.message.rope_reset"), true);
            return InteractionResult.SUCCESS;
        }
        if (!serverLevel.m_46472_().equals(this.firstClickDimension)) {
            player.m_5661_((Component)Component.m_237115_((String)"vstuff.message.interdimensional_fail"), true);
            this.resetState();
            return InteractionResult.FAIL;
        }
        Long secondShipId = this.getShipIdAtPos(serverLevel, clickedPos);
        RopeUtil.RopeInteractionReturn result = Rope.createNew(this, serverLevel, this.firstClickedPos, clickedPos, this.firstEntity, this.firstShipId, secondShipId, player);
        if (result == RopeUtil.RopeInteractionReturn.SUCCESS) {
            MutableComponent notif = RopeStyleHandlerServer.getStyle(player.m_20148_()).getBasicStyle() == RopeStyles.PrimitiveRopeStyle.CHAIN ? Component.m_237115_((String)"vstuff.message.chain_created") : Component.m_237115_((String)"vstuff.message.rope_created");
            player.m_5661_((Component)notif, true);
        }
        this.resetState();
        return result == RopeUtil.RopeInteractionReturn.SUCCESS ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public void setActiveConstraintId(Integer id) {
        this.activeConstraintId = id;
    }

    private Long getShipIdAtPos(ServerLevel level, BlockPos pos) {
        LoadedServerShip shipObject = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)pos);
        return shipObject != null ? Long.valueOf(shipObject.getId()) : null;
    }

    private void resetState() {
        this.firstClickedPos = null;
        this.firstShipId = null;
        this.firstEntity = null;
        this.firstClickDimension = null;
        VStuff.LOGGER.info("Reset LeadConstraintItem state");
    }
}

