/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.constraint;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSRopeConstraint;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.VStuff;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.client.NetworkHandler;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;
import yay.evy.everest.vstuff.content.constraint.LeadConstraintItem;
import yay.evy.everest.vstuff.content.constraint.RopeUtil;
import yay.evy.everest.vstuff.content.ropestyler.handler.RopeStyleHandlerServer;
import yay.evy.everest.vstuff.util.RopeStyles;
import yay.evy.everest.vstuff.util.packet.RopeSoundPacket;

@Mod.EventBusSubscriber(modid="vstuff", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Rope {
    public static RopeUtil.RopeInteractionReturn createNew(LeadConstraintItem ropeItem, ServerLevel level, BlockPos firstClickedPos, BlockPos secondClickedPos, Entity firstEntity, Long firstShipId, Long secondShipId, Player player) {
        Vector3d firstLocalPos;
        Long shipA;
        Vector3d firstWorldPos;
        if (firstClickedPos == null && firstEntity == null) {
            return RopeUtil.RopeInteractionReturn.FAIL;
        }
        if (firstEntity != null) {
            firstWorldPos = new Vector3d(firstEntity.m_20185_(), firstEntity.m_20186_() + (double)(firstEntity.m_20206_() / 2.0f), firstEntity.m_20189_());
            shipA = firstShipId != null ? firstShipId : RopeUtil.getGroundBodyId(level);
            firstLocalPos = RopeUtil.convertWorldToLocal(level, firstWorldPos, shipA);
        } else {
            firstWorldPos = RopeUtil.getWorldPosition(level, firstClickedPos, firstShipId);
            shipA = firstShipId != null ? firstShipId : RopeUtil.getGroundBodyId(level);
            firstLocalPos = RopeUtil.getLocalPositionFixed(level, firstClickedPos, firstShipId, shipA);
        }
        Vector3d secondWorldPos = RopeUtil.getWorldPosition(level, secondClickedPos, secondShipId);
        Long shipB = secondShipId != null ? secondShipId : RopeUtil.getGroundBodyId(level);
        Vector3d secondLocalPos = RopeUtil.getLocalPositionFixed(level, secondClickedPos, secondShipId, shipB);
        return Rope.createNew(ropeItem, level, shipA, shipB, firstLocalPos, secondLocalPos, firstWorldPos, secondWorldPos, player);
    }

    public static RopeUtil.RopeInteractionReturn createNew(LeadConstraintItem ropeItem, ServerLevel level, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, Vector3d worldPosA, Vector3d worldPosB, Player player) {
        double massB;
        Vector3d finalWorldPosB;
        Vector3d finalWorldPosA;
        Vector3d finalLocalPosB;
        Vector3d finalLocalPosA;
        Long finalShipB;
        Long finalShipA;
        Long groundBodyId = RopeUtil.getGroundBodyId(level);
        boolean shipAIsWorld = shipA.equals(groundBodyId);
        boolean shipBIsWorld = shipB.equals(groundBodyId);
        if (shipAIsWorld && !shipBIsWorld) {
            finalShipA = shipB;
            finalShipB = shipA;
            finalLocalPosA = localPosB;
            finalLocalPosB = localPosA;
            finalWorldPosA = worldPosB;
            finalWorldPosB = worldPosA;
        } else {
            finalShipA = shipA;
            finalShipB = shipB;
            finalLocalPosA = localPosA;
            finalLocalPosB = localPosB;
            finalWorldPosA = worldPosA;
            finalWorldPosB = worldPosB;
        }
        double distance = finalWorldPosA.distance((Vector3dc)finalWorldPosB);
        double maxAllowedLength = (Double)VstuffConfig.MAX_ROPE_LENGTH.get();
        if (distance > maxAllowedLength) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7cRope too long! Max length is " + maxAllowedLength + " blocks.")), true);
            }
            return RopeUtil.RopeInteractionReturn.FAIL;
        }
        double maxLength = distance + 0.5;
        double massA = RopeUtil.getMassForShip(level, finalShipA);
        double effectiveMass = Math.min(massA, massB = RopeUtil.getMassForShip(level, finalShipB).doubleValue());
        if (effectiveMass < 100.0) {
            effectiveMass = 100.0;
        }
        double compliance = 1.0E-12 / effectiveMass;
        double massRatio = Math.max(massA, massB) / Math.min(massA, massB);
        double baseMaxForce = 5.0E13;
        double maxForce = baseMaxForce * Math.min(massRatio, 20.0);
        if (shipAIsWorld || shipBIsWorld) {
            maxForce *= 10.0;
            compliance *= 0.05;
        }
        VSRopeConstraint ropeConstraint = new VSRopeConstraint(finalShipA.longValue(), finalShipB.longValue(), compliance, (Vector3dc)finalLocalPosA, (Vector3dc)finalLocalPosB, maxForce, maxLength);
        try {
            Integer constraintId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createNewConstraint((VSConstraint)ropeConstraint);
            if (constraintId != null) {
                ropeItem.setActiveConstraintId(constraintId);
                ConstraintTracker.addConstraintWithPersistence(level, constraintId, finalShipA, finalShipB, finalLocalPosA, finalLocalPosB, maxLength, compliance, maxForce, RopeStyleHandlerServer.getStyle(player.m_20148_()));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    RopeStyles.RopeStyle ropeStyle = RopeStyleHandlerServer.getStyle(player.m_20148_());
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new RopeSoundPacket(false, ropeStyle.getBasicStyle()));
                    ConstraintTracker.syncAllConstraintsToPlayer(serverPlayer);
                }
                if (player != null && !player.m_150110_().f_35937_) {
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        ItemStack stack = player.m_150109_().m_8020_(i);
                        if (!(stack.m_41720_() instanceof LeadConstraintItem)) continue;
                        stack.m_41774_(1);
                        break;
                    }
                }
                return RopeUtil.RopeInteractionReturn.SUCCESS;
            }
        }
        catch (Exception e) {
            VStuff.LOGGER.error("Error creating rope constraint: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return RopeUtil.RopeInteractionReturn.FAIL;
    }
}

