/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.constraint;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;

public class RopeUtil {
    public static Vector3d convertWorldToLocal(ServerLevel level, Vector3d worldPos, Long shipId) {
        Ship shipObject;
        if (shipId != null && !shipId.equals(RopeUtil.getGroundBodyId(level)) && (shipObject = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue())) != null) {
            Vector3d localPos = new Vector3d();
            shipObject.getTransform().getWorldToShip().transformPosition((Vector3dc)worldPos, localPos);
            return localPos;
        }
        return new Vector3d((Vector3dc)worldPos);
    }

    public static Long getShipIdAtPos(ServerLevel level, BlockPos pos) {
        LoadedServerShip shipObject = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)pos);
        return shipObject != null ? Long.valueOf(shipObject.getId()) : null;
    }

    public static Long getGroundBodyId(ServerLevel level) {
        return (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
    }

    public static Vector3d getWorldPosition(ServerLevel level, BlockPos pos, Long shipId) {
        Ship shipObject;
        Vector3d localPos = new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (shipId != null && (shipObject = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue())) != null) {
            Vector3d worldPos = new Vector3d();
            shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)localPos, worldPos);
            return worldPos;
        }
        return localPos;
    }

    public static Vector3d getLocalPositionFixed(ServerLevel level, BlockPos pos, Long clickedShipId, Long targetShipId) {
        Vector3d blockPos = new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (clickedShipId != null && clickedShipId.equals(targetShipId)) {
            return blockPos;
        }
        if (targetShipId.equals(RopeUtil.getGroundBodyId(level))) {
            Ship clickedShip;
            if (clickedShipId != null && (clickedShip = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(clickedShipId.longValue())) != null) {
                Vector3d worldPos = new Vector3d();
                clickedShip.getTransform().getShipToWorld().transformPosition((Vector3dc)blockPos, worldPos);
                return worldPos;
            }
            return blockPos;
        }
        Ship targetShip = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(targetShipId.longValue());
        if (targetShip != null) {
            Ship clickedShip;
            Vector3d worldPos = blockPos;
            if (clickedShipId != null && !clickedShipId.equals(targetShipId) && (clickedShip = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(clickedShipId.longValue())) != null) {
                worldPos = new Vector3d();
                clickedShip.getTransform().getShipToWorld().transformPosition((Vector3dc)blockPos, worldPos);
            }
            Vector3d localPos = new Vector3d();
            targetShip.getTransform().getWorldToShip().transformPosition((Vector3dc)worldPos, localPos);
            return localPos;
        }
        return blockPos;
    }

    public static Double getMassForShip(ServerLevel level, Long shipId) {
        Long groundBodyId = RopeUtil.getGroundBodyId(level);
        if (shipId.equals(groundBodyId)) {
            return 1.0E12;
        }
        Ship shipObject = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue());
        if (shipObject != null) {
            try {
                double mass = 1000.0;
                AABBic bounds = shipObject.getShipAABB();
                if (bounds != null) {
                    double volume = (bounds.maxX() - bounds.minX()) * (bounds.maxY() - bounds.minY()) * (bounds.maxZ() - bounds.minZ());
                    mass = Math.max(volume * 10.0, 1000.0);
                }
                return Math.min(mass, 1.0E9);
            }
            catch (Exception e) {
                return 1000.0;
            }
        }
        return 1000.0;
    }

    public static double getDistanceToRope(Vec3 eyePos, Vec3 lookVec, Vector3d ropeStart, Vector3d ropeEnd, double maxDistance) {
        Vec3 start = new Vec3(ropeStart.x, ropeStart.y, ropeStart.z);
        Vec3 end = new Vec3(ropeEnd.x, ropeEnd.y, ropeEnd.z);
        double minDistanceToRope = Double.MAX_VALUE;
        for (double t = 0.0; t <= maxDistance; t += 0.5) {
            Vec3 rayPoint = eyePos.m_82549_(lookVec.m_82490_(t));
            Vec3 ropeVec = end.m_82546_(start);
            Vec3 startToRay = rayPoint.m_82546_(start);
            double ropeLength = ropeVec.m_82553_();
            if (ropeLength < 0.01) continue;
            double projection = startToRay.m_82526_(ropeVec) / (ropeLength * ropeLength);
            projection = Math.max(0.0, Math.min(1.0, projection));
            Vec3 closestPointOnRope = start.m_82549_(ropeVec.m_82490_(projection));
            double distanceToRope = rayPoint.m_82554_(closestPointOnRope);
            minDistanceToRope = Math.min(minDistanceToRope, distanceToRope);
        }
        return minDistanceToRope;
    }

    public static Integer findTargetedLead(ServerLevel level, Player player) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        double maxDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        Integer closestConstraintId = null;
        for (Map.Entry<Integer, ConstraintTracker.RopeConstraintData> entry : ConstraintTracker.getActiveConstraints().entrySet()) {
            Vector3d worldPosB;
            Integer constraintId = entry.getKey();
            ConstraintTracker.RopeConstraintData constraint = entry.getValue();
            Vector3d worldPosA = constraint.getWorldPosA(level, 1.0f);
            double distance = RopeUtil.getDistanceToRope(eyePos, lookVec, worldPosA, worldPosB = constraint.getWorldPosB(level, 1.0f), maxDistance);
            if (!(distance < minDistance) || !(distance <= 1.0)) continue;
            minDistance = distance;
            closestConstraintId = constraintId;
        }
        return closestConstraintId;
    }

    public static enum RopeInteractionReturn {
        SUCCESS,
        FAIL,
        RESET;

    }
}

