/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.physgrabber;

import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import yay.evy.everest.vstuff.content.thrust.AttachmentUtils;

public class PhysGrabberServerAttachment
implements ShipForcesInducer {
    private final Vector3d targetPos = new Vector3d();
    private boolean active = false;
    private boolean isCreative = false;
    private static final double MAX_SPEED = 20.0;

    public void applyForces(PhysShip physShip) {
        if (!this.active) {
            return;
        }
        PhysShipImpl ship = (PhysShipImpl)physShip;
        Vector3dc shipPos = ship.getTransform().getPositionInWorld();
        Vector3d toTarget = new Vector3d((Vector3dc)this.targetPos).sub(shipPos);
        double distance = toTarget.length();
        if (distance < 0.05) {
            return;
        }
        double pullSpeed = Math.min(20.0, distance * 2.0);
        Vector3d desiredVel = new Vector3d((Vector3dc)toTarget).normalize().mul(pullSpeed);
        Vector3d currentVel = new Vector3d(ship.getPoseVel().getVel());
        double smoothingFactor = 0.1;
        Vector3d velChange = desiredVel.sub((Vector3dc)currentVel).mul(smoothingFactor);
        double mass = ship.getInertia().getShipMass();
        Vector3d force = new Vector3d((Vector3dc)velChange).mul(mass);
        double maxForce = this.isCreative ? Double.MAX_VALUE : 10000.0;
        force.x = Math.max(Math.min(force.x, maxForce), -maxForce);
        force.y = Math.max(Math.min(force.y, maxForce), -maxForce);
        force.z = Math.max(Math.min(force.z, maxForce), -maxForce);
        ship.applyInvariantForce((Vector3dc)force);
    }

    public void setTarget(Vector3d newTarget) {
        this.targetPos.set((Vector3dc)newTarget);
        this.active = true;
    }

    public void release() {
        this.active = false;
    }

    public void setCreative(boolean creative) {
        this.isCreative = creative;
    }

    public static PhysGrabberServerAttachment getOrCreate(LoadedServerShip ship) {
        PhysGrabberServerAttachment grabber = AttachmentUtils.getOrCreate(ship, PhysGrabberServerAttachment.class, PhysGrabberServerAttachment::new);
        ship.saveAttachment(PhysGrabberServerAttachment.class, (Object)grabber);
        return grabber;
    }
}

