/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.thrust;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class AttachmentUtils {
    private AttachmentUtils() {
    }

    @Nullable
    public static LoadedServerShip getShipAt(ServerLevel serverLevel, BlockPos pos) {
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pos);
        if (ship == null) {
            ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pos);
        }
        return ship;
    }

    public static <T> T getOrCreate(LoadedServerShip ship, Class<T> attachmentClass, Supplier<T> factory) {
        Object attachment = ship.getAttachment(attachmentClass);
        if (attachment == null) {
            attachment = factory.get();
            ship.saveAttachment(attachmentClass, attachment);
        }
        return (T)attachment;
    }

    @Nullable
    public static <T> T get(Level level, BlockPos pos, Class<T> attachmentClass, Supplier<T> factory) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        LoadedServerShip ship = AttachmentUtils.getShipAt(serverLevel, pos);
        return ship != null ? (T)AttachmentUtils.getOrCreate(ship, attachmentClass, factory) : null;
    }
}

