/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.thrust;

import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OrientedBB;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import yay.evy.everest.vstuff.MathUtility;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.content.thrust.AbstractThrusterBlock;
import yay.evy.everest.vstuff.content.thrust.AbstractThrusterBlockEntity;

public class ThrusterDamager {
    private static final int TICKS_PER_ENTITY_CHECK = 5;
    private static final int LOWEST_POWER_THRSHOLD = 5;
    private final AbstractThrusterBlockEntity thruster;

    public ThrusterDamager(AbstractThrusterBlockEntity thruster) {
        this.thruster = thruster;
    }

    public void tick(int currentTick) {
        if (!this.shouldDamageEntities()) {
            return;
        }
        if (currentTick % 5 == 0) {
            this.doEntityDamageCheck();
        }
    }

    private boolean shouldDamageEntities() {
        return (Boolean)VstuffConfig.THRUSTER_DAMAGE_ENTITIES.get() != false && this.thruster.isWorking();
    }

    private void doEntityDamageCheck() {
        float distanceByPower = Math.lerp((float)0.55f, (float)1.5f, (float)1.0f);
        Direction plumeDirection = ((Direction)this.thruster.m_58900_().m_61143_((Property)AbstractThrusterBlock.FACING)).m_122424_();
        AABB plumeAABB = this.calculateAabb(plumeDirection, distanceByPower);
        List damageCandidates = this.thruster.m_58904_().m_45933_(null, plumeAABB);
        if (damageCandidates.isEmpty()) {
            return;
        }
        NozzleInfo nozzleInfo = this.calculateNozzleInfo(plumeDirection);
        Vector3d localPlumeVec = new Vector3d(0.0, 0.0, 1.0);
        nozzleInfo.obbRotationWorldJOML().transform(localPlumeVec);
        Vec3 worldPlumeDirection = VectorConversionsMCKt.toMinecraft((Vector3dc)localPlumeVec);
        double potentialPlumeLength = (float)this.thruster.getEmptyBlocks() * distanceByPower * this.thruster.getSpeedScalar();
        double correctedPlumeLength = this.performRaycastCheck(nozzleInfo.thrusterNozzleWorldPosMC(), worldPlumeDirection, potentialPlumeLength);
        if (correctedPlumeLength <= 0.01) {
            return;
        }
        ObbCalculationResult obbResult = this.calculateObb(plumeDirection, correctedPlumeLength, nozzleInfo);
        this.applyDamageToEntities(this.thruster.m_58904_(), damageCandidates, obbResult, 1.0f);
    }

    private NozzleInfo calculateNozzleInfo(Direction plumeDirection) {
        Quaterniond obbRotationWorldJOML;
        Vector3d thrusterCenterBlockWorldJOML;
        Quaterniond relativeRotationJOML = new Quaterniond().rotateTo((Vector3dc)new Vector3d(0.0, 0.0, 1.0), (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)plumeDirection.m_122436_()));
        BlockPos worldPosition = this.thruster.m_58899_();
        Level level = this.thruster.m_58904_();
        Vector3d thrusterCenterBlockShipCoordsJOMLD = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)worldPosition));
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)worldPosition);
        if (ship != null) {
            thrusterCenterBlockWorldJOML = ship.getShipToWorld().transformPosition((Vector3dc)thrusterCenterBlockShipCoordsJOMLD, new Vector3d());
            obbRotationWorldJOML = ship.getTransform().getShipToWorldRotation().mul((Quaterniondc)relativeRotationJOML, new Quaterniond());
        } else {
            thrusterCenterBlockWorldJOML = thrusterCenterBlockShipCoordsJOMLD;
            obbRotationWorldJOML = relativeRotationJOML;
        }
        Vector3d nozzleOffsetLocal = new Vector3d(0.0, 0.0, 0.5);
        Vector3d nozzleOffsetWorld = obbRotationWorldJOML.transform((Vector3dc)nozzleOffsetLocal, new Vector3d());
        Vector3d thrusterNozzleWorldPos = thrusterCenterBlockWorldJOML.add((Vector3dc)nozzleOffsetWorld, new Vector3d());
        Vec3 thrusterNozzleWorldPosMC = VectorConversionsMCKt.toMinecraft((Vector3dc)thrusterNozzleWorldPos);
        return new NozzleInfo(thrusterNozzleWorldPosMC, obbRotationWorldJOML, thrusterCenterBlockWorldJOML);
    }

    private double performRaycastCheck(Vec3 nozzlePos, Vec3 worldPlumeDirection, double maxDistance) {
        Vec3 endPos;
        ClipContext clipContext;
        Level level = this.thruster.m_58904_();
        BlockHitResult hitResult = level.m_45547_(clipContext = new ClipContext(nozzlePos, endPos = nozzlePos.m_82549_(worldPlumeDirection.m_82490_(maxDistance)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            return nozzlePos.m_82554_(hitResult.m_82450_());
        }
        return maxDistance;
    }

    private ObbCalculationResult calculateObb(Direction plumeDirection, double plumeLength, NozzleInfo nozzleInfo) {
        double plumeStartOffset = 0.8;
        double centerOffsetDistance = plumeStartOffset + plumeLength / 2.0;
        Vector3d relativeCenterOffsetJOML = VectorConversionsMCKt.toJOMLD((Vec3i)plumeDirection.m_122436_()).mul(centerOffsetDistance);
        BlockPos worldPosition = this.thruster.m_58899_();
        Level level = this.thruster.m_58904_();
        Vector3d thrusterCenterBlockShipCoordsJOMLD = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)worldPosition));
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)worldPosition);
        Vector3d obbCenterWorldJOML = ship != null ? ship.getShipToWorld().transformPosition((Vector3dc)relativeCenterOffsetJOML.add((Vector3dc)thrusterCenterBlockShipCoordsJOMLD, new Vector3d()), new Vector3d()) : nozzleInfo.thrusterCenterBlockWorldJOML().add((Vector3dc)relativeCenterOffsetJOML, new Vector3d());
        Vector3d plumeHalfExtentsJOML = new Vector3d(0.7, 0.7, plumeLength / 2.0);
        Vec3 plumeCenterMC = VectorConversionsMCKt.toMinecraft((Vector3dc)obbCenterWorldJOML);
        Vec3 plumeHalfExtentsMC = VectorConversionsMCKt.toMinecraft((Vector3dc)plumeHalfExtentsJOML);
        Matrix3d plumeRotationMatrix = MathUtility.createMatrixFromQuaternion(nozzleInfo.obbRotationWorldJOML());
        OrientedBB plumeOBB = new OrientedBB(plumeCenterMC, plumeHalfExtentsMC, plumeRotationMatrix);
        return new ObbCalculationResult(plumeLength, nozzleInfo.thrusterNozzleWorldPosMC(), plumeOBB, obbCenterWorldJOML, plumeHalfExtentsJOML, nozzleInfo.obbRotationWorldJOML());
    }

    private AABB calculateAabb(Direction plumeDirection, float distanceByPower) {
        BlockPos worldPosition = this.thruster.m_58899_();
        BlockPos blockBehind = worldPosition.m_121945_(plumeDirection);
        int aabbEndOffset = (int)Math.floor((float)((float)this.thruster.getEmptyBlocks() * distanceByPower)) + 1;
        BlockPos blockEnd = worldPosition.m_5484_(plumeDirection, aabbEndOffset);
        return new AABB(blockBehind).m_82367_(new AABB(blockEnd)).m_82400_(1.0);
    }

    private void applyDamageToEntities(Level level, List<Entity> damageCandidates, ObbCalculationResult obbResult, float visualPowerPercent) {
        DamageSource fireDamageSource = level.m_269111_().m_269549_();
        for (Entity entity : damageCandidates) {
            AABB entityAABB;
            if (entity.m_213877_() || entity.m_5825_() || obbResult.plumeOBB.intersect(entityAABB = entity.m_20191_()) == null) continue;
            float invSqrDistance = visualPowerPercent * 8.0f / (float)Math.max((double)1.0, (double)entity.m_20182_().m_82557_(obbResult.thrusterNozzleWorldPosMC));
            float damageAmount = 3.0f + invSqrDistance;
            entity.m_6469_(fireDamageSource, damageAmount * this.thruster.getSpeedScalar());
            entity.m_20254_(3);
        }
    }

    private void debugObb(Direction plumeDirection, float distanceByPower) {
        NozzleInfo nozzleInfo = this.calculateNozzleInfo(plumeDirection);
        Vector3d localPlumeVec = new Vector3d(0.0, 0.0, 1.0);
        nozzleInfo.obbRotationWorldJOML().transform(localPlumeVec);
        Vec3 worldPlumeDirection = VectorConversionsMCKt.toMinecraft((Vector3dc)localPlumeVec);
        double potentialPlumeLength = (float)this.thruster.getEmptyBlocks() * distanceByPower;
        double correctedPlumeLength = this.performRaycastCheck(nozzleInfo.thrusterNozzleWorldPosMC(), worldPlumeDirection, potentialPlumeLength);
        if (correctedPlumeLength <= 0.01) {
            return;
        }
        ObbCalculationResult obbResult = this.calculateObb(plumeDirection, correctedPlumeLength, nozzleInfo);
        String identifier = "thruster_" + ((Object)((Object)this.thruster)).hashCode() + "_obb";
        Quaternionf debugRotation = new Quaternionf((float)obbResult.obbRotationWorldJOML.x, (float)obbResult.obbRotationWorldJOML.y, (float)obbResult.obbRotationWorldJOML.z, (float)obbResult.obbRotationWorldJOML.w);
        Vec3 debugSize = new Vec3(obbResult.plumeHalfExtentsJOML.x * 2.0, obbResult.plumeHalfExtentsJOML.y * 2.0, obbResult.plumeHalfExtentsJOML.z * 2.0);
        Vec3 debugCenter = VectorConversionsMCKt.toMinecraft((Vector3dc)obbResult.obbCenterWorldJOML);
    }

    private record NozzleInfo(Vec3 thrusterNozzleWorldPosMC, Quaterniond obbRotationWorldJOML, Vector3d thrusterCenterBlockWorldJOML) {
    }

    private record ObbCalculationResult(double plumeLength, Vec3 thrusterNozzleWorldPosMC, OrientedBB plumeOBB, Vector3d obbCenterWorldJOML, Vector3d plumeHalfExtentsJOML, Quaterniond obbRotationWorldJOML) {
    }
}

