/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.thrust;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import yay.evy.everest.vstuff.content.thrust.AttachmentUtils;
import yay.evy.everest.vstuff.content.thrust.ThrusterForceApplier;

public class ThrusterForceAttachment
implements ShipForcesInducer {
    public Map<BlockPos, ThrusterForceApplier> appliersMapping = new ConcurrentHashMap<BlockPos, ThrusterForceApplier>();

    public void applyForces(@NotNull PhysShip physicShip) {
        PhysShipImpl ship = (PhysShipImpl)physicShip;
        this.appliersMapping.forEach((pos, applier) -> {
            float thrust = applier.data.getThrust();
            applier.applyForces((BlockPos)pos, ship);
        });
    }

    public void addApplier(BlockPos pos, ThrusterForceApplier applier) {
        this.appliersMapping.put(pos, applier);
    }

    public void removeApplier(ServerLevel level, BlockPos pos) {
        LoadedServerShip ship;
        this.appliersMapping.remove(pos);
        if (this.appliersMapping.isEmpty() && (ship = AttachmentUtils.getShipAt(level, pos)) != null) {
            ship.saveAttachment(ThrusterForceAttachment.class, null);
        }
    }

    public static ThrusterForceAttachment getOrCreateAsAttachment(LoadedServerShip ship) {
        return AttachmentUtils.getOrCreate(ship, ThrusterForceAttachment.class, ThrusterForceAttachment::new);
    }

    public static ThrusterForceAttachment get(Level level, BlockPos pos) {
        return AttachmentUtils.get(level, pos, ThrusterForceAttachment.class, ThrusterForceAttachment::new);
    }
}

