/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.network;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.content.physgrabber.PhysGrabberServerAttachment;
import yay.evy.everest.vstuff.network.PhysGrabberPackets;

public class PhysGrabberNetwork {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("vstuff", "phys_grabber"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        int id = 0;
        CHANNEL.registerMessage(id++, PhysGrabberPackets.GrabPacket.class, PhysGrabberPackets.GrabPacket::encode, PhysGrabberPackets.GrabPacket::decode, PhysGrabberPackets.GrabPacket::handle);
        CHANNEL.registerMessage(id++, PhysGrabberPackets.ReleasePacket.class, PhysGrabberPackets.ReleasePacket::encode, PhysGrabberPackets.ReleasePacket::decode, PhysGrabberPackets.ReleasePacket::handle);
        CHANNEL.registerMessage(id++, PhysGrabberPackets.UpdatePacket.class, PhysGrabberPackets.UpdatePacket::encode, PhysGrabberPackets.UpdatePacket::decode, PhysGrabberPackets.UpdatePacket::handle);
    }

    public static void sendGrab(long shipId, Vec3 target, boolean creative) {
        CHANNEL.sendToServer((Object)new PhysGrabberPackets.GrabPacket(shipId, target.f_82479_, target.f_82480_, target.f_82481_, creative));
    }

    public static void sendRelease(long shipId) {
        CHANNEL.sendToServer((Object)new PhysGrabberPackets.ReleasePacket(shipId));
    }

    public static void sendUpdate(long shipId, Vec3 target, boolean creative) {
        CHANNEL.sendToServer((Object)new PhysGrabberPackets.UpdatePacket(shipId, target.f_82479_, target.f_82480_, target.f_82481_, creative));
    }

    public static void handleGrabRequest(ServerPlayer player, long shipId, Vec3 target, boolean creative) {
        double maxMass;
        LoadedServerShip ship = VSGameUtilsKt.getAllShips((Level)player.m_9236_()).stream().filter(s -> s.getId() == shipId).filter(s -> s instanceof LoadedServerShip).map(s -> (LoadedServerShip)s).findFirst().orElse(null);
        if (ship == null) {
            return;
        }
        double mass = ship.getInertiaData().getMass();
        if (mass > (maxMass = 20000.0) && !creative) {
            PhysGrabberNetwork.sendTooHeavyMessage(player);
            return;
        }
        PhysGrabberServerAttachment grabber = PhysGrabberServerAttachment.getOrCreate(ship);
        grabber.setTarget(new Vector3d(target.f_82479_, target.f_82480_, target.f_82481_));
        grabber.setCreative(creative);
    }

    public static void sendTooHeavyMessage(ServerPlayer player) {
        player.m_5661_((Component)Component.m_237113_((String)"\u00a7cShip is too heavy to lift!"), true);
    }
}

