/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.content.physgrabber.PhysGrabberServerAttachment;

public class PhysGrabberPackets {
    public static void handleGrabOnServer(ServerLevel level, long shipId, Vector3d initialTarget) {
        LoadedServerShip ship = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(shipId);
        if (ship == null) {
            return;
        }
        PhysGrabberServerAttachment grabber = PhysGrabberServerAttachment.getOrCreate(ship);
        grabber.setTarget(initialTarget);
    }

    public static void handleReleaseOnServer(ServerLevel level, long shipId) {
        LoadedServerShip ship = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(shipId);
        if (ship == null) {
            return;
        }
        PhysGrabberServerAttachment grabber = PhysGrabberServerAttachment.getOrCreate(ship);
        grabber.release();
    }

    public static void handleUpdateOnServer(ServerLevel level, long shipId, Vector3d target) {
        LoadedServerShip ship = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(shipId);
        if (ship == null) {
            return;
        }
        PhysGrabberServerAttachment grabber = PhysGrabberServerAttachment.getOrCreate(ship);
        grabber.setTarget(target);
    }

    public static class UpdatePacket {
        private final long shipId;
        private final double x;
        private final double y;
        private final double z;
        private final boolean creative;

        public UpdatePacket(long shipId, double x, double y, double z, boolean creative) {
            this.shipId = shipId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.creative = creative;
        }

        public static void encode(UpdatePacket msg, FriendlyByteBuf buf) {
            buf.writeLong(msg.shipId);
            buf.writeDouble(msg.x);
            buf.writeDouble(msg.y);
            buf.writeDouble(msg.z);
            buf.writeBoolean(msg.creative);
        }

        public static UpdatePacket decode(FriendlyByteBuf buf) {
            return new UpdatePacket(buf.readLong(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readBoolean());
        }

        public static void handle(UpdatePacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                double maxMass;
                ServerPlayer sender = ctx.getSender();
                if (sender == null) {
                    return;
                }
                ServerLevel level = sender.m_284548_();
                LoadedServerShip ship = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(msg.shipId);
                if (ship == null) {
                    return;
                }
                double mass = ship.getInertiaData().getMass();
                if (mass > (maxMass = 20000.0) && !msg.creative) {
                    sender.m_240418_((Component)Component.m_237113_((String)"\u00a7cShip is too heavy to lift!"), true);
                    return;
                }
                PhysGrabberServerAttachment grabber = PhysGrabberServerAttachment.getOrCreate(ship);
                grabber.setTarget(new Vector3d(msg.x, msg.y, msg.z));
                grabber.setCreative(msg.creative);
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class ReleasePacket {
        private final long shipId;

        public ReleasePacket(long shipId) {
            this.shipId = shipId;
        }

        public static void encode(ReleasePacket msg, FriendlyByteBuf buf) {
            buf.writeLong(msg.shipId);
        }

        public static ReleasePacket decode(FriendlyByteBuf buf) {
            return new ReleasePacket(buf.readLong());
        }

        public static void handle(ReleasePacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                ServerPlayer sender = ctx.getSender();
                if (sender == null) {
                    return;
                }
                ServerLevel level = sender.m_284548_();
                PhysGrabberPackets.handleReleaseOnServer(level, msg.shipId);
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class GrabPacket {
        private final long shipId;
        private final double x;
        private final double y;
        private final double z;
        private final boolean creative;

        public GrabPacket(long shipId, double x, double y, double z, boolean creative) {
            this.shipId = shipId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.creative = creative;
        }

        public static void encode(GrabPacket msg, FriendlyByteBuf buf) {
            buf.writeLong(msg.shipId);
            buf.writeDouble(msg.x);
            buf.writeDouble(msg.y);
            buf.writeDouble(msg.z);
            buf.writeBoolean(msg.creative);
        }

        public static GrabPacket decode(FriendlyByteBuf buf) {
            return new GrabPacket(buf.readLong(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readBoolean());
        }

        public static void handle(GrabPacket msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                ServerPlayer sender = ctx.getSender();
                if (sender == null) {
                    return;
                }
                ServerLevel level = sender.m_284548_();
                LoadedServerShip ship = (LoadedServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getLoadedShips().getById(msg.shipId);
                if (ship != null) {
                    PhysGrabberServerAttachment grabber = PhysGrabberServerAttachment.getOrCreate(ship);
                    grabber.setTarget(new Vector3d(msg.x, msg.y, msg.z));
                    grabber.setCreative(msg.creative);
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

