/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff;

import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import yay.evy.everest.vstuff.index.VStuffItems;

@Mod.EventBusSubscriber(modid="vstuff", value={Dist.CLIENT})
public class TooltipHandler {
    private static final HashMap<Item, Function<SummaryPayload, String>> tooltipModifications = new HashMap();

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (tooltipModifications.isEmpty()) {
            TooltipHandler.populateModifiables();
        }
        List tooltip = event.getToolTip();
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        if (tooltipModifications.containsKey(item)) {
            TooltipHandler.handleItemTooltip(tooltipList, item);
        }
        tooltip.addAll(1, tooltipList);
    }

    private static void handleItemTooltip(List<Component> tooltipList, Item item) {
        TooltipHandler.wrapShiftHoldText(tooltipList, "vstuff.tooltip.hold_for_details", () -> {
            Function<SummaryPayload, String> modifier = tooltipModifications.get(item);
            if (modifier != null) {
                String summary = modifier.apply(new SummaryPayload(item));
                tooltipList.addAll(TooltipHelper.cutStringTextComponent((String)summary, (TooltipHelper.Palette)TooltipHelper.Palette.STANDARD_CREATE));
            }
        });
    }

    private static void wrapShiftHoldText(List<Component> tooltipList, String langKey, Runnable addDetailedContent) {
        boolean isShiftDown = Screen.m_96638_();
        MutableComponent keyComponent = Component.m_237115_((String)"create.tooltip.keyShift").m_130940_(isShiftDown ? ChatFormatting.WHITE : ChatFormatting.GRAY);
        tooltipList.add((Component)Component.m_237110_((String)langKey, (Object[])new Object[]{keyComponent}).m_130940_(ChatFormatting.DARK_GRAY));
        if (isShiftDown) {
            tooltipList.add((Component)Component.m_237119_());
            addDetailedContent.run();
        }
    }

    private static void populateModifiables() {
        tooltipModifications.put((Item)VStuffItems.LEAD_CONSTRAINT_ITEM.get(), payload -> Component.m_237115_((String)(payload.path + ".tooltip.summary")).getString());
        tooltipModifications.put((Item)VStuffItems.LEAD_BREAK_ITEM.get(), payload -> Component.m_237115_((String)(payload.path + ".tooltip.summary")).getString());
    }

    private static class SummaryPayload {
        public final Item item;
        public final String path;

        public SummaryPayload(Item item) {
            this.item = item;
            this.path = "vstuff." + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        }
    }
}

