/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.client.NetworkHandler;
import yay.evy.everest.vstuff.index.VStuffBlockEntities;
import yay.evy.everest.vstuff.index.VStuffBlocks;
import yay.evy.everest.vstuff.index.VStuffCreativeModeTabs;
import yay.evy.everest.vstuff.index.VStuffItems;
import yay.evy.everest.vstuff.index.VStuffPonders;
import yay.evy.everest.vstuff.index.VStuffRopeStyles;
import yay.evy.everest.vstuff.index.VStuffSounds;
import yay.evy.everest.vstuff.particles.ParticleTypes;

@Mod(value="vstuff")
public class VStuff {
    public static final String MOD_ID = "vstuff";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String NAME = "VStuff";
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"vstuff");

    public VStuff() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        VStuffCreativeModeTabs.register(modEventBus);
        VStuffRopeStyles.register();
        VStuffBlocks.register();
        VStuffBlockEntities.register();
        VStuffItems.register();
        VStuffPonders.register();
        VStuffSounds.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)VstuffConfig.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)VstuffConfig.CLIENT_CONFIG);
        ParticleTypes.register(modEventBus);
        REGISTRATE.registerEventListeners(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkHandler.registerPackets();
        LOGGER.info("VStuff mod initialized");
    }

    public static CreateRegistrate registrate() {
        return REGISTRATE;
    }

    public static ResourceLocation getRopeStyle(String style) {
        return new ResourceLocation(MOD_ID, "textures/entity/rope/rope_" + style + ".png");
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            NetworkHandler.sendClearAllConstraintsToPlayer(player2);
        }
    }
}

