/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.constraint;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.VStuff;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.client.NetworkHandler;
import yay.evy.everest.vstuff.content.constraint.ConstraintPersistence;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;
import yay.evy.everest.vstuff.index.VStuffItems;
import yay.evy.everest.vstuff.util.RopeStyles;

public class LeadBreakItem
extends Item {
    public LeadBreakItem(Item.Properties pProperties) {
        super(new Item.Properties().m_41487_(1).m_41503_(64));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ServerLevel serverLevel;
        Integer targetConstraintId;
        ItemStack itemStack = player.m_21120_(hand);
        if (level instanceof ServerLevel && (targetConstraintId = this.findTargetedLead(serverLevel = (ServerLevel)level, player)) != null) {
            try {
                VStuff.LOGGER.info("Attempting to remove constraint: {}", (Object)targetConstraintId);
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).removeConstraint(targetConstraintId.intValue());
                ConstraintTracker.RopeConstraintData data = ConstraintTracker.getActiveConstraints().get(targetConstraintId);
                ConstraintTracker.removeConstraintWithPersistence(serverLevel, targetConstraintId);
                NetworkHandler.sendConstraintRemove(targetConstraintId);
                this.forceRemoveConstraint(serverLevel, targetConstraintId);
                RopeStyles.PrimitiveRopeStyle style = data != null ? data.style.getBasicStyle() : RopeStyles.PrimitiveRopeStyle.NORMAL;
                MutableComponent notif = style == RopeStyles.PrimitiveRopeStyle.CHAIN ? Component.m_237115_((String)"vstuff.message.chain_break") : Component.m_237115_((String)"vstuff.message.rope_break");
                player.m_5661_((Component)notif, true);
                if (((Boolean)VstuffConfig.ROPE_SOUNDS.get()).booleanValue()) {
                    SoundEvent sound = style == RopeStyles.PrimitiveRopeStyle.CHAIN ? SoundEvents.f_11794_ : SoundEvents.f_12033_;
                    serverLevel.m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (data != null && data.sourceBlockPos != null) {
                    ConstraintTracker.cleanupOrphanedConstraints(serverLevel, data.sourceBlockPos);
                }
                VStuff.LOGGER.info("Removed constraint (1st attempt): {}", (Object)targetConstraintId);
                if (ConstraintTracker.getActiveConstraints().containsKey(targetConstraintId)) {
                    VStuff.LOGGER.warn("Constraint {} still present, retrying...", (Object)targetConstraintId);
                    VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).removeConstraint(targetConstraintId.intValue());
                    ConstraintTracker.removeConstraintWithPersistence(serverLevel, targetConstraintId);
                    NetworkHandler.sendConstraintRemove(targetConstraintId);
                    this.forceRemoveConstraint(serverLevel, targetConstraintId);
                    ConstraintPersistence persistence = ConstraintPersistence.get(serverLevel);
                    persistence.saveNow(serverLevel);
                    VStuff.LOGGER.info("Removed constraint (2nd attempt): {}", (Object)targetConstraintId);
                }
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    player.m_36176_(new ItemStack((ItemLike)VStuffItems.LEAD_CONSTRAINT_ITEM.get()), false);
                }
                return InteractionResultHolder.m_19090_((Object)itemStack);
            }
            catch (Exception e) {
                VStuff.LOGGER.error("Error removing constraint: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    private void forceRemoveConstraint(ServerLevel level, int id) {
        ConstraintTracker.RopeConstraintData data = ConstraintTracker.getActiveConstraints().get(id);
        try {
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).removeConstraint(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConstraintPersistence persistence = ConstraintPersistence.get(level);
        persistence.saveNow(level);
        ConstraintTracker.removeConstraintWithPersistence(level, id);
        ConstraintTracker.getActiveConstraints().remove(id);
        NetworkHandler.sendConstraintRemove(id);
        if (data != null) {
            if (data.anchorBlockPosA != null) {
                ConstraintTracker.cleanupOrphanedConstraints(level, data.anchorBlockPosA);
            }
            if (data.anchorBlockPosB != null) {
                ConstraintTracker.cleanupOrphanedConstraints(level, data.anchorBlockPosB);
            }
        }
    }

    private Integer findTargetedLead(ServerLevel level, Player player) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        double maxDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        Integer closestConstraintId = null;
        for (Map.Entry<Integer, ConstraintTracker.RopeConstraintData> entry : ConstraintTracker.getActiveConstraints().entrySet()) {
            Vector3d worldPosB;
            Integer constraintId = entry.getKey();
            ConstraintTracker.RopeConstraintData constraint = entry.getValue();
            Vector3d worldPosA = constraint.getWorldPosA(level, 1.0f);
            double distance = this.getDistanceToRope(eyePos, lookVec, worldPosA, worldPosB = constraint.getWorldPosB(level, 1.0f), maxDistance);
            if (!(distance < minDistance) || !(distance <= 1.0)) continue;
            minDistance = distance;
            closestConstraintId = constraintId;
        }
        return closestConstraintId;
    }

    private double getDistanceToRope(Vec3 eyePos, Vec3 lookVec, Vector3d ropeStart, Vector3d ropeEnd, double maxDistance) {
        Vec3 start = new Vec3(ropeStart.x, ropeStart.y, ropeStart.z);
        Vec3 end = new Vec3(ropeEnd.x, ropeEnd.y, ropeEnd.z);
        double minDistanceToRope = Double.MAX_VALUE;
        for (double t = 0.0; t <= maxDistance; t += 0.5) {
            Vec3 rayPoint = eyePos.m_82549_(lookVec.m_82490_(t));
            Vec3 ropeVec = end.m_82546_(start);
            Vec3 startToRay = rayPoint.m_82546_(start);
            double ropeLength = ropeVec.m_82553_();
            if (ropeLength < 0.01) continue;
            double projection = startToRay.m_82526_(ropeVec) / (ropeLength * ropeLength);
            projection = Math.max(0.0, Math.min(1.0, projection));
            Vec3 closestPointOnRope = start.m_82549_(ropeVec.m_82490_(projection));
            double distanceToRope = rayPoint.m_82554_(closestPointOnRope);
            minDistanceToRope = Math.min(minDistanceToRope, distanceToRope);
        }
        return minDistanceToRope;
    }
}

