/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.constraint;

import com.simibubi.create.CreateClient;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSRopeConstraint;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import yay.evy.everest.vstuff.VStuff;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.client.NetworkHandler;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;
import yay.evy.everest.vstuff.content.pulley.PhysPulleyBlockEntity;
import yay.evy.everest.vstuff.content.pulley.PhysPulleyItem;
import yay.evy.everest.vstuff.content.ropestyler.handler.RopeStyleHandlerServer;
import yay.evy.everest.vstuff.util.RopeStyles;
import yay.evy.everest.vstuff.util.packet.RopeSoundPacket;

public class LeadConstraintItem
extends Item {
    private BlockPos firstClickedPos;
    private Long firstShipId;
    private Entity firstEntity;
    private Integer activeConstraintId;
    private ResourceKey<Level> firstClickDimension;

    public LeadConstraintItem(Item.Properties pProperties) {
        super(new Item.Properties().m_41487_(64));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ServerLevel serverLevel;
        Player player;
        BlockPos clickedPos;
        Level level;
        block11: {
            block10: {
                level = context.m_43725_();
                clickedPos = context.m_8083_().m_7949_();
                player = context.m_43723_();
                if (!this.canConnectRope(level, clickedPos)) {
                    player.m_5661_((Component)Component.m_237115_((String)"vstuff.message.nonfullblock_fail"), true);
                    return InteractionResult.FAIL;
                }
                if (!(level instanceof ServerLevel)) break block10;
                serverLevel = (ServerLevel)level;
                if (player != null) break block11;
            }
            return InteractionResult.PASS;
        }
        PhysPulleyBlockEntity pulley = PhysPulleyItem.getWaitingPulley(player);
        if (pulley != null) {
            pulley.targetPos = clickedPos;
            pulley.hasTarget = true;
            pulley.waitingForTarget = false;
            pulley.m_6596_();
            pulley.sendData();
            pulley.createManualConstraint();
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7aPulley target set and constraint created!"));
            PhysPulleyItem.clearWaitingPulley(player);
            return InteractionResult.SUCCESS;
        }
        if (this.firstClickedPos == null && this.firstEntity == null) {
            this.firstClickedPos = clickedPos;
            this.firstShipId = this.getShipIdAtPos(serverLevel, clickedPos);
            this.firstClickDimension = serverLevel.m_46472_();
            player.m_5661_((Component)Component.m_237115_((String)"vstuff.message.rope_first"), true);
            LeadConstraintItem.drawOutline(level, clickedPos);
            return InteractionResult.SUCCESS;
        }
        if (this.firstClickedPos != null && (player.m_6144_() || this.firstClickedPos.equals((Object)clickedPos))) {
            this.resetState();
            player.m_5661_((Component)Component.m_237115_((String)"vstuff.message.rope_reset"), true);
            return InteractionResult.SUCCESS;
        }
        if (!serverLevel.m_46472_().equals(this.firstClickDimension)) {
            player.m_5661_((Component)Component.m_237115_((String)"vstuff.message.interdimensional_fail"), true);
            this.resetState();
            return InteractionResult.FAIL;
        }
        Long secondShipId = this.getShipIdAtPos(serverLevel, clickedPos);
        boolean created = this.createLeadConstraint(serverLevel, clickedPos, secondShipId, player);
        if (created && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ConstraintTracker.syncAllConstraintsToPlayer(serverPlayer);
            MutableComponent notif = Component.m_237115_((String)"vstuff.message.rope_created");
            if (RopeStyleHandlerServer.getStyle(player.m_20148_()) != null && RopeStyleHandlerServer.getStyle(player.m_20148_()).getBasicStyle() == RopeStyles.PrimitiveRopeStyle.CHAIN) {
                notif = Component.m_237115_((String)"vstuff.message.chain_created");
            }
            player.m_5661_((Component)notif, true);
            LeadConstraintItem.drawOutline(level, clickedPos);
        }
        this.resetState();
        return created ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private boolean createLeadConstraint(ServerLevel level, BlockPos secondPos, Long secondShipId, Player player) {
        Vector3d firstLocalPos;
        Long shipA;
        Vector3d firstWorldPos;
        if (this.firstClickedPos == null && this.firstEntity == null) {
            return false;
        }
        if (this.firstEntity != null) {
            firstWorldPos = new Vector3d(this.firstEntity.m_20185_(), this.firstEntity.m_20186_() + (double)(this.firstEntity.m_20206_() / 2.0f), this.firstEntity.m_20189_());
            shipA = this.firstShipId != null ? this.firstShipId : this.getGroundBodyId(level);
            firstLocalPos = this.convertWorldToLocal(level, firstWorldPos, shipA);
        } else {
            firstWorldPos = this.getWorldPosition(level, this.firstClickedPos, this.firstShipId);
            shipA = this.firstShipId != null ? this.firstShipId : this.getGroundBodyId(level);
            firstLocalPos = this.getLocalPositionFixed(level, this.firstClickedPos, this.firstShipId, shipA);
        }
        Vector3d secondWorldPos = this.getWorldPosition(level, secondPos, secondShipId);
        Long shipB = secondShipId != null ? secondShipId : this.getGroundBodyId(level);
        Vector3d secondLocalPos = this.getLocalPositionFixed(level, secondPos, secondShipId, shipB);
        return this.createConstraintConsistent(level, shipA, shipB, firstLocalPos, secondLocalPos, firstWorldPos, secondWorldPos, player);
    }

    private boolean createConstraintConsistent(ServerLevel level, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, Vector3d worldPosA, Vector3d worldPosB, Player player) {
        double massB;
        Vector3d finalWorldPosB;
        Vector3d finalWorldPosA;
        Vector3d finalLocalPosB;
        Vector3d finalLocalPosA;
        Long finalShipB;
        Long finalShipA;
        Long groundBodyId = this.getGroundBodyId(level);
        boolean shipAIsWorld = shipA.equals(groundBodyId);
        boolean shipBIsWorld = shipB.equals(groundBodyId);
        if (shipAIsWorld && !shipBIsWorld) {
            finalShipA = shipB;
            finalShipB = shipA;
            finalLocalPosA = localPosB;
            finalLocalPosB = localPosA;
            finalWorldPosA = worldPosB;
            finalWorldPosB = worldPosA;
        } else {
            finalShipA = shipA;
            finalShipB = shipB;
            finalLocalPosA = localPosA;
            finalLocalPosB = localPosB;
            finalWorldPosA = worldPosA;
            finalWorldPosB = worldPosB;
        }
        double distance = finalWorldPosA.distance((Vector3dc)finalWorldPosB);
        double maxAllowedLength = (Double)VstuffConfig.MAX_ROPE_LENGTH.get();
        if (distance > maxAllowedLength) {
            if (player != null) {
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7cRope too long! Max length is " + maxAllowedLength + " blocks.")), true);
            }
            this.resetState();
            return false;
        }
        double maxLength = distance + 0.5;
        double massA = this.getMassForShip(level, finalShipA);
        double effectiveMass = Math.min(massA, massB = this.getMassForShip(level, finalShipB));
        if (effectiveMass < 100.0) {
            effectiveMass = 100.0;
        }
        double compliance = 1.0E-12 / effectiveMass;
        double massRatio = Math.max(massA, massB) / Math.min(massA, massB);
        double baseMaxForce = 5.0E13;
        double maxForce = baseMaxForce * Math.min(massRatio, 20.0);
        if (shipAIsWorld || shipBIsWorld) {
            maxForce *= 10.0;
            compliance *= 0.05;
        }
        VSRopeConstraint ropeConstraint = new VSRopeConstraint(finalShipA.longValue(), finalShipB.longValue(), compliance, (Vector3dc)finalLocalPosA, (Vector3dc)finalLocalPosB, maxForce, maxLength);
        try {
            Integer constraintId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createNewConstraint((VSConstraint)ropeConstraint);
            if (constraintId != null) {
                this.activeConstraintId = constraintId;
                ConstraintTracker.addConstraintWithPersistence(level, constraintId, finalShipA, finalShipB, finalLocalPosA, finalLocalPosB, maxLength, compliance, maxForce, RopeStyleHandlerServer.getStyle(player.m_20148_()));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    RopeStyles.RopeStyle ropeStyle = RopeStyleHandlerServer.getStyle(player.m_20148_());
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new RopeSoundPacket(false, ropeStyle.getBasicStyle()));
                    ConstraintTracker.syncAllConstraintsToPlayer(serverPlayer);
                }
                if (player != null && !player.m_150110_().f_35937_) {
                    for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                        ItemStack stack = player.m_150109_().m_8020_(i);
                        if (!(stack.m_41720_() instanceof LeadConstraintItem)) continue;
                        stack.m_41774_(1);
                        break;
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            VStuff.LOGGER.error("Error creating rope constraint: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    private double getMassForShip(ServerLevel level, Long shipId) {
        Long groundBodyId = this.getGroundBodyId(level);
        if (shipId.equals(groundBodyId)) {
            return 1.0E12;
        }
        Ship shipObject = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue());
        if (shipObject != null) {
            try {
                double mass = 1000.0;
                AABBic bounds = shipObject.getShipAABB();
                if (bounds != null) {
                    double volume = (bounds.maxX() - bounds.minX()) * (bounds.maxY() - bounds.minY()) * (bounds.maxZ() - bounds.minZ());
                    mass = Math.max(volume * 10.0, 1000.0);
                }
                return Math.min(mass, 1.0E9);
            }
            catch (Exception e) {
                return 1000.0;
            }
        }
        return 1000.0;
    }

    private Long getShipIdAtPos(ServerLevel level, BlockPos pos) {
        LoadedServerShip shipObject = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)level, (Vec3i)pos);
        return shipObject != null ? Long.valueOf(shipObject.getId()) : null;
    }

    private Long getGroundBodyId(ServerLevel level) {
        return (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
    }

    private Vector3d getWorldPosition(ServerLevel level, BlockPos pos, Long shipId) {
        Ship shipObject;
        Vector3d localPos = new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (shipId != null && (shipObject = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue())) != null) {
            Vector3d worldPos = new Vector3d();
            shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)localPos, worldPos);
            return worldPos;
        }
        return localPos;
    }

    private Vector3d getLocalPositionFixed(ServerLevel level, BlockPos pos, Long clickedShipId, Long targetShipId) {
        Vector3d blockPos = new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (clickedShipId != null && clickedShipId.equals(targetShipId)) {
            return blockPos;
        }
        if (targetShipId.equals(this.getGroundBodyId(level))) {
            Ship clickedShip;
            if (clickedShipId != null && (clickedShip = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(clickedShipId.longValue())) != null) {
                Vector3d worldPos = new Vector3d();
                clickedShip.getTransform().getShipToWorld().transformPosition((Vector3dc)blockPos, worldPos);
                return worldPos;
            }
            return blockPos;
        }
        Ship targetShip = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(targetShipId.longValue());
        if (targetShip != null) {
            Ship clickedShip;
            Vector3d worldPos = blockPos;
            if (clickedShipId != null && !clickedShipId.equals(targetShipId) && (clickedShip = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(clickedShipId.longValue())) != null) {
                worldPos = new Vector3d();
                clickedShip.getTransform().getShipToWorld().transformPosition((Vector3dc)blockPos, worldPos);
            }
            Vector3d localPos = new Vector3d();
            targetShip.getTransform().getWorldToShip().transformPosition((Vector3dc)worldPos, localPos);
            return localPos;
        }
        return blockPos;
    }

    private Vector3d convertWorldToLocal(ServerLevel level, Vector3d worldPos, Long shipId) {
        Ship shipObject;
        if (shipId != null && !shipId.equals(this.getGroundBodyId(level)) && (shipObject = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(shipId.longValue())) != null) {
            Vector3d localPos = new Vector3d();
            shipObject.getTransform().getWorldToShip().transformPosition((Vector3dc)worldPos, localPos);
            return localPos;
        }
        return new Vector3d((Vector3dc)worldPos);
    }

    private boolean canConnectRope(Level level, BlockPos clickedPos) {
        return level.m_8055_(clickedPos).m_60838_((BlockGetter)level, clickedPos);
    }

    private static void drawOutline(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)level, pos);
        if (shape.m_83281_()) {
            return;
        }
        CreateClient.OUTLINER.showAABB((Object)pos, shape.m_83215_().m_82338_(pos)).colored(0xFFFFFF).lineWidth(0.0625f);
    }

    private void resetState() {
        this.firstClickedPos = null;
        this.firstShipId = null;
        this.firstEntity = null;
        this.firstClickDimension = null;
        VStuff.LOGGER.info("Reset LeadContraintItem state");
    }
}

