/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.pulley;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import yay.evy.everest.vstuff.content.pulley.PhysPulleyBlockEntity;
import yay.evy.everest.vstuff.index.VStuffBlockEntities;
import yay.evy.everest.vstuff.index.VStuffShapes;

public class PhysPulleyBlock
extends HorizontalKineticBlock
implements IBE<PhysPulleyBlockEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public PhysPulleyBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(3.0f).m_60999_());
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        TieredItem tieredItem;
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        return item instanceof TieredItem && (tieredItem = (TieredItem)item).m_43314_().m_6604_() >= 1;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        PhysPulleyBlockEntity pulley;
        CompoundTag tag;
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = (BlockEntity)params.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof PhysPulleyBlockEntity && !(tag = (pulley = (PhysPulleyBlockEntity)blockEntity).m_187482_()).m_128456_()) {
            stack.m_41784_().m_128391_(tag);
        }
        return Collections.singletonList(stack);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof PhysPulleyBlockEntity) {
            PhysPulleyBlockEntity pulleyEntity = (PhysPulleyBlockEntity)blockEntity;
            pulleyEntity.removeExistingConstraint();
            pulleyEntity.onBlockRemoved();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED});
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PhysPulleyBlockEntity) {
            PhysPulleyBlockEntity physPulleyBlockEntity = (PhysPulleyBlockEntity)blockEntity;
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        boolean powered = context.m_43725_().m_276867_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)facing)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        return face == facing.m_122427_() || face == facing.m_122428_();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        return facing.m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.SLOW;
    }

    public boolean hideStressImpact() {
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        UseOnContext context;
        InteractionResult result;
        ItemStack heldItem = player.m_21120_(hand);
        if (AllItems.WRENCH.isIn(heldItem) && (result = this.onWrenched(state, context = new UseOnContext(player, hand, hit))).m_19077_()) {
            return result;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PhysPulleyBlockEntity) {
            PhysPulleyBlockEntity pulley = (PhysPulleyBlockEntity)blockEntity;
            return pulley.use(state, level, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof PhysPulleyBlockEntity) {
            PhysPulleyBlockEntity pulley = (PhysPulleyBlockEntity)be;
            ItemStack stack = new ItemStack((ItemLike)this);
            CompoundTag tag = pulley.m_187482_();
            if (!tag.m_128456_()) {
                stack.m_41784_().m_128391_(tag);
            }
            return stack;
        }
        return new ItemStack((ItemLike)this);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean previouslyPowered;
        if (level.f_46443_) {
            return;
        }
        boolean currentlyPowered = level.m_276867_(pos);
        if (currentlyPowered != (previouslyPowered = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue())) {
            BlockEntity be;
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(currentlyPowered)), 3);
            if (currentlyPowered && (be = level.m_7702_(pos)) instanceof PhysPulleyBlockEntity) {
                PhysPulleyBlockEntity pulley = (PhysPulleyBlockEntity)be;
                pulley.removeExistingConstraint(true);
                pulley.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return VStuffShapes.PHYS_PULLEY.get((Direction)state.m_61143_(HORIZONTAL_FACING));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return this.m_5940_(state, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public Class<PhysPulleyBlockEntity> getBlockEntityClass() {
        return PhysPulleyBlockEntity.class;
    }

    public BlockEntityType<? extends PhysPulleyBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VStuffBlockEntities.PHYS_PULLEY_BE.get();
    }
}

