/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.pulley;

import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSRopeConstraint;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;
import yay.evy.everest.vstuff.content.pulley.PhysPulleyItem;
import yay.evy.everest.vstuff.index.VStuffBlockEntities;
import yay.evy.everest.vstuff.index.VStuffBlocks;
import yay.evy.everest.vstuff.index.VStuffItems;
import yay.evy.everest.vstuff.util.RopeStyles;

public class PhysPulleyBlockEntity
extends KineticBlockEntity {
    private ItemStackHandler ropeInventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            PhysPulleyBlockEntity.this.m_6596_();
            PhysPulleyBlockEntity.this.sendData();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() == Items.f_42401_ || stack.m_41720_() == Items.f_42655_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private LazyOptional<IItemHandler> ropeInventoryOptional = LazyOptional.of(() -> this.ropeInventory);
    public BlockPos targetPos = null;
    public boolean hasTarget = false;
    private Integer constraintId = null;
    private double currentRopeLength = 5.0;
    private double minRopeLength = 0.1;
    private Long shipA = null;
    private Long shipB = null;
    private Vector3d localPosA = null;
    private Vector3d localPosB = null;
    private int tickCounter = 0;
    private static final double MIN_SPEED_THRESHOLD = 1.0;
    private double consumedRopeLength = 0.0;
    private double baseRopeLength = 1.0;
    private boolean ropeStateInitialized = false;
    boolean isRopeRendering = false;
    private BlockPos previewTargetPos = null;
    public static boolean MANUAL = true;
    public ScrollValueBehaviour MODE;
    public static final String PULLEY_MODE = "MANUAL";
    private static final PulleyMode[] MODES = PulleyMode.values();
    private PulleyMode lastMode = PulleyMode.MANUAL;
    private double targetRopeLength;
    private boolean isExtending = false;
    private long extensionStartTime;
    private static final double EXTENSION_SPEED = 1.5;
    private boolean isPlayerRetracting = false;
    private boolean isPlayerExtending = false;
    private static final double MANUAL_SPEED = 1.0;
    private boolean hasCustomModeLoaded = false;
    private Integer loadedPulleyMode = null;
    private boolean constraintRestored = false;
    private boolean restoring = false;
    boolean isLowering = false;
    private BlockPos pendingTargetPos = null;
    private double pendingTargetDistance = 0.0;
    private Vector3d pulleyWorldPos;
    private Vector3d targetWorldPos;
    private Vector3d previewAttachVec = null;
    private boolean wasCut = false;
    private boolean manualMode = false;
    private Vector3d ropeEndPos = null;
    public boolean waitingForTarget = false;

    private double getLengthChangeRate() {
        return (Double)VstuffConfig.PULLEY_SPEED.get();
    }

    public PhysPulleyBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public Vector3d getRopeEndPos() {
        return this.ropeEndPos;
    }

    public Vector3d getPulleyWorldPos() {
        return this.pulleyWorldPos;
    }

    public Vector3d getTargetWorldPos() {
        return this.targetWorldPos;
    }

    public static PhysPulleyBlockEntity create(BlockPos pos, BlockState state) {
        return new PhysPulleyBlockEntity((BlockEntityType)VStuffBlockEntities.PHYS_PULLEY_BE.get(), pos, state);
    }

    public void setManualMode(boolean manualMode) {
        this.manualMode = manualMode;
    }

    public boolean isManualMode() {
        return this.manualMode;
    }

    public void setConstraintId(Integer constraintId) {
        this.constraintId = constraintId;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
    }

    public PulleyMode getPulleyMode() {
        if (MODES.length > 0) {
            return MODES[0];
        }
        return PulleyMode.MANUAL;
    }

    private void onModeChanged(PulleyMode oldMode, PulleyMode newMode) {
        System.out.println("Pulley mode changed from " + String.valueOf((Object)oldMode) + " to " + String.valueOf((Object)newMode));
        if (oldMode == PulleyMode.MANUAL && newMode == PulleyMode.AUTO) {
            if (this.waitingForTarget) {
                this.waitingForTarget = false;
            }
            if (this.constraintId == null) {
                this.hasTarget = false;
                this.targetPos = null;
            }
        } else if (oldMode != PulleyMode.AUTO || newMode == PulleyMode.MANUAL) {
            // empty if block
        }
        this.m_6596_();
        this.sendData();
    }

    private void updatePulleyMode() {
        PulleyMode currentMode = this.getPulleyMode();
        if (currentMode == PulleyMode.MANUAL) {
            System.out.println("MANUAL MODE: Player controls rope extension/retraction and target selection");
        } else if (currentMode == PulleyMode.AUTO) {
            System.out.println("AUTO MODE: Automatic rope management and target detection");
            if (this.waitingForTarget) {
                this.waitingForTarget = false;
            }
        }
        this.m_6596_();
        this.sendData();
    }

    private boolean createAutoConstraint() {
        if (this.f_58857_.f_46443_) {
            return false;
        }
        if (!this.hasTarget || !this.hasRope() || this.constraintId != null) {
            return false;
        }
        this.setManualMode(false);
        try {
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.m_58899_());
            LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.targetPos);
            this.shipA = pulleyShip != null ? pulleyShip.getId() : this.getGroundBodyId(serverLevel).longValue();
            this.shipB = targetShip != null ? targetShip.getId() : this.getGroundBodyId(serverLevel).longValue();
            this.localPosA = this.getLocalPosition(serverLevel, this.m_58899_(), (Ship)pulleyShip, this.shipA);
            this.pulleyWorldPos = this.getWorldPosition(serverLevel, this.m_58899_(), (Ship)pulleyShip);
            if (this.previewAttachVec != null) {
                this.targetWorldPos = this.previewAttachVec;
                if (targetShip != null) {
                    Vector3d local = new Vector3d();
                    targetShip.getTransform().getWorldToShip().transformPosition((Vector3dc)this.previewAttachVec, local);
                    this.localPosB = local;
                } else {
                    this.localPosB = this.previewAttachVec;
                }
            } else if (this.targetPos != null) {
                this.targetWorldPos = this.getWorldPosition(serverLevel, this.targetPos, (Ship)targetShip);
                this.localPosB = this.getLocalPosition(serverLevel, this.targetPos, (Ship)targetShip, this.shipB);
            } else {
                System.err.println("Pulley: No valid target for constraint creation");
                return false;
            }
            if (this.targetWorldPos == null || this.pulleyWorldPos == null) {
                System.err.println("Pulley: Cannot create constraint, world positions invalid");
                return false;
            }
            double distance = this.pulleyWorldPos.distance((Vector3dc)this.targetWorldPos);
            if (distance < 0.01) {
                System.err.println("Pulley: Target too close to pulley, skipping constraint creation");
                return false;
            }
            this.targetRopeLength = Math.min(distance, this.getRawMaxRopeLength());
            this.currentRopeLength = this.targetRopeLength = Math.max(this.targetRopeLength, this.minRopeLength);
            double compliance = 5.0E-9;
            double maxForce = 2.0E7;
            VSRopeConstraint constraint = new VSRopeConstraint(this.shipA.longValue(), this.shipB.longValue(), compliance, (Vector3dc)this.localPosA, (Vector3dc)this.localPosB, maxForce, this.currentRopeLength);
            Integer newConstraintId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).createNewConstraint((VSConstraint)constraint);
            if (newConstraintId != null) {
                this.constraintId = newConstraintId;
                this.consumedRopeLength = Math.max(0.0, this.currentRopeLength - this.baseRopeLength);
                this.ropeStateInitialized = true;
                this.isRopeRendering = true;
                ConstraintTracker.addConstraintWithPersistence(serverLevel, this.constraintId, this.shipA, this.shipB, this.localPosA, this.localPosB, this.currentRopeLength, compliance, maxForce, ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY, this.m_58899_(), new RopeStyles.RopeStyle("normal", RopeStyles.PrimitiveRopeStyle.NORMAL, "vstuff.ropes.normal"));
                this.m_6596_();
                this.sendData();
                this.previewAttachVec = null;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Vec3 getRopeAttachmentPoint() {
        return Vec3.m_82539_((Vec3i)this.m_58899_());
    }

    public boolean shouldRenderRope() {
        return this.isRopeRendering || this.waitingForTarget;
    }

    private boolean canExtendRope(double newLength) {
        if (this.targetPos == null) {
            return true;
        }
        double currentDistance = this.calculateWorldDistance(this.m_58899_(), this.targetPos);
        return newLength >= currentDistance * 0.9;
    }

    private BlockPos findPulleyAnchorInShip(ServerLevel serverLevel, Ship ship) {
        AABBic shipAABB = ship.getShipAABB();
        if (shipAABB == null) {
            return null;
        }
        int minX = (int)Math.floor(shipAABB.minX());
        int maxX = (int)Math.ceil(shipAABB.maxX());
        int minY = (int)Math.floor(shipAABB.minY());
        int maxY = (int)Math.ceil(shipAABB.maxY());
        int minZ = (int)Math.floor(shipAABB.minZ());
        int maxZ = (int)Math.ceil(shipAABB.maxZ());
        BlockPos closestAnchorPos = null;
        double closestDistance = Double.MAX_VALUE;
        Vector3d shipCenter = new Vector3d((double)(shipAABB.minX() + shipAABB.maxX()) / 2.0, (double)(shipAABB.minY() + shipAABB.maxY()) / 2.0, (double)(shipAABB.minZ() + shipAABB.maxZ()) / 2.0);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    double dist;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = serverLevel.m_8055_(pos);
                    if (state.m_60734_() != VStuffBlocks.PHYS_PULLEY.get() || !((dist = shipCenter.distance((Vector3dc)new Vector3d((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))) < closestDistance)) continue;
                    closestDistance = dist;
                    closestAnchorPos = pos;
                }
            }
        }
        return closestAnchorPos;
    }

    public static Vector3d calculateGeometricCenter(Set<BlockPos> positions) {
        if (positions.isEmpty()) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        int count = positions.size();
        for (BlockPos pos : positions) {
            sumX += (double)pos.m_123341_();
            sumY += (double)pos.m_123342_();
            sumZ += (double)pos.m_123343_();
        }
        return new Vector3d(sumX / (double)count, sumY / (double)count, sumZ / (double)count);
    }

    public PhysifyResult physifyBlocksIntoShip(ServerLevel level, Set<BlockPos> blockPositions, @Nullable BlockPos pulleyAnchorWorldPos) {
        System.out.println("Physify called with " + blockPositions.size() + " blocks");
        if (blockPositions.isEmpty()) {
            return null;
        }
        Vector3d center = PhysPulleyBlockEntity.calculateGeometricCenter(blockPositions);
        BlockPos anchorPos = new BlockPos((int)Math.floor(center.x), (int)Math.floor(center.y), (int)Math.floor(center.z));
        ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level);
        ServerShip ship = shipWorld.createNewShipAtBlock((Vector3ic)VectorConversionsMCKt.toJOML((Vec3i)anchorPos), false, 1.0, VSGameUtilsKt.getDimensionId((Level)level));
        if (!(ship instanceof ServerShip)) {
            System.err.println("Created ship is not a ServerShip!");
            return null;
        }
        ServerShip serverShip = ship;
        Vector3i internalCenter = this.calculateInternalCenterPos(serverShip, level);
        BlockPos pulleyAnchorLocalPos = null;
        for (BlockPos worldPos : blockPositions) {
            BlockPos relativePos = worldPos.m_121996_((Vec3i)anchorPos);
            BlockPos shipLocalPos = new BlockPos(internalCenter.x() + relativePos.m_123341_(), internalCenter.y() + relativePos.m_123342_(), internalCenter.z() + relativePos.m_123343_());
            System.out.println("Copying block at " + String.valueOf(worldPos) + " to ship local pos " + String.valueOf(shipLocalPos));
            this.copyBlock(level, worldPos, shipLocalPos);
            this.removeBlock(level, worldPos);
            if (pulleyAnchorWorldPos == null || !worldPos.equals((Object)pulleyAnchorWorldPos)) continue;
            pulleyAnchorLocalPos = shipLocalPos;
        }
        System.out.println("Physified ship with " + blockPositions.size() + " blocks at anchor " + String.valueOf(anchorPos));
        BlockPos pulleyAnchorShipWorldPos = null;
        if (pulleyAnchorLocalPos != null) {
            Vector3d worldVec = this.getWorldPosition(level, pulleyAnchorLocalPos, (Ship)ship);
            pulleyAnchorShipWorldPos = new BlockPos((int)Math.floor(worldVec.x), (int)Math.floor(worldVec.y), (int)Math.floor(worldVec.z));
            System.out.println("Pulley anchor local pos " + String.valueOf(pulleyAnchorLocalPos) + " converted back to world pos " + String.valueOf(pulleyAnchorShipWorldPos));
        }
        return new PhysifyResult((Ship)ship, pulleyAnchorShipWorldPos);
    }

    public SelectedRegion getGeometricCenterOfBlocks(ServerLevel level, Set<BlockPos> blocks) {
        if (blocks.isEmpty()) {
            return SelectedRegion.empty();
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (BlockPos pos : blocks) {
            sumX += (double)pos.m_123341_() + 0.5;
            sumY += (double)pos.m_123342_() + 0.5;
            sumZ += (double)pos.m_123343_() + 0.5;
        }
        double count = blocks.size();
        Vector3d center = new Vector3d(sumX / count, sumY / count, sumZ / count);
        SelectedRegion region = new SelectedRegion();
        region.geometricCenter = center;
        region.blockPositions = blocks;
        region.hasBlocks = true;
        return region;
    }

    public Vector3i calculateInternalCenterPos(ServerShip ship, ServerLevel level) {
        ChunkClaim claim = ship.getChunkClaim();
        return claim.getCenterBlockCoordinates(VSGameUtilsKt.getYRange((Level)level), new Vector3i());
    }

    public void copyBlock(ServerLevel world, BlockPos sourcePos, BlockPos destPos) {
        BlockEntity newTE;
        BlockState state = world.m_8055_(sourcePos);
        BlockEntity tileEntity = world.m_7702_(sourcePos);
        world.m_7731_(destPos, state, 3);
        if (tileEntity != null && (newTE = world.m_7702_(destPos)) != null) {
            CompoundTag nbt = tileEntity.m_187482_();
            newTE.m_142466_(nbt);
        }
    }

    public void removeBlock(ServerLevel world, BlockPos pos) {
        world.m_7471_(pos, false);
    }

    private BlockPos findAutoTarget() {
        BlockPos checkPos;
        double maxDistance;
        if (this.f_58857_ == null) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        BlockPos pulleyPos = this.m_58899_();
        AnchorTarget anchorTarget = this.findPulleyAnchorTarget(serverLevel, pulleyPos, maxDistance = this.getMaxRopeLength());
        if (anchorTarget != null) {
            System.out.println("AUTO MODE: Found pulley anchor target at " + String.valueOf(anchorTarget.pos));
            this.previewAttachVec = anchorTarget.attachPoint;
            return anchorTarget.pos;
        }
        BlockPos shipTarget = this.findShipTarget(serverLevel, pulleyPos, maxDistance);
        if (shipTarget != null) {
            BlockPos anchorInShip;
            System.out.println("AUTO MODE: Found ship target at " + String.valueOf(shipTarget));
            this.previewTargetPos = shipTarget;
            LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)shipTarget);
            if (targetShip instanceof ServerShip && (anchorInShip = this.findPulleyAnchorInShip(serverLevel, (Ship)targetShip)) != null) {
                System.out.println("AUTO MODE: Found pulley anchor inside existing ship at " + String.valueOf(anchorInShip));
                return anchorInShip;
            }
            return shipTarget;
        }
        for (int y = 1; y <= (int)maxDistance && (checkPos = pulleyPos.m_6625_(y)).m_123342_() >= this.f_58857_.m_141937_(); ++y) {
            BlockState state = this.f_58857_.m_8055_(checkPos);
            if (state.m_60795_() || !state.m_60804_((BlockGetter)this.f_58857_, checkPos)) continue;
            if (this.isBlockSuperglued(serverLevel, checkPos)) {
                System.out.println("AUTO MODE: Found superglued structure at " + String.valueOf(checkPos));
                this.previewTargetPos = checkPos;
                Set<BlockPos> gluedCluster = this.findSupergluedCluster(serverLevel, checkPos);
                if (gluedCluster.isEmpty()) continue;
                System.out.println("AUTO MODE: Physifying glued cluster of size " + gluedCluster.size());
                PhysifyResult result = this.physifyBlocksIntoShip(serverLevel, gluedCluster, anchorTarget != null ? anchorTarget.pos : null);
                if (result != null && result.ship != null) {
                    if (result.pulleyAnchorWorldPos != null) {
                        System.out.println("AUTO MODE: Attaching pulley to pulley anchor inside physified ship at " + String.valueOf(result.pulleyAnchorWorldPos));
                        return result.pulleyAnchorWorldPos;
                    }
                    Vector3d pulleyWorldPos = this.getWorldPosition(serverLevel, pulleyPos, null);
                    BlockPos attachPos = this.findBlockOnShip(serverLevel, result.ship, pulleyWorldPos, maxDistance);
                    if (attachPos != null) {
                        Vector3d attachWorldPos = this.getWorldPosition(serverLevel, attachPos, result.ship);
                        BlockPos attachWorldBlockPos = BlockPos.m_274446_((Position)PhysPulleyBlockEntity.toVec3(attachWorldPos));
                        System.out.println("AUTO MODE: Attaching pulley to physified ship block at " + String.valueOf(attachWorldBlockPos) + " (converted from ship coords)");
                        return attachWorldBlockPos;
                    }
                }
                System.out.println("AUTO MODE: Physify failed, falling back to block at " + String.valueOf(checkPos));
                return checkPos;
            }
            System.out.println("AUTO MODE: Found solid block target at " + String.valueOf(checkPos));
            return checkPos;
        }
        System.out.println("AUTO MODE: No suitable target found within " + maxDistance + " blocks");
        return null;
    }

    private static Vec3 toVec3(Vector3d vec) {
        return new Vec3(vec.x, vec.y, vec.z);
    }

    public BlockPos getPreviewTargetPos() {
        return this.previewTargetPos;
    }

    private Vector3d getRopeAnchorPos(ServerLevel level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        double offset = 0.4;
        switch (facing) {
            case DOWN: {
                y = pos.m_123342_();
                break;
            }
            case UP: {
                y = (double)pos.m_123342_() + 1.0;
                break;
            }
            case NORTH: {
                z = pos.m_123343_();
                break;
            }
            case SOUTH: {
                z = (double)pos.m_123343_() + 1.0;
                break;
            }
            case WEST: {
                x = pos.m_123341_();
                break;
            }
            case EAST: {
                x = (double)pos.m_123341_() + 1.0;
            }
        }
        return new Vector3d(x, y, z);
    }

    private AnchorTarget findPulleyAnchorTarget(ServerLevel serverLevel, BlockPos pulleyPos, double maxDistance) {
        int radius = (int)Math.ceil(maxDistance);
        AnchorTarget closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (int x = pulleyPos.m_123341_() - radius; x <= pulleyPos.m_123341_() + radius; ++x) {
            for (int y = pulleyPos.m_123342_() - radius; y <= pulleyPos.m_123342_() + radius; ++y) {
                for (int z = pulleyPos.m_123343_() - radius; z <= pulleyPos.m_123343_() + radius; ++z) {
                    double dist;
                    BlockPos checkPos = new BlockPos(x, y, z);
                    BlockState state = serverLevel.m_8055_(checkPos);
                    if (state.m_60734_() != VStuffBlocks.PHYS_PULLEY.get() || !((dist = pulleyPos.m_123331_((Vec3i)checkPos)) < closestDistance)) continue;
                    closestDistance = dist;
                    Vector3d attach = this.getRopeAnchorPos(serverLevel, checkPos, state);
                    closest = new AnchorTarget(checkPos, attach);
                }
            }
        }
        return closest;
    }

    private boolean isBlockSuperglued(ServerLevel level, BlockPos pos) {
        AABB blockBox = new AABB(pos);
        List glueEntities = level.m_6443_(SuperGlueEntity.class, blockBox, e -> e != null);
        return !glueEntities.isEmpty();
    }

    private Set<BlockPos> findSupergluedCluster(ServerLevel level, BlockPos startPos) {
        HashSet<BlockPos> cluster = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(startPos);
        while (!toCheck.isEmpty()) {
            BlockPos current = (BlockPos)toCheck.poll();
            if (cluster.contains(current)) continue;
            cluster.add(current);
            System.out.println("Added block to cluster: " + String.valueOf(current));
            List<BlockPos> gluedNeighbors = this.getSupergluedNeighbors(level, current);
            System.out.println("Neighbors for " + String.valueOf(current) + ": " + String.valueOf(gluedNeighbors));
            for (BlockPos neighbor : gluedNeighbors) {
                if (cluster.contains(neighbor)) continue;
                toCheck.add(neighbor);
                System.out.println("Queued neighbor: " + String.valueOf(neighbor));
            }
        }
        return cluster;
    }

    private List<BlockPos> getSupergluedNeighbors(ServerLevel level, BlockPos pos) {
        ArrayList<BlockPos> gluedNeighbors = new ArrayList<BlockPos>();
        for (Direction dir : Direction.values()) {
            BlockPos neighbor = pos.m_121945_(dir);
            if (!this.isBlockSuperglued(level, neighbor)) continue;
            gluedNeighbors.add(neighbor);
        }
        return gluedNeighbors;
    }

    private BlockPos findShipTarget(ServerLevel serverLevel, BlockPos pulleyPos, double maxDistance) {
        try {
            QueryableShipData allShips = VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).getAllShips();
            LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pulleyPos);
            Vector3d pulleyWorldPos = this.getWorldPosition(serverLevel, pulleyPos, (Ship)pulleyShip);
            BlockPos closestShipBlock = null;
            double closestDistance = Double.MAX_VALUE;
            for (Ship ship : allShips) {
                Vector3d blockWorldPos;
                double blockDistance;
                BlockPos shipBlock;
                Vector3d shipCenter;
                double distanceToShip;
                if (pulleyShip != null && ship.getId() == pulleyShip.getId() || !((distanceToShip = pulleyWorldPos.distance((Vector3dc)(shipCenter = (Vector3d)ship.getTransform().getPositionInWorld()))) <= maxDistance) || (shipBlock = this.findBlockOnShip(serverLevel, ship, pulleyWorldPos, maxDistance)) == null || !((blockDistance = pulleyWorldPos.distance((Vector3dc)(blockWorldPos = this.getWorldPosition(serverLevel, shipBlock, ship)))) < closestDistance) || !(blockDistance <= maxDistance)) continue;
                closestDistance = blockDistance;
                closestShipBlock = shipBlock;
            }
            return closestShipBlock;
        }
        catch (Exception e) {
            System.err.println("Error finding ship target: " + e.getMessage());
            return null;
        }
    }

    private BlockPos findBlockOnShip(ServerLevel serverLevel, Ship ship, Vector3d pulleyWorldPos, double maxDistance) {
        try {
            AABBic shipAABB = ship.getShipAABB();
            if (shipAABB == null) {
                return null;
            }
            double centerX = (double)(shipAABB.minX() + shipAABB.maxX()) / 2.0;
            double centerZ = (double)(shipAABB.minZ() + shipAABB.maxZ()) / 2.0;
            int minY = (int)Math.floor(shipAABB.minY());
            int maxY = (int)Math.ceil(shipAABB.maxY());
            BlockPos bestPos = null;
            double closestDistance = Double.MAX_VALUE;
            int radius = 2;
            for (int y = maxY; y >= minY; --y) {
                for (int x = (int)Math.floor(centerX) - radius; x <= (int)Math.floor(centerX) + radius; ++x) {
                    for (int z = (int)Math.floor(centerZ) - radius; z <= (int)Math.floor(centerZ) + radius; ++z) {
                        Vector3d blockWorldPos;
                        double distance;
                        BlockPos candidatePos = new BlockPos(x, y, z);
                        BlockState state = serverLevel.m_8055_(candidatePos);
                        if (state.m_60795_() || !state.m_60804_((BlockGetter)serverLevel, candidatePos) || !((distance = pulleyWorldPos.distance((Vector3dc)(blockWorldPos = this.getWorldPosition(serverLevel, candidatePos, ship)))) <= maxDistance) || bestPos != null && y <= bestPos.m_123342_() && (y != bestPos.m_123342_() || !(distance < closestDistance))) continue;
                        bestPos = candidatePos;
                        closestDistance = distance;
                    }
                }
                if (bestPos == null) continue;
                return bestPos;
            }
            return null;
        }
        catch (Exception e) {
            System.err.println("Error finding block on ship: " + e.getMessage());
            return null;
        }
    }

    public double getMinRopeLength() {
        return this.minRopeLength;
    }

    public Integer getConstraintId() {
        return this.constraintId;
    }

    public void onLoad() {
        Level level;
        super.onLoad();
        this.initializeRopeInventory();
        this.ropeStateInitialized = false;
        this.restoring = true;
        if (!this.wasCut && this.hasTarget && this.constraintId != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Integer newId = this.createConstraintWithLength(this.currentRopeLength);
            if (newId != null) {
                this.constraintId = newId;
                System.out.println("Recreated constraint at length " + this.currentRopeLength + " after reload");
            }
        }
        this.ropeStateInitialized = true;
        this.restoring = false;
    }

    public void tick() {
        BlockPos autoTarget;
        PulleyMode currentMode;
        super.tick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        ++this.tickCounter;
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        if (!this.constraintRestored) {
            this.recreateConstraintOnLoad(serverLevel);
            this.constraintRestored = true;
        }
        if ((currentMode = this.getPulleyMode()) != this.lastMode) {
            this.onModeChanged(this.lastMode, currentMode);
            this.lastMode = currentMode;
        }
        if (!(this.constraintId == null || this.lastMode == PulleyMode.MANUAL || this.ropeStateInitialized || this.tickCounter != 20 && this.tickCounter != 60 && this.tickCounter != 120)) {
            if (!this.isConstraintValid(serverLevel)) {
                this.restoreConstraintAfterLoad(serverLevel);
            } else {
                this.ropeStateInitialized = true;
            }
        }
        double speed = this.getSpeed();
        BlockPos pulleyBlockPos = this.m_58899_();
        if (pulleyBlockPos == null) {
            return;
        }
        if (currentMode == PulleyMode.AUTO && speed < 0.0 && !this.hasTarget && !this.isLowering && (autoTarget = this.findAutoTarget()) != null) {
            this.pendingTargetPos = autoTarget;
            LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pulleyBlockPos);
            LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)autoTarget);
            if (pulleyShip == null || targetShip == null) {
                return;
            }
            Vector3d pulleyWorldPos = this.getWorldPosition(serverLevel, pulleyBlockPos, (Ship)pulleyShip);
            Vector3d targetWorldPos = this.getWorldPosition(serverLevel, autoTarget, (Ship)targetShip);
            double rawDistance = pulleyWorldPos.distance((Vector3dc)targetWorldPos);
            double maxDistance = this.getRawMaxRopeLength();
            this.pendingTargetDistance = Math.min(rawDistance, maxDistance);
            this.isLowering = true;
            this.sendData();
            System.out.println("AUTO MODE: Starting lowering to " + String.valueOf(this.pendingTargetPos) + " over distance " + this.pendingTargetDistance);
        }
        if (this.isLowering && this.pendingTargetPos != null) {
            Set<BlockPos> cluster;
            PhysifyResult result;
            LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pulleyBlockPos);
            LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.pendingTargetPos);
            if (pulleyShip == null || targetShip == null) {
                return;
            }
            Vector3d pulleyWorldPos = this.getWorldPosition(serverLevel, pulleyBlockPos, (Ship)pulleyShip);
            Vector3d targetWorldPos = this.getWorldPosition(serverLevel, this.pendingTargetPos, (Ship)targetShip);
            double step = this.getLengthChangeRate() / 8.0;
            double distance = this.pendingTargetDistance;
            double newLen = Math.min(this.currentRopeLength + step, distance);
            double progress = distance > 0.0 ? newLen / distance : 1.0;
            this.ropeEndPos = new Vector3d(pulleyWorldPos.x + (targetWorldPos.x - pulleyWorldPos.x) * progress, pulleyWorldPos.y + (targetWorldPos.y - pulleyWorldPos.y) * progress, pulleyWorldPos.z + (targetWorldPos.z - pulleyWorldPos.z) * progress);
            this.currentRopeLength = newLen;
            this.isRopeRendering = true;
            this.sendData();
            BlockPos checkPos = BlockPos.m_274561_((double)this.ropeEndPos.x, (double)this.ropeEndPos.y, (double)this.ropeEndPos.z);
            LoadedServerShip foundShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)checkPos);
            if (foundShip != null) {
                this.finishAutoAttach(serverLevel, checkPos);
                return;
            }
            if (this.isBlockSuperglued(serverLevel, checkPos) && (result = this.physifyBlocksIntoShip(serverLevel, cluster = this.findSupergluedCluster(serverLevel, checkPos), checkPos)) != null && result.ship != null) {
                this.finishAutoAttach(serverLevel, checkPos);
                return;
            }
            if (progress >= 0.999) {
                this.finishAutoAttach(serverLevel, this.pendingTargetPos);
                this.isLowering = false;
                this.targetPos = this.pendingTargetPos;
                this.pendingTargetPos = null;
                this.ropeEndPos = targetWorldPos;
                this.hasTarget = true;
                if (this.constraintId != null) {
                    this.removeExistingConstraint();
                }
                this.createAutoConstraint();
                System.out.println("AUTO MODE: Rope attached to " + String.valueOf(this.targetPos));
            }
        } else if (currentMode == PulleyMode.MANUAL && this.hasTarget) {
            double step = this.getLengthChangeRate() / 4.0;
            if (speed > 0.0) {
                this.extendRope(step);
            } else if (speed < 0.0) {
                this.retractRope(step);
            }
            if (this.targetPos != null) {
                LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pulleyBlockPos);
                LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.targetPos);
                if (pulleyShip != null && targetShip != null) {
                    Vector3d pulleyWorldPos = this.getWorldPosition(serverLevel, pulleyBlockPos, (Ship)pulleyShip);
                    Vector3d targetWorldPos = this.getWorldPosition(serverLevel, this.targetPos, (Ship)targetShip);
                    Vector3d dir = targetWorldPos.sub((Vector3dc)pulleyWorldPos).normalize();
                    this.ropeEndPos = pulleyWorldPos.add((Vector3dc)dir.mul(this.currentRopeLength));
                    this.isRopeRendering = true;
                    this.sendData();
                }
            }
        } else if (currentMode == PulleyMode.AUTO && this.hasTarget) {
            double step = this.getLengthChangeRate() / 4.0;
            if (speed < 0.0) {
                this.retractRope(step);
            } else if (speed > 0.0) {
                this.extendRope(step);
            }
        }
    }

    private void finishAutoAttach(ServerLevel serverLevel, BlockPos attachPos) {
        this.isLowering = false;
        this.pendingTargetPos = null;
        this.targetPos = attachPos;
        this.hasTarget = true;
        if (this.constraintId != null) {
            this.removeExistingConstraint();
        }
        if (this.createAutoConstraint()) {
            System.out.println("AUTO MODE: Rope attached to " + String.valueOf(attachPos));
        } else {
            System.err.println("AUTO MODE: Failed to create constraint at " + String.valueOf(attachPos));
        }
    }

    public void removeExistingConstraint() {
        this.removeExistingConstraint(false);
    }

    private boolean updateLocalPositions() {
        if (this.f_58857_.f_46443_) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        BlockPos pulleyPos = this.m_58899_();
        if (pulleyPos == null) {
            System.err.println("Pulley block position is null!");
            return false;
        }
        if (this.targetPos == null) {
            System.err.println("Target position is null!");
            return false;
        }
        LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pulleyPos);
        LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.targetPos);
        this.shipA = pulleyShip != null ? Long.valueOf(pulleyShip.getId()) : this.getGroundBodyId(serverLevel);
        this.shipB = targetShip != null ? Long.valueOf(targetShip.getId()) : this.getGroundBodyId(serverLevel);
        this.localPosA = this.getLocalPosition(serverLevel, pulleyPos, (Ship)pulleyShip, this.shipA);
        this.localPosB = this.getLocalPosition(serverLevel, this.targetPos, (Ship)targetShip, this.shipB);
        return this.localPosA != null && this.localPosB != null;
    }

    public void sendData() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void extendRope(double amount) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.hasTarget) {
            return;
        }
        double maxRopeLength = this.getRawMaxRopeLength();
        double newLength = this.currentRopeLength + amount;
        if (this.lastMode == PulleyMode.MANUAL) {
            Level level;
            if (newLength > maxRopeLength) {
                newLength = maxRopeLength;
                amount = newLength - this.currentRopeLength;
            }
            this.currentRopeLength = newLength;
            this.actuallyConsumeRope(amount);
            if (this.constraintId != null && (level = this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.removeExistingConstraint(true);
                Integer newId = this.createConstraintWithLength(this.currentRopeLength);
                if (newId != null) {
                    this.constraintId = newId;
                }
            }
            this.m_6596_();
            this.sendData();
            return;
        }
        if (this.consumeRope(amount)) {
            this.currentRopeLength = newLength;
            this.m_6596_();
            this.sendData();
        }
    }

    private void retractRope(double amount) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.hasTarget) {
            return;
        }
        double newLength = this.currentRopeLength - amount;
        if (newLength < this.baseRopeLength) {
            newLength = this.baseRopeLength;
        }
        if (this.lastMode == PulleyMode.MANUAL) {
            Level level;
            this.currentRopeLength = newLength;
            this.returnRope(amount);
            if (this.constraintId != null && (level = this.f_58857_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.removeExistingConstraint(true);
                Integer newId = this.createConstraintWithLength(this.currentRopeLength);
                if (newId != null) {
                    this.constraintId = newId;
                }
            }
            this.m_6596_();
            this.sendData();
            return;
        }
        this.returnRope(amount);
        this.currentRopeLength = newLength;
        this.m_6596_();
        this.sendData();
    }

    public double getCurrentRopeLength() {
        return this.currentRopeLength;
    }

    private boolean isConstraintValid(int id, ServerLevel serverLevel) {
        return ConstraintTracker.constraintExists(serverLevel, id);
    }

    private void clearConstraint() {
        this.constraintId = null;
        this.ropeStateInitialized = false;
        this.isRopeRendering = false;
        this.m_6596_();
        this.sendData();
    }

    public boolean isLowering() {
        return this.isLowering;
    }

    public boolean isRopeRendering() {
        return this.isRopeRendering;
    }

    private Integer createConstraintWithLength(double length) {
        double currentDist;
        if (this.f_58857_.f_46443_ || !this.hasTarget || !this.hasRope() || this.constraintId != null) {
            return null;
        }
        if (!this.updateLocalPositions()) {
            System.err.println("Cannot create constraint: localPosA or localPosB is null");
            return null;
        }
        if (this.localPosA != null && this.localPosB != null && (currentDist = this.localPosA.distance((Vector3dc)this.localPosB)) < 0.1) {
            this.localPosB = new Vector3d(this.localPosA.x, this.localPosA.y - length, this.localPosA.z);
            System.out.println("Adjusted localPosB to maintain rope length after cut: " + String.valueOf(this.localPosB));
        }
        try {
            Long realShipB;
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel);
            Long groundShipId = (Long)shipWorld.getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)serverLevel));
            Long realShipA = this.shipA;
            if (realShipA == null || shipWorld.getAllShips().getById(realShipA.longValue()) == null) {
                System.out.println("Ship A missing or invalid, using groundShipId instead");
                realShipA = groundShipId;
            }
            if ((realShipB = this.shipB) == null || shipWorld.getAllShips().getById(realShipB.longValue()) == null) {
                System.out.println("Ship B missing or invalid, using groundShipId instead");
                realShipB = groundShipId;
            }
            System.out.println("Creating constraint: shipA=" + realShipA + ", shipB=" + realShipB + ", length=" + length);
            VSRopeConstraint constraint = new VSRopeConstraint(realShipA.longValue(), realShipB.longValue(), 1.0E-9, (Vector3dc)this.localPosA, (Vector3dc)this.localPosB, 9.99999999E8, length);
            Integer newConstraintId = shipWorld.createNewConstraint((VSConstraint)constraint);
            if (newConstraintId != null) {
                this.constraintId = newConstraintId;
                this.consumedRopeLength = Math.max(0.0, length - this.baseRopeLength);
                this.ropeStateInitialized = true;
                this.isRopeRendering = true;
                ConstraintTracker.cleanupOrphanedConstraints(serverLevel, this.m_58899_());
                ConstraintTracker.addConstraintWithPersistence(serverLevel, this.constraintId, realShipA, realShipB, this.localPosA, this.localPosB, length, 1.0E-9, 5.0E7, ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY, this.m_58899_(), new RopeStyles.RopeStyle("normal", RopeStyles.PrimitiveRopeStyle.NORMAL, "vstuff.ropes.normal"));
                System.out.println("Created constraint " + this.constraintId + " with length " + length);
                return this.constraintId;
            }
            System.err.println("Failed to create constraint");
            return null;
        }
        catch (Exception e) {
            System.err.println("Error creating constraint: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private boolean isConstraintValid(ServerLevel serverLevel) {
        if (this.constraintId == null) {
            return false;
        }
        return ConstraintTracker.constraintExists(serverLevel, this.constraintId);
    }

    private double getRawMaxRopeLength() {
        double ropePerItem;
        ItemStack ropeStack = this.ropeInventory.getStackInSlot(0);
        if (ropeStack.m_41619_()) {
            return 0.0;
        }
        if (ropeStack.m_41720_() == VStuffItems.LEAD_CONSTRAINT_ITEM.get()) {
            ropePerItem = 2.0;
        } else if (ropeStack.m_41720_() == Items.f_42655_) {
            ropePerItem = 1.5;
        } else if (ropeStack.m_41720_() == Items.f_42401_) {
            ropePerItem = 1.0;
        } else {
            return 0.0;
        }
        return (double)ropeStack.m_41613_() * ropePerItem;
    }

    private void forceConstraintRefresh(Player player) {
        Level level;
        if (this.constraintId != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            System.out.println("Force refreshing constraint " + this.constraintId);
            double oldLength = this.currentRopeLength;
            boolean hadTarget = this.hasTarget;
            BlockPos oldTargetPos = this.targetPos;
            this.removeExistingConstraint();
            this.ropeStateInitialized = false;
            this.hasTarget = hadTarget;
            this.targetPos = oldTargetPos;
            this.currentRopeLength = oldLength;
            if (this.hasTarget && this.hasRope()) {
                this.createConstraint(player);
            }
        }
    }

    private void restoreConstraintAfterLoad(ServerLevel serverLevel) {
        try {
            if (this.targetPos == null || this.shipA == null || this.shipB == null || this.localPosA == null || this.localPosB == null) {
                System.out.println("Missing constraint data, cannot restore. Clearing constraint ID.");
                this.constraintId = null;
                this.ropeStateInitialized = false;
                this.m_6596_();
                return;
            }
            LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.m_58899_());
            LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.targetPos);
            Long newShipA = pulleyShip != null ? Long.valueOf(pulleyShip.getId()) : this.getGroundBodyId(serverLevel);
            Long newShipB = targetShip != null ? Long.valueOf(targetShip.getId()) : this.getGroundBodyId(serverLevel);
            Vector3d newLocalPosA = this.getLocalPosition(serverLevel, this.m_58899_(), (Ship)pulleyShip, newShipA);
            Vector3d newLocalPosB = this.getLocalPosition(serverLevel, this.targetPos, (Ship)targetShip, newShipB);
            double currentRopeInInventory = this.getRawMaxRopeLength();
            double totalRopeCapacity = this.baseRopeLength + currentRopeInInventory;
            double restoredLength = Math.min(this.currentRopeLength, totalRopeCapacity);
            double shouldBeConsumed = Math.max(0.0, restoredLength - this.baseRopeLength);
            this.shipA = newShipA;
            this.shipB = newShipB;
            this.localPosA = newLocalPosA;
            this.localPosB = newLocalPosB;
            this.consumedRopeLength = shouldBeConsumed;
            System.out.println("Restoring constraint with updated data:");
            System.out.println("  - ShipA: " + this.shipA + " -> " + newShipA);
            System.out.println("  - ShipB: " + this.shipB + " -> " + newShipB);
            System.out.println("  - Length: " + restoredLength);
            System.out.println("  - Consumed: " + this.consumedRopeLength);
            if (this.constraintId != null) {
                try {
                    VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).removeConstraint(this.constraintId.intValue());
                    ConstraintTracker.removeConstraintWithPersistence(serverLevel, this.constraintId);
                }
                catch (Exception e) {
                    System.out.println("Old constraint was already gone: " + e.getMessage());
                }
            }
            VSRopeConstraint restoredConstraint = new VSRopeConstraint(this.shipA.longValue(), this.shipB.longValue(), 1.0E-9, (Vector3dc)this.localPosA, (Vector3dc)this.localPosB, 9.0E8, restoredLength);
            Integer newConstraintId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).createNewConstraint((VSConstraint)restoredConstraint);
            if (newConstraintId != null) {
                this.constraintId = newConstraintId;
                this.currentRopeLength = restoredLength;
                this.ropeStateInitialized = true;
                this.isRopeRendering = true;
                ConstraintTracker.addConstraintWithPersistence(serverLevel, this.constraintId, this.shipA, this.shipB, this.localPosA, this.localPosB, this.currentRopeLength, 1.0E-9, 5.0E7, ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY, this.m_58899_(), new RopeStyles.RopeStyle("normal", RopeStyles.PrimitiveRopeStyle.NORMAL, "vstuff.ropes.normal"));
                System.out.println("Successfully restored constraint " + this.constraintId + " with length " + this.currentRopeLength);
                this.m_6596_();
                this.sendData();
            } else {
                System.err.println("Failed to restore constraint after world load");
                this.constraintId = null;
                this.ropeStateInitialized = false;
                this.m_6596_();
            }
        }
        catch (Exception e) {
            System.err.println("Error restoring constraint after load: " + e.getMessage());
            e.printStackTrace();
            this.constraintId = null;
            this.ropeStateInitialized = false;
            this.m_6596_();
        }
    }

    public void onBlockRemoved() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cleanupAllConstraints(serverLevel);
        }
    }

    public void invalidate() {
        super.invalidate();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cleanupAllConstraints(serverLevel);
        }
    }

    public void removeExistingConstraint(boolean force) {
        Level level;
        this.wasCut = true;
        if (this.isManualMode() && !force) {
            System.out.println("MANUAL MODE: Skipping removeExistingConstraint");
            return;
        }
        if (this.constraintId != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ConstraintTracker.removeConstraintWithPersistence(serverLevel, this.constraintId);
            this.constraintId = null;
            this.m_6596_();
            this.sendData();
            System.out.println("Removed constraint and cleaned up");
        }
        this.previewTargetPos = null;
        this.previewAttachVec = null;
        if (!this.isManualMode()) {
            this.currentRopeLength = this.baseRopeLength;
            this.hasTarget = false;
            this.targetPos = null;
        }
    }

    public void cleanupAllConstraints(ServerLevel serverLevel) {
        if (this.constraintId != null) {
            try {
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).removeConstraint(this.constraintId.intValue());
                ConstraintTracker.removeConstraintWithPersistence(serverLevel, this.constraintId);
                System.out.println("Cleaned up constraint " + this.constraintId);
            }
            catch (Exception e) {
                System.out.println("Constraint " + this.constraintId + " was already gone");
            }
            this.constraintId = null;
        }
        this.isRopeRendering = false;
        ConstraintTracker.cleanupOrphanedConstraints(serverLevel, this.m_58899_());
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        Item leadItem = (Item)VStuffItems.LEAD_CONSTRAINT_ITEM.get();
        if (player.m_6144_()) {
            this.waitingForTarget = true;
            this.m_6596_();
            this.sendData();
            PhysPulleyItem.setWaitingPulley(player, this);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7aPulley manual targeting mode enabled. Next rope click sets target."));
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41720_() == leadItem) {
            if (heldItem.m_41613_() > 0) {
                return this.insertRope(player, hand, heldItem);
            }
            return InteractionResult.FAIL;
        }
        if (this.constraintId != null) {
            // empty if block
        }
        return InteractionResult.PASS;
    }

    public void createManualConstraint() {
        if (this.f_58857_.f_46443_) {
            System.out.println("MANUAL MODE: Skipping constraint creation on client side");
            return;
        }
        this.setManualMode(true);
        System.out.println("MANUAL MODE: Starting constraint creation");
        if (!this.hasTarget) {
            System.out.println("MANUAL MODE: No target set, cannot create constraint");
            return;
        }
        if (!this.hasRope()) {
            System.out.println("MANUAL MODE: No rope available, cannot create constraint");
            return;
        }
        if (this.constraintId != null) {
            System.out.println("MANUAL MODE: Constraint already exists with ID: " + this.constraintId);
            return;
        }
        try {
            double initialLength;
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.m_58899_());
            LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.targetPos);
            if (pulleyShip == null) {
                System.out.println("MANUAL MODE: pulleyShip is null");
            } else {
                System.out.println("MANUAL MODE: pulleyShip ID = " + pulleyShip.getId());
            }
            if (targetShip == null) {
                System.out.println("MANUAL MODE: targetShip is null");
            } else {
                System.out.println("MANUAL MODE: targetShip ID = " + targetShip.getId());
            }
            this.shipA = pulleyShip != null ? Long.valueOf(pulleyShip.getId()) : this.getGroundBodyId(serverLevel);
            this.shipB = targetShip != null ? Long.valueOf(targetShip.getId()) : this.getGroundBodyId(serverLevel);
            System.out.println("MANUAL MODE: Using shipA ID = " + this.shipA);
            System.out.println("MANUAL MODE: Using shipB ID = " + this.shipB);
            this.localPosA = this.getLocalPosition(serverLevel, this.m_58899_(), (Ship)pulleyShip, this.shipA);
            this.localPosB = this.getLocalPosition(serverLevel, this.targetPos, (Ship)targetShip, this.shipB);
            System.out.println("MANUAL MODE: localPosA = " + String.valueOf(this.localPosA));
            System.out.println("MANUAL MODE: localPosB = " + String.valueOf(this.localPosB));
            Vector3d pulleyWorldPos = this.getWorldPosition(serverLevel, this.m_58899_(), (Ship)pulleyShip);
            Vector3d targetWorldPos = this.getWorldPosition(serverLevel, this.targetPos, (Ship)targetShip);
            System.out.println("MANUAL MODE: pulleyWorldPos = " + String.valueOf(pulleyWorldPos));
            System.out.println("MANUAL MODE: targetWorldPos = " + String.valueOf(targetWorldPos));
            double distance = pulleyWorldPos.distance((Vector3dc)targetWorldPos);
            System.out.println("MANUAL MODE: Distance between pulley and target = " + distance);
            double maxAvailable = this.getRawMaxRopeLength();
            System.out.println("MANUAL MODE: maxAvailable rope length = " + maxAvailable);
            double targetLength = Math.min(distance + 1.0, maxAvailable);
            targetLength = Math.max(targetLength, this.minRopeLength);
            System.out.println("MANUAL MODE: Calculated target rope length = " + targetLength);
            this.targetRopeLength = targetLength;
            this.isExtending = true;
            this.currentRopeLength = initialLength = targetLength;
            VSRopeConstraint constraint = new VSRopeConstraint(this.shipA.longValue(), this.shipB.longValue(), 1.0E-9, (Vector3dc)this.localPosA, (Vector3dc)this.localPosB, 9.0E8, initialLength);
            Integer newConstraintId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).createNewConstraint((VSConstraint)constraint);
            System.out.println("MANUAL MODE: createNewConstraint returned ID: " + newConstraintId);
            if (newConstraintId != null) {
                this.constraintId = newConstraintId;
                this.consumedRopeLength = Math.max(0.0, this.currentRopeLength - this.baseRopeLength);
                this.ropeStateInitialized = true;
                this.isRopeRendering = true;
                ConstraintTracker.addConstraintWithPersistence(serverLevel, this.constraintId, this.shipA, this.shipB, this.localPosA, this.localPosB, this.currentRopeLength, 1.0E-9, 1.5E7, ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY, this.m_58899_(), new RopeStyles.RopeStyle("normal", RopeStyles.PrimitiveRopeStyle.NORMAL, "vstuff.ropes.normal"));
                this.m_6596_();
                this.sendData();
                System.out.println("MANUAL MODE: Successfully created constraint with ID " + this.constraintId);
            } else {
                System.err.println("MANUAL MODE: Failed to create constraint (null ID returned)");
            }
        }
        catch (Exception e) {
            System.err.println("MANUAL MODE: Exception while creating constraint: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setManualTarget(BlockPos targetPos) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.targetPos = targetPos;
        this.hasTarget = true;
        this.waitingForTarget = false;
        this.createManualConstraint();
        this.isRopeRendering = true;
        this.m_6596_();
        this.sendData();
    }

    private InteractionResult handleConstraintCreation(Player player) {
        if (this.constraintId != null) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7aConstraint active! Length: " + String.format("%.1f", this.currentRopeLength) + " blocks")));
            return InteractionResult.SUCCESS;
        }
        if (this.hasTarget && this.hasRope()) {
            this.createConstraint(player);
            return InteractionResult.SUCCESS;
        }
        if (!this.hasRope()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cNeed rope to create constraint!"));
            return InteractionResult.SUCCESS;
        }
        if (!this.hasTarget) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cNeed target position! Shift+Right-click to set target."));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult insertRope(Player player, InteractionHand hand, ItemStack heldItem) {
        System.out.println("Attempting to insert rope: held count = " + heldItem.m_41613_());
        ItemStack remainder = this.ropeInventory.insertItem(0, heldItem, false);
        System.out.println("After insert: remainder count = " + remainder.m_41613_());
        if (remainder.m_41613_() != heldItem.m_41613_()) {
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, remainder);
            }
            int inserted = heldItem.m_41613_() - remainder.m_41613_();
            if (this.hasTarget && this.constraintId == null && this.hasRope()) {
                System.out.println("Creating constraint after rope insert.");
                this.createConstraint(player);
            }
            return InteractionResult.SUCCESS;
        }
        System.out.println("No rope inserted.");
        return InteractionResult.PASS;
    }

    private void initializeRopeInventory() {
        ItemStack existingStack = ItemStack.f_41583_;
        if (this.ropeInventory != null) {
            existingStack = this.ropeInventory.getStackInSlot(0);
        }
        this.ropeInventory = new ItemStackHandler(1){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() == VStuffItems.LEAD_CONSTRAINT_ITEM.get() || stack.m_41720_() == Items.f_42401_ || stack.m_41720_() == Items.f_42655_;
            }

            protected void onContentsChanged(int slot) {
                PhysPulleyBlockEntity.this.m_6596_();
                PhysPulleyBlockEntity.this.sendData();
                if (PhysPulleyBlockEntity.this.f_58857_ != null && !((PhysPulleyBlockEntity)PhysPulleyBlockEntity.this).f_58857_.f_46443_) {
                    PhysPulleyBlockEntity.this.f_58857_.m_7260_(PhysPulleyBlockEntity.this.f_58858_, PhysPulleyBlockEntity.this.m_58900_(), PhysPulleyBlockEntity.this.m_58900_(), 3);
                }
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
        if (!existingStack.m_41619_()) {
            this.ropeInventory.setStackInSlot(0, existingStack);
        }
        if (this.ropeInventoryOptional != null) {
            this.ropeInventoryOptional.invalidate();
        }
        this.ropeInventoryOptional = LazyOptional.of(() -> this.ropeInventory);
    }

    private boolean createConstraint(Player player) {
        if (!this.hasTarget || !this.hasRope()) {
            return false;
        }
        if (this.constraintId != null) {
            return false;
        }
        try {
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            LoadedServerShip pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.m_58899_());
            LoadedServerShip targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.targetPos);
            return this.createConstraintImmediate(serverLevel, player);
        }
        catch (Exception e) {
            System.err.println("Error creating constraint: " + e.getMessage());
            e.printStackTrace();
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7cError creating constraint: " + e.getMessage())));
            return false;
        }
    }

    private boolean hasRope() {
        ItemStack ropeStack = this.ropeInventory.getStackInSlot(0);
        System.out.println("hasRope check: stack = " + String.valueOf(ropeStack) + ", count = " + ropeStack.m_41613_());
        return !ropeStack.m_41619_() && ropeStack.m_41613_() > 0;
    }

    private double getMaxRopeLength() {
        ItemStack ropeStack = this.ropeInventory.getStackInSlot(0);
        if (ropeStack.m_41619_()) {
            return this.baseRopeLength;
        }
        double ropePerItem = this.getRopePerItem(ropeStack.m_41720_());
        double availableFromItems = (double)ropeStack.m_41613_() * ropePerItem;
        return this.baseRopeLength + availableFromItems;
    }

    private double getAvailableRopeForExtension() {
        double maxTotal = this.getMaxRopeLength();
        double alreadyUsed = Math.max(0.0, this.currentRopeLength - this.baseRopeLength);
        return maxTotal - this.currentRopeLength;
    }

    private double getRopePerItem(Item item) {
        if (item == VStuffItems.LEAD_CONSTRAINT_ITEM.get()) {
            return 2.0;
        }
        if (item == Items.f_42655_) {
            return 1.5;
        }
        if (item == Items.f_42401_) {
            return 1.0;
        }
        return 0.0;
    }

    private boolean isValidRopeItem(ItemStack stack) {
        return stack.m_41720_() == Items.f_42401_ || stack.m_41720_() == Items.f_42655_ || stack.m_41720_() == VStuffItems.LEAD_CONSTRAINT_ITEM.get();
    }

    private Long getGroundBodyId(ServerLevel level) {
        return (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
    }

    private Vector3d getWorldPosition(ServerLevel level, BlockPos pos, Ship ship) {
        Vector3d localPos = new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (ship != null) {
            Vector3d worldPos = new Vector3d();
            ship.getTransform().getShipToWorld().transformPosition((Vector3dc)localPos, worldPos);
            return worldPos;
        }
        return localPos;
    }

    private Vector3d getLocalPosition(ServerLevel level, BlockPos pos, Ship pulleyShip, Long targetShipId) {
        Vector3d blockWorldPos = new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        if (targetShipId.equals(this.getGroundBodyId(level))) {
            return blockWorldPos;
        }
        Ship targetShip = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(targetShipId.longValue());
        if (targetShip != null) {
            Vector3d worldPos = new Vector3d();
            if (pulleyShip != null) {
                pulleyShip.getTransform().getShipToWorld().transformPosition((Vector3dc)blockWorldPos, worldPos);
            } else {
                worldPos.set((Vector3dc)blockWorldPos);
            }
            Vector3d localPos = new Vector3d();
            targetShip.getTransform().getWorldToShip().transformPosition((Vector3dc)worldPos, localPos);
            return localPos;
        }
        return blockWorldPos;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237113_((String)" "));
        ItemStack ropeStack = this.ropeInventory.getStackInSlot(0);
        if (!ropeStack.m_41619_()) {
            double maxLength = this.getMaxRopeLength() - this.baseRopeLength;
            tooltip.add((Component)Component.m_237113_((String)("Rope: " + ropeStack.m_41613_() + "/64 (" + String.format("%.1f", maxLength) + " blocks)")).m_130940_(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"No Rope - Right-click with rope item").m_130940_(ChatFormatting.RED));
        }
        if (this.constraintId != null) {
            tooltip.add((Component)Component.m_237113_((String)("Length: " + String.format("%.1f", this.currentRopeLength) + " blocks")).m_130940_(ChatFormatting.BLUE));
            float speed = this.getSpeed();
            if (Math.abs(speed) > 4.0f) {
                String direction = speed > 0.0f ? "Extending" : "Retracting";
                tooltip.add((Component)Component.m_237113_((String)("Status: " + direction + " (" + String.format("%.1f", Float.valueOf(speed)))).m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.m_237113_((String)"Status: Idle").m_130940_(ChatFormatting.GRAY));
            }
        } else if (this.hasTarget && this.hasRope()) {
            tooltip.add((Component)Component.m_237113_((String)"Ready - Right-click to create constraint").m_130940_(ChatFormatting.YELLOW));
        } else if (this.waitingForTarget) {
            tooltip.add((Component)Component.m_237113_((String)"\u00a7e\u00a7lClick any block to set target").m_130940_(ChatFormatting.YELLOW));
        } else if (!this.hasRope()) {
            tooltip.add((Component)Component.m_237113_((String)"Need rope and a target").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"No Target - Shift+Right-click to set").m_130940_(ChatFormatting.GRAY));
        }
        return true;
    }

    private InteractionResult handleTargetSetting(Player player) {
        if (!this.waitingForTarget) {
            this.waitingForTarget = true;
            this.hasTarget = false;
            this.targetPos = null;
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7aClick a block to set the rope target!"));
            this.m_6596_();
            this.sendData();
            return InteractionResult.SUCCESS;
        }
        this.waitingForTarget = false;
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7cTarget setting cancelled."));
        this.m_6596_();
        this.sendData();
        return InteractionResult.SUCCESS;
    }

    private boolean createConstraintImmediate(ServerLevel serverLevel, Player player) {
        try {
            LoadedServerShip pulleyShip = null;
            LoadedServerShip targetShip = null;
            for (int attempt = 0; attempt < 3; ++attempt) {
                pulleyShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.m_58899_());
                targetShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)this.targetPos);
                if (pulleyShip == null && targetShip == null) break;
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.shipA = pulleyShip != null ? Long.valueOf(pulleyShip.getId()) : this.getGroundBodyId(serverLevel);
            this.shipB = targetShip != null ? Long.valueOf(targetShip.getId()) : this.getGroundBodyId(serverLevel);
            this.localPosA = this.getLocalPosition(serverLevel, this.m_58899_(), (Ship)pulleyShip, this.shipA);
            this.localPosB = this.getLocalPosition(serverLevel, this.targetPos, (Ship)targetShip, this.shipB);
            Vector3d pulleyWorldPos = this.getWorldPosition(serverLevel, this.m_58899_(), (Ship)pulleyShip);
            Vector3d targetWorldPos = this.getWorldPosition(serverLevel, this.targetPos, (Ship)targetShip);
            double distance = pulleyWorldPos.distance((Vector3dc)targetWorldPos);
            double maxAvailable = this.getRawMaxRopeLength();
            double initialLength = Math.min(distance + 2.0, maxAvailable);
            this.currentRopeLength = initialLength = Math.max(initialLength, this.minRopeLength);
            double compliance = pulleyShip != null || targetShip != null ? 1.2E-7 : 8.0E-8;
            double maxForce = pulleyShip != null || targetShip != null ? 8000000.0 : 1.2E7;
            VSRopeConstraint constraint = new VSRopeConstraint(this.shipA.longValue(), this.shipB.longValue(), compliance, (Vector3dc)this.localPosA, (Vector3dc)this.localPosB, maxForce, this.currentRopeLength);
            this.constraintId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)serverLevel).createNewConstraint((VSConstraint)constraint);
            if (this.constraintId != null) {
                this.consumedRopeLength = 0.0;
                this.ropeStateInitialized = true;
                ConstraintTracker.addConstraintWithPersistence(serverLevel, this.constraintId, this.shipA, this.shipB, this.localPosA, this.localPosB, this.currentRopeLength, compliance, maxForce, ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY, this.m_58899_(), new RopeStyles.RopeStyle("normal", RopeStyles.PrimitiveRopeStyle.NORMAL, "vstuff.ropes.normal"));
                this.m_6596_();
                this.sendData();
                String pulleyType = pulleyShip != null ? "ship" : "ground";
                String targetType = targetShip != null ? "ship" : "ground";
                System.out.println("Created rope pulley constraint " + this.constraintId + " (" + pulleyType + " to " + targetType + ") with length " + this.currentRopeLength);
                this.forceConstraintRefresh(player);
                return true;
            }
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cFailed to create constraint!"));
            return false;
        }
        catch (Exception e) {
            System.err.println("Error in immediate constraint creation: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private double calculateWorldDistance(BlockPos pos1, BlockPos pos2) {
        if (this.f_58857_ == null) {
            return Double.MAX_VALUE;
        }
        try {
            Vector3d worldPos1 = this.getWorldPosition(pos1);
            Vector3d worldPos2 = this.getWorldPosition(pos2);
            double distance = worldPos1.distance((Vector3dc)worldPos2);
            System.out.println("World positions - Pos1: " + String.valueOf(worldPos1) + ", Pos2: " + String.valueOf(worldPos2) + ", Distance: " + distance);
            return distance;
        }
        catch (Exception e) {
            System.err.println("Error calculating world distance: " + e.getMessage());
            return Math.sqrt(pos1.m_123331_((Vec3i)pos2));
        }
    }

    private Vector3d getWorldPosition(BlockPos pos) {
        Vector3d localPos = new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        LoadedServerShip shipObject = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)((ServerLevel)this.f_58857_), (Vec3i)pos);
        if (shipObject != null) {
            Vector3d worldPos = new Vector3d();
            shipObject.getTransform().getShipToWorld().transformPosition((Vector3dc)localPos, worldPos);
            return worldPos;
        }
        return localPos;
    }

    private boolean consumeRope(double extensionAmount) {
        return true;
    }

    private void actuallyConsumeRope(double extensionAmount) {
    }

    private void returnRope(double amount) {
    }

    public void recreateConstraintOnLoad(ServerLevel serverLevel) {
        if (this.restoring) {
            return;
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_("RopeInventory", (Tag)this.ropeInventory.serializeNBT());
        if (this.targetPos != null) {
            tag.m_128356_("TargetPos", this.targetPos.m_121878_());
        }
        tag.m_128405_("PulleyMode", this.MODE != null ? this.MODE.getValue() : 0);
        tag.m_128379_("HasTarget", this.hasTarget);
        tag.m_128379_("WaitingForTarget", this.waitingForTarget);
        tag.m_128347_("ConsumedRopeLength", this.consumedRopeLength);
        tag.m_128347_("BaseRopeLength", this.baseRopeLength);
        tag.m_128379_("RopeStateInitialized", this.ropeStateInitialized);
        if (this.constraintId != null) {
            tag.m_128405_("ConstraintId", this.constraintId.intValue());
        }
        tag.m_128347_("CurrentRopeLength", this.currentRopeLength);
        tag.m_128347_("MinRopeLength", this.minRopeLength);
        tag.m_128379_("ManualMode", this.isManualMode());
        if (this.shipA != null && this.shipB != null && this.localPosA != null && this.localPosB != null) {
            tag.m_128356_("ShipA", this.shipA.longValue());
            tag.m_128356_("ShipB", this.shipB.longValue());
            tag.m_128347_("LocalPosAX", this.localPosA.x);
            tag.m_128347_("LocalPosAY", this.localPosA.y);
            tag.m_128347_("LocalPosAZ", this.localPosA.z);
            tag.m_128347_("LocalPosBX", this.localPosB.x);
            tag.m_128347_("LocalPosBY", this.localPosB.y);
            tag.m_128347_("LocalPosBZ", this.localPosB.z);
        }
        tag.m_128379_("DataSavedProperly", true);
        tag.m_128379_("IsLowering", this.isLowering);
        tag.m_128379_("IsRopeRendering", this.isRopeRendering);
        tag.m_128379_("WasCut", this.wasCut);
        System.out.println("Saving rope state - Length: " + this.currentRopeLength + ", Consumed: " + this.consumedRopeLength + ", Constraint: " + this.constraintId + ", Mode: " + String.valueOf(this.MODE != null ? Integer.valueOf(this.MODE.getValue()) : "null"));
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        int savedMode;
        super.read(tag, clientPacket);
        this.ropeInventory.deserializeNBT(tag.m_128469_("RopeInventory"));
        if (tag.m_128441_("TargetPos")) {
            this.targetPos = BlockPos.m_122022_((long)tag.m_128454_("TargetPos"));
        }
        if (tag.m_128441_("PulleyMode") && (savedMode = tag.m_128451_("PulleyMode")) >= 0 && savedMode < MODES.length) {
            this.loadedPulleyMode = savedMode;
        }
        this.isLowering = tag.m_128471_("IsLowering");
        this.isRopeRendering = tag.m_128471_("IsRopeRendering");
        this.wasCut = tag.m_128471_("WasCut");
        this.manualMode = tag.m_128471_("ManualMode");
        this.lastMode = this.getPulleyMode();
        this.hasTarget = tag.m_128471_("HasTarget");
        this.waitingForTarget = tag.m_128471_("WaitingForTarget");
        this.consumedRopeLength = tag.m_128441_("ConsumedRopeLength") ? tag.m_128459_("ConsumedRopeLength") : 0.0;
        this.baseRopeLength = tag.m_128441_("BaseRopeLength") ? tag.m_128459_("BaseRopeLength") : 2.0;
        this.ropeStateInitialized = tag.m_128471_("RopeStateInitialized");
        if (tag.m_128441_("ConstraintId")) {
            this.constraintId = tag.m_128451_("ConstraintId");
            System.out.println("Loaded constraint ID: " + this.constraintId);
        } else {
            this.constraintId = null;
        }
        this.currentRopeLength = tag.m_128441_("CurrentRopeLength") ? Math.max(tag.m_128459_("CurrentRopeLength"), this.minRopeLength) : this.minRopeLength;
        double d = this.minRopeLength = tag.m_128441_("MinRopeLength") ? Math.max(tag.m_128459_("MinRopeLength"), 0.1) : 0.1;
        if (tag.m_128441_("ShipA")) {
            this.shipA = tag.m_128454_("ShipA");
            this.shipB = tag.m_128454_("ShipB");
            this.localPosA = new Vector3d(tag.m_128459_("LocalPosAX"), tag.m_128459_("LocalPosAY"), tag.m_128459_("LocalPosAZ"));
            this.localPosB = new Vector3d(tag.m_128459_("LocalPosBX"), tag.m_128459_("LocalPosBY"), tag.m_128459_("LocalPosBZ"));
        }
        System.out.println("Loaded rope state - Length: " + this.currentRopeLength + ", Consumed: " + this.consumedRopeLength + ", Constraint: " + this.constraintId + ", Mode: " + String.valueOf(this.MODE != null ? Integer.valueOf(this.MODE.getValue()) : "null") + ", HasTarget: " + this.hasTarget);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("IsLowering", this.isLowering);
        tag.m_128379_("IsRopeRendering", this.isRopeRendering);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.isLowering = tag.m_128471_("IsLowering");
        this.isRopeRendering = tag.m_128471_("IsRopeRendering");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.ropeInventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.ropeInventoryOptional.invalidate();
    }

    public float calculateStressApplied() {
        return 32.0f;
    }

    public static enum PulleyMode {
        MANUAL("pulley_mode.manual"),
        AUTO("pulley_mode.auto");

        private final String translationKey;

        private PulleyMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public Component getDisplayName() {
            return Component.m_237115_((String)this.translationKey);
        }
    }

    public class PhysifyResult {
        public final Ship ship;
        public final BlockPos pulleyAnchorWorldPos;

        public PhysifyResult(Ship ship, BlockPos pulleyAnchorWorldPos) {
            this.ship = ship;
            this.pulleyAnchorWorldPos = pulleyAnchorWorldPos;
        }
    }

    public static class SelectedRegion {
        public boolean hasBlocks;
        public Set<BlockPos> blockPositions;
        public Vector3d geometricCenter;

        public static SelectedRegion empty() {
            SelectedRegion r = new SelectedRegion();
            r.hasBlocks = false;
            r.blockPositions = Set.of();
            r.geometricCenter = new Vector3d();
            return r;
        }
    }

    public static class AnchorTarget {
        public final BlockPos pos;
        public final Vector3d attachPoint;

        public AnchorTarget(BlockPos pos, Vector3d attachPoint) {
            this.pos = pos;
            this.attachPoint = attachPoint;
        }
    }
}

