/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.ropestyler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Components;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import yay.evy.everest.vstuff.VStuff;
import yay.evy.everest.vstuff.content.ropestyler.components.RopeStyleButton;
import yay.evy.everest.vstuff.content.ropestyler.components.RopeStyleCategory;
import yay.evy.everest.vstuff.content.ropestyler.handler.RopeStyleHandlerServer;
import yay.evy.everest.vstuff.index.VStuffGuiTextures;
import yay.evy.everest.vstuff.index.VStuffRopeStyles;
import yay.evy.everest.vstuff.util.RopeStyles;
import yay.evy.everest.vstuff.util.client.ClientTextUtils;

public class RopeStylerScreen
extends AbstractSimiScreen {
    Player player;
    private final VStuffGuiTextures background = VStuffGuiTextures.ROPE_STYLER;
    private final List<Component> categoryComponentList = VStuffRopeStyles.CATEGORIES.stream().map(RopeStyleCategory::getName).toList();
    private RopeStyleCategory selectedCategory = VStuffRopeStyles.CATEGORIES.get(0);
    private int categoryIndex = 0;
    RopeStyles.RopeStyle[] displayedStyles = new RopeStyles.RopeStyle[6];
    RopeStyleButton[] styleButtons = new RopeStyleButton[6];
    RopeStyles.RopeStyle selectedStyle;
    private float scrollOffs;
    private boolean scrolling;
    private int ticksOpen;
    private boolean soundPlayed;

    public RopeStylerScreen(Player player) {
        this.player = player;
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        super.m_7856_();
        this.m_169413_();
        int x = this.guiLeft;
        int y = this.guiTop;
        for (int i = 0; i < 6; ++i) {
            this.styleButtons[i] = new RopeStyleButton(x + 19, y + 41 + i * 18, 145, 17, this.bogeySelection(i));
            this.m_142416_((GuiEventListener)this.styleButtons[i]);
        }
        this.setupList(this.selectedCategory);
        this.selectedStyle = this.selectedCategory.getCategoryStyles().get(0);
        this.scrollOffs = 0.0f;
        this.scrollTo(0.0f);
        Label categoryLabel = new Label(x + 14, y + 25, Components.immutableEmpty()).withShadow();
        ScrollInput categoryScrollInput = new SelectionScrollInput(x + 9, y + 20, 150, 18).forOptions(this.categoryComponentList).writingTo(categoryLabel).setState(this.categoryIndex).calling(categoryIndex -> {
            this.scrollOffs = 0.0f;
            this.scrollTo(0.0f);
            this.categoryIndex = categoryIndex;
            this.selectedCategory = VStuffRopeStyles.CATEGORIES.get((int)categoryIndex);
            this.setupList(this.selectedCategory);
            this.selectedStyle = !this.selectedCategory.getCategoryStyles().isEmpty() ? this.selectedCategory.getCategoryStyles().get(0) : null;
        });
        this.m_142416_((GuiEventListener)categoryLabel);
        this.m_142416_((GuiEventListener)categoryScrollInput);
        IconButton closeButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        closeButton.withCallback(this::onMenuClose);
        this.m_142416_((GuiEventListener)closeButton);
    }

    protected void renderWindow(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack ms = guiGraphics.m_280168_();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(guiGraphics, x, y);
        MutableComponent header = Component.m_237115_((String)"vstuff.gui.rope_menu.title");
        int halfWidth = this.background.width / 2;
        int halfHeaderWidth = this.f_96547_.m_92852_((FormattedText)header) / 2;
        guiGraphics.m_280614_(this.f_96547_, (Component)header, x + halfWidth - halfHeaderWidth, y + 4, 5776420, false);
        int scrollBarPos = (int)(41.0f + 93.0f * this.scrollOffs);
        VStuffGuiTextures barTexture = this.canScroll() ? VStuffGuiTextures.ROPE_SCROLL : VStuffGuiTextures.ROPE_SCROLL_DISABLED;
        barTexture.render(guiGraphics, x + 11, y + scrollBarPos);
        for (int i = 0; i < 6; ++i) {
            RopeStyles.RopeStyle style = this.displayedStyles[i];
            if (style == null) continue;
            ResourceLocation icon = style.getTexture();
            if (icon != null) {
                this.renderIcon(guiGraphics, ms, icon, x + 20, y + 42 + i * 18);
            }
            Component bogeyName = ClientTextUtils.getComponentWithWidthCutoff((Component)Component.m_237115_((String)style.getLangKey()), 114);
            guiGraphics.m_280430_(this.f_96547_, bogeyName, x + 40, y + 46 + i * 18, 0xFFFFFF);
        }
        if (this.selectedStyle != null) {
            MutableComponent displayName = Component.m_237115_((String)this.selectedStyle.getLangKey());
            Component shortenedName = ClientTextUtils.getComponentWithWidthCutoff((Component)displayName, 126);
            guiGraphics.m_280430_(this.f_96547_, shortenedName, x + 15, y + 165, 0xFFFFFF);
            ms.m_85849_();
        }
    }

    private void renderIcon(GuiGraphics guiGraphics, PoseStack ms, ResourceLocation icon, int x, int y) {
        ms.m_85836_();
        guiGraphics.m_280398_(icon, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        ms.m_85849_();
    }

    private void setupList(RopeStyleCategory categoryEntry) {
        this.setupList(categoryEntry, 0);
    }

    private void setupList(RopeStyleCategory categoryEntry, int offset) {
        List<RopeStyles.RopeStyle> styles = categoryEntry.getCategoryStyles();
        for (int i = 0; i < 6; ++i) {
            if (i < styles.size()) {
                this.displayedStyles[i] = styles.get(i + offset);
                this.styleButtons[i].f_93623_ = true;
                continue;
            }
            this.displayedStyles[i] = null;
            this.styleButtons[i].f_93623_ = false;
        }
    }

    public void m_86600_() {
        ++this.ticksOpen;
        this.soundPlayed = false;
        super.m_86600_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.selectedStyle == null) {
                this.m_7379_();
            } else {
                this.onMenuClose();
            }
            return true;
        }
        if (keyCode == 257) {
            this.onMenuClose();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.insideScrollbar(mouseX, mouseY)) {
            this.scrolling = this.canScroll();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.scrolling) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        int scrollbarLeft = this.guiTop + 41;
        int scrollbarRight = scrollbarLeft + 108;
        float scrollFactor = (float)((mouseY - (double)scrollbarLeft - 7.5) / (double)((float)(scrollbarRight - scrollbarLeft) - 15.0f));
        this.scrollOffs = Mth.m_14036_((float)scrollFactor, (float)0.0f, (float)1.0f);
        this.scrollTo(this.scrollOffs);
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        super.m_6050_(mouseX, mouseY, delta);
        if (!this.canScroll()) {
            return false;
        }
        if (this.insideCategorySelector(mouseX, mouseY)) {
            return false;
        }
        if (this.selectedCategory.getCategoryStyles().size() < 6) {
            return false;
        }
        double listSize = this.selectedCategory.getCategoryStyles().size() - 6;
        float scrollFactor = (float)(delta / listSize);
        float oldScrollOffs = this.scrollOffs;
        this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - scrollFactor), (float)0.0f, (float)1.0f);
        this.scrollTo(this.scrollOffs);
        if (!this.soundPlayed && this.scrollOffs != oldScrollOffs) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)AllSoundEvents.SCROLL_VALUE.getMainEvent(), (float)(1.5f + 0.1f * this.scrollOffs)));
        }
        this.soundPlayed = true;
        return true;
    }

    private void scrollTo(float pos) {
        List<RopeStyles.RopeStyle> styles = this.selectedCategory.getCategoryStyles();
        float listSize = styles.size() - 6;
        int index = (int)((double)(pos * listSize) + 0.5);
        this.setupList(this.selectedCategory, index);
    }

    private boolean canScroll() {
        return this.selectedCategory.getCategoryStyles().size() > 6;
    }

    private boolean insideCategorySelector(double mouseX, double mouseY) {
        int scrollbarLeftX = this.guiLeft + 11;
        int scrollbarTopY = this.guiTop + 20;
        int scrollbarRightX = scrollbarLeftX + 90;
        int scrollbarBottomY = scrollbarTopY + 34;
        return mouseX >= (double)scrollbarLeftX && mouseY >= (double)scrollbarTopY && mouseX < (double)scrollbarRightX && mouseY < (double)scrollbarBottomY;
    }

    private boolean insideScrollbar(double mouseX, double mouseY) {
        int scrollbarLeftX = this.guiLeft + 11;
        int scrollbarTopY = this.guiTop + 41;
        int scrollbarRightX = scrollbarLeftX + 8;
        int scrollbarBottomY = scrollbarTopY + 108;
        return mouseX >= (double)scrollbarLeftX && mouseY >= (double)scrollbarTopY && mouseX < (double)scrollbarRightX && mouseY < (double)scrollbarBottomY;
    }

    private Button.OnPress bogeySelection(int index) {
        return b -> {
            this.selectedStyle = this.displayedStyles[index];
        };
    }

    private void onMenuClose() {
        if (this.selectedStyle == null) {
            return;
        }
        RopeStyles.RopeStyle style = this.selectedStyle;
        VStuff.LOGGER.info("Attempting to set player [{}] selected rope style to {}", (Object)this.player.m_7755_(), (Object)this.selectedStyle.asString());
        RopeStyleHandlerServer.addStyle(this.player.m_20148_(), style);
        this.m_7379_();
    }
}

