/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.thrust;

import com.simibubi.create.content.kinetics.base.KineticBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import yay.evy.everest.vstuff.content.thrust.AbstractThrusterBlockEntity;
import yay.evy.everest.vstuff.content.thrust.ThrusterData;
import yay.evy.everest.vstuff.content.thrust.ThrusterForceApplier;
import yay.evy.everest.vstuff.content.thrust.ThrusterForceAttachment;
import yay.evy.everest.vstuff.index.VStuffShapes;

public abstract class AbstractThrusterBlock
extends KineticBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final IntegerProperty RPM = IntegerProperty.m_61631_((String)"rpm", (int)0, (int)256);

    protected AbstractThrusterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Direction baseDirection = context.m_7820_();
        Player player = context.m_43723_();
        Direction placeDirection = player != null ? (!player.m_6144_() ? baseDirection : baseDirection.m_122424_()) : baseDirection.m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeDirection)).m_61124_(AXIS, (Comparable)baseDirection.m_122434_());
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AXIS, RPM});
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return this.getAxisFromFacingDir(facing);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return face.m_122434_() == this.getAxisFromFacingDir(facing);
    }

    private Direction.Axis getAxisFromFacingDir(Direction facing) {
        switch (facing) {
            case EAST: 
            case WEST: {
                return Direction.Axis.Z;
            }
            case UP: 
            case DOWN: {
                return Direction.Axis.X;
            }
        }
        return Direction.Axis.X;
    }

    @Nullable
    public abstract BlockEntity m_142194_(@Nonnull BlockPos var1, @Nonnull BlockState var2);

    @Nullable
    public abstract <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level var1, @Nonnull BlockState var2, @Nonnull BlockEntityType<T> var3);

    public void m_6807_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AbstractThrusterBlockEntity)) {
            return;
        }
        AbstractThrusterBlockEntity thrusterBE = (AbstractThrusterBlockEntity)blockEntity;
        ThrusterForceAttachment attachment = ThrusterForceAttachment.get(level, pos);
        ThrusterData data = thrusterBE.getThrusterData();
        data.setDirection(VectorConversionsMCKt.toJOMLD((Vec3i)((Direction)state.m_61143_((Property)FACING)).m_122436_()));
        data.setThrust(0.0f);
        if (attachment != null) {
            ThrusterForceApplier applier = new ThrusterForceApplier(data);
            attachment.addApplier(pos, applier);
            System.out.println("[Thruster] onPlace: added applier at " + String.valueOf(pos));
        } else {
            level.m_7654_().execute(() -> {
                ThrusterForceAttachment deferredAttachment = ThrusterForceAttachment.get(level, pos);
                if (deferredAttachment != null) {
                    ThrusterForceApplier applier = new ThrusterForceApplier(data);
                    deferredAttachment.addApplier(pos, applier);
                    System.out.println("[Thruster] onPlace: deferred registration succeeded at " + String.valueOf(pos));
                } else {
                    System.out.println("[Thruster] onPlace: deferred registration still null at " + String.valueOf(pos));
                }
            });
        }
        thrusterBE.calculateObstruction(level, pos, (Direction)state.m_61143_((Property)FACING));
        thrusterBE.updateThrust(state);
        thrusterBE.m_6596_();
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (level.m_5776_()) {
            return;
        }
        ThrusterForceAttachment ship = ThrusterForceAttachment.get(level, pos);
        if (ship != null) {
            ship.removeApplier((ServerLevel)level, pos);
        }
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractThrusterBlockEntity) {
            AbstractThrusterBlockEntity thrusterBlockEntity = (AbstractThrusterBlockEntity)blockEntity;
            thrusterBlockEntity.calculateObstruction(level, pos, (Direction)state.m_61143_((Property)FACING));
            thrusterBlockEntity.updateThrust(state);
            thrusterBlockEntity.m_6596_();
            state.m_61124_((Property)RPM, (Comparable)Integer.valueOf((int)thrusterBlockEntity.getSpeed()));
        }
    }

    public BlockState m_6843_(@Nonnull BlockState state, @Nonnull Rotation rot) {
        return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_(AXIS, (Comparable)this.getAxisFromFacingDir(rot.m_55954_((Direction)state.m_61143_((Property)FACING))));
    }

    public BlockState m_6943_(@Nonnull BlockState state, @Nonnull Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return VStuffShapes.ROTATIONAL_THRUSTER.get((Direction)state.m_61143_((Property)FACING));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return this.m_5940_(state, p_220071_2_, p_220071_3_, p_220071_4_);
    }
}

