/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.content.thrust;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Math;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import yay.evy.everest.vstuff.VstuffConfig;
import yay.evy.everest.vstuff.content.thrust.AbstractThrusterBlock;
import yay.evy.everest.vstuff.content.thrust.ThrusterDamager;
import yay.evy.everest.vstuff.content.thrust.ThrusterData;
import yay.evy.everest.vstuff.content.thrust.ThrusterForceApplier;
import yay.evy.everest.vstuff.content.thrust.ThrusterForceAttachment;
import yay.evy.everest.vstuff.particles.ParticleTypes;
import yay.evy.everest.vstuff.particles.PlumeParticleData;

public abstract class AbstractThrusterBlockEntity
extends KineticBlockEntity {
    protected static final int OBSTRUCTION_LENGTH = 10;
    protected static final int TICKS_PER_ENTITY_CHECK = 5;
    private static final float PARTICLE_VELOCITY = 4.0f;
    private static final double NOZZLE_OFFSET_FROM_CENTER = 0.9;
    private static final double SHIP_VELOCITY_INHERITANCE = 0.5;
    protected ThrusterData thrusterData = new ThrusterData();
    protected int emptyBlocks;
    protected boolean isThrustDirty = false;
    private final ThrusterDamager damager;
    private int currentTick = 0;
    private int clientTick = 0;
    private float particleSpawnAccumulator = 0.0f;
    protected ParticleType<PlumeParticleData> particleType = ParticleTypes.getPlumeType();
    public AbstractComputerBehaviour computerBehaviour;
    public boolean overridePower = false;
    public int overridenPower;

    public AbstractThrusterBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.damager = new ThrusterDamager(this);
    }

    public float calculateStressApplied() {
        return 64.0f;
    }

    public void initialize() {
        super.initialize();
        if (!this.f_58857_.f_46443_) {
            this.calculateObstruction(this.f_58857_, this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)AbstractThrusterBlock.FACING));
        }
    }

    public void tick() {
        if (this.m_58901_()) {
            return;
        }
        if (this.f_58857_.m_8055_(this.f_58858_).m_60734_() != this.m_58900_().m_60734_()) {
            this.m_7651_();
            return;
        }
        super.tick();
        BlockState currentBlockState = this.m_58900_();
        if (this.f_58857_.f_46443_) {
            if (this.shouldEmitParticles()) {
                this.emitParticles(this.f_58857_, this.f_58858_, currentBlockState);
            }
            return;
        }
        ++this.currentTick;
        this.damager.tick(this.currentTick);
        int tick_rate = (Integer)VstuffConfig.THRUSTER_TICKS_PER_UPDATE.get();
        if (this.currentTick % (tick_rate * 2) == 0) {
            int previousEmptyBlocks = this.emptyBlocks;
            this.calculateObstruction(this.f_58857_, this.f_58858_, (Direction)currentBlockState.m_61143_((Property)AbstractThrusterBlock.FACING));
            if (previousEmptyBlocks != this.emptyBlocks) {
                this.isThrustDirty = true;
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, currentBlockState, currentBlockState, 2);
            }
        }
        if (this.isThrustDirty || this.currentTick % tick_rate == 0) {
            this.updateThrust(currentBlockState);
        }
    }

    public void updateThrust(BlockState currentBlockState) {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            this.thrusterData.setThrust(0.0f);
            this.isThrustDirty = false;
            return;
        }
        float obstructionEffect = this.calculateObstructionEffect();
        float powerPercentage = Math.min((float)(Math.abs((float)speed) / 256.0f), (float)1.0f);
        float thrustMultiplier = ((Double)VstuffConfig.THRUSTER_THRUST_MULTIPLIER.get()).floatValue();
        float softPower = (float)java.lang.Math.pow(powerPercentage, 1.2);
        float thrust = 400000.0f * thrustMultiplier * softPower * obstructionEffect;
        this.thrusterData.setThrust(thrust);
        this.isThrustDirty = false;
        System.out.println("[Thruster] speed=" + speed + ", obstruction=" + obstructionEffect + ", thrust=" + thrust);
    }

    protected boolean isWorking() {
        return this.getSpeed() != 0.0f;
    }

    protected LangBuilder getGoggleStatus() {
        return Lang.text((String)("Speed: " + this.getSpeed() + " rpm, Thrust: " + this.thrusterData.getThrust()));
    }

    @Nullable
    protected abstract Direction getFluidCapSide();

    public ThrusterData getThrusterData() {
        return this.thrusterData;
    }

    public int getEmptyBlocks() {
        return this.emptyBlocks;
    }

    public void dirtyThrust() {
        this.isThrustDirty = true;
    }

    protected boolean shouldEmitParticles() {
        return this.isWorking();
    }

    protected boolean shouldDamageEntities() {
        return (Boolean)VstuffConfig.THRUSTER_DAMAGE_ENTITIES.get() != false && this.isWorking();
    }

    protected void addSpecificGoggleInfo(List<Component> tooltip, boolean isPlayerSneaking) {
    }

    protected float calculateObstructionEffect() {
        return (float)this.emptyBlocks / 10.0f;
    }

    protected float getSpeedScalar() {
        return Math.abs((float)(this.getSpeed() / 256.0f));
    }

    public void emitParticles(Level level, BlockPos pos, BlockState state) {
        if (this.emptyBlocks == 0) {
            return;
        }
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        double particleCountMultiplier = Math.clamp((double)0.0, (double)2.0, (double)((Double)VstuffConfig.THRUSTER_PARTICLE_COUNT_MULTIPLIER.get() * (double)this.getSpeedScalar()));
        if (particleCountMultiplier <= 0.0) {
            return;
        }
        ++this.clientTick;
        if (this.clientTick % 2 == 0) {
            this.clientTick = 0;
            return;
        }
        this.particleSpawnAccumulator = (float)((double)this.particleSpawnAccumulator + particleCountMultiplier);
        int particlesToSpawn = (int)this.particleSpawnAccumulator;
        if (particlesToSpawn == 0) {
            return;
        }
        this.particleSpawnAccumulator -= (float)particlesToSpawn;
        Direction direction = (Direction)state.m_61143_((Property)AbstractThrusterBlock.FACING);
        Direction oppositeDirection = direction.m_122424_();
        double currentNozzleOffset = 0.9;
        Vector3d additionalVel = new Vector3d();
        ClientShip ship = VSGameUtilsKt.getShipObjectManagingPos((ClientLevel)clientLevel, (Vec3i)pos);
        if (ship != null) {
            Vector3dc shipWorldVelocityJOML = ship.getVelocity();
            Matrix4dc transform = ship.getRenderTransform().getShipToWorld();
            Matrix4dc invTransform = ship.getRenderTransform().getWorldToShip();
            Vector3d shipVelocity = invTransform.transformDirection(new Vector3d(shipWorldVelocityJOML));
            Vector3d particleEjectionUnitVecJOML = transform.transformDirection(VectorConversionsMCKt.toJOMLD((Vec3i)oppositeDirection.m_122436_()));
            double shipVelComponentAlongRotatedEjection = shipWorldVelocityJOML.dot((Vector3dc)particleEjectionUnitVecJOML);
            if (shipVelComponentAlongRotatedEjection > 0.0) {
                Vector3d normalizedVelocity = new Vector3d();
                shipWorldVelocityJOML.normalize(normalizedVelocity);
                double shipVelComponentAlongRotatedEjectionNormalized = normalizedVelocity.dot((Vector3dc)particleEjectionUnitVecJOML);
                double effect = Math.clamp((double)0.0, (double)1.0, (double)shipVelComponentAlongRotatedEjectionNormalized);
                double additionalOffset = shipVelComponentAlongRotatedEjection * (Double)VstuffConfig.THRUSTER_PARTICLE_OFFSET_INCOMING_VEL_MODIFIER.get();
                currentNozzleOffset += additionalOffset * effect;
                additionalVel = new Vector3d((Vector3dc)shipVelocity).mul(0.5 * effect);
            }
        }
        double particleX = (double)pos.m_123341_() + 0.5 + (double)oppositeDirection.m_122429_() * currentNozzleOffset;
        double particleY = (double)pos.m_123342_() + 0.5 + (double)oppositeDirection.m_122430_() * currentNozzleOffset;
        double particleZ = (double)pos.m_123343_() + 0.5 + (double)oppositeDirection.m_122431_() * currentNozzleOffset;
        Vector3d particleVelocity = new Vector3d((double)oppositeDirection.m_122429_(), (double)oppositeDirection.m_122430_(), (double)oppositeDirection.m_122431_()).mul((double)(4.0f * this.getSpeedScalar())).add((Vector3dc)additionalVel);
        for (int i = 0; i < particlesToSpawn; ++i) {
            clientLevel.m_6493_((ParticleOptions)new PlumeParticleData(this.particleType), true, particleX, particleY, particleZ, particleVelocity.x, particleVelocity.y, particleVelocity.z);
        }
    }

    public void calculateObstruction(Level level, BlockPos pos, Direction forwardDirection) {
        BlockPos checkPos;
        BlockState state;
        int oldEmptyBlocks = this.emptyBlocks;
        this.emptyBlocks = 0;
        while (this.emptyBlocks < 10 && ((state = level.m_8055_(checkPos = pos.m_5484_(forwardDirection.m_122424_(), this.emptyBlocks + 1))).m_60795_() || !state.m_280296_())) {
            ++this.emptyBlocks;
        }
        if (oldEmptyBlocks != this.emptyBlocks) {
            this.isThrustDirty = true;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        boolean wasThrustDirty = this.isThrustDirty;
        this.calculateObstruction(this.m_58904_(), this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)AbstractThrusterBlock.FACING));
        this.isThrustDirty = wasThrustDirty;
        Lang.translate((String)"gui.goggles.thruster.status", (Object[])new Object[0]).text(":").space().add(this.getGoggleStatus()).forGoggles(tooltip);
        float efficiency = 100.0f;
        ChatFormatting tooltipColor = ChatFormatting.GREEN;
        if (this.emptyBlocks < 10) {
            efficiency = this.calculateObstructionEffect() * 100.0f;
        }
        Lang.builder().add(Lang.translate((String)"gui.goggles.thruster.efficiency", (Object[])new Object[0])).space().add(Lang.number((double)efficiency)).add(Lang.text((String)"%")).style(tooltipColor).forGoggles(tooltip);
        this.addSpecificGoggleInfo(tooltip, isPlayerSneaking);
        return true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("emptyBlocks", this.emptyBlocks);
        compound.m_128405_("currentTick", this.currentTick);
        compound.m_128350_("thrust", this.thrusterData.getThrust());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.emptyBlocks = compound.m_128451_("emptyBlocks");
        this.currentTick = compound.m_128451_("currentTick");
        this.thrusterData.setThrust(compound.m_128457_("thrust"));
        this.isThrustDirty = true;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.f_58857_.m_7654_().execute(() -> {
                this.recalcThruster();
                ThrusterForceAttachment attachment = ThrusterForceAttachment.get(this.f_58857_, this.f_58858_);
                if (attachment != null) {
                    ThrusterData data = this.getThrusterData();
                    data.setDirection(VectorConversionsMCKt.toJOMLD((Vec3i)((Direction)this.m_58900_().m_61143_((Property)AbstractThrusterBlock.FACING)).m_122436_()));
                    ThrusterForceApplier applier = new ThrusterForceApplier(data);
                    attachment.addApplier(this.f_58858_, applier);
                    System.out.println("[Thruster] onLoad: re-registered applier at " + String.valueOf(this.f_58858_));
                }
            });
        }
    }

    private void recalcThruster() {
        this.calculateObstruction(this.f_58857_, this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)AbstractThrusterBlock.FACING));
        this.isThrustDirty = true;
        this.updateThrust(this.m_58900_());
        this.m_6596_();
    }
}

