/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.events;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;
import yay.evy.everest.vstuff.index.VStuffItems;

@Mod.EventBusSubscriber(modid="vstuff")
public class RopeBreakHandler {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos brokenPos = event.getPos();
        ArrayList<Integer> constraintsToRemove = new ArrayList<Integer>();
        for (Map.Entry<Integer, ConstraintTracker.RopeConstraintData> entry : ConstraintTracker.getActiveConstraints().entrySet()) {
            Integer id = entry.getKey();
            ConstraintTracker.RopeConstraintData data = entry.getValue();
            if (data.constraintType == ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY) continue;
            try {
                BlockPos worldPosB;
                BlockPos worldPosA;
                BlockPos posB;
                BlockPos posA;
                BlockPos dropPos = null;
                boolean remove = false;
                if (!data.isShipA && brokenPos.equals((Object)(posA = BlockPos.m_274561_((double)data.localPosA.x, (double)data.localPosA.y, (double)data.localPosA.z)))) {
                    remove = true;
                    dropPos = posA;
                }
                if (!remove && !data.isShipB && brokenPos.equals((Object)(posB = BlockPos.m_274561_((double)data.localPosB.x, (double)data.localPosB.y, (double)data.localPosB.z)))) {
                    remove = true;
                    dropPos = posB;
                }
                if (!remove && data.isShipA && brokenPos.equals((Object)(worldPosA = BlockPos.m_274561_((double)data.getWorldPosA((ServerLevel)level, (float)0.0f).x, (double)data.getWorldPosA((ServerLevel)level, (float)0.0f).y, (double)data.getWorldPosA((ServerLevel)level, (float)0.0f).z)))) {
                    remove = true;
                    dropPos = worldPosA;
                }
                if (!remove && data.isShipB && brokenPos.equals((Object)(worldPosB = BlockPos.m_274561_((double)data.getWorldPosB((ServerLevel)level, (float)0.0f).x, (double)data.getWorldPosB((ServerLevel)level, (float)0.0f).y, (double)data.getWorldPosB((ServerLevel)level, (float)0.0f).z)))) {
                    remove = true;
                    dropPos = worldPosB;
                }
                if (!remove || dropPos == null) continue;
                constraintsToRemove.add(id);
                ItemStack ropeDrop = new ItemStack((ItemLike)VStuffItems.LEAD_CONSTRAINT_ITEM.get());
                ItemEntity itemEntity = new ItemEntity((Level)level, (double)dropPos.m_123341_() + 0.5, (double)dropPos.m_123342_() + 0.5, (double)dropPos.m_123343_() + 0.5, ropeDrop);
                level.m_7967_((Entity)itemEntity);
            }
            catch (Exception e) {
                System.err.println("[RopeBreakHandler] Failed checking constraint " + id + ": " + e.getMessage());
            }
        }
        for (Integer constraintId : constraintsToRemove) {
            try {
                ConstraintTracker.removeConstraintWithPersistence(level, constraintId);
            }
            catch (Exception e) {
                System.err.println("[RopeBreakHandler] Failed to remove constraint " + constraintId + ": " + e.getMessage());
            }
        }
    }
}

