/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.events;

import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yay.evy.everest.vstuff.content.constraint.ConstraintPersistence;
import yay.evy.everest.vstuff.content.constraint.ConstraintTracker;

@Mod.EventBusSubscriber(modid="vstuff", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerTickHandler {
    private static int tickCounter = 0;
    private static final int TICKS_PER_SECOND = 5;

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        for (ServerLevel level : event.getServer().m_129785_()) {
            System.out.println("VStuff: Restoring constraints for dimension: " + String.valueOf(level.m_46472_().m_135782_()));
            ConstraintPersistence.get(level).restoreConstraintsInstance(level);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter < 5) {
            return;
        }
        tickCounter = 0;
        for (ServerLevel level : event.getServer().m_129785_()) {
            if (level.m_6907_().isEmpty()) continue;
            ConstraintTracker.getActiveConstraints().forEach((id, rope) -> {
                if (rope.constraintType == ConstraintTracker.RopeConstraintData.ConstraintType.ROPE_PULLEY && rope.sourceBlockPos != null && level.m_8055_(rope.sourceBlockPos).m_60795_()) {
                    System.out.println("Removing orphaned rope " + id + " at " + String.valueOf(rope.sourceBlockPos));
                    ConstraintTracker.removeConstraintWithPersistence(level, id);
                }
            });
            ConstraintTracker.validateAndCleanupConstraints(level);
        }
    }
}

