/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.util;

import net.minecraft.resources.ResourceLocation;

public class RopeStyles {
    public static ResourceLocation getRopeStyle(String style) {
        return new ResourceLocation("vstuff", "textures/entity/rope/rope_" + style + ".png");
    }

    public static ResourceLocation getDyedRopeStyle(String color) {
        return new ResourceLocation("vstuff", "textures/entity/rope/rope_dyed_" + color + ".png");
    }

    public static ResourceLocation getDyedWoolStyle(String color) {
        return new ResourceLocation("minecraft", "textures/block/" + color + "_wool.png");
    }

    public static ResourceLocation getChainStyle() {
        return new ResourceLocation("vstuff", "textures/entity/rope/rope_chain.png");
    }

    public static ResourceLocation getLogStyle(String log) {
        return new ResourceLocation("minecraft", "textures/block/" + log + "_log.png");
    }

    public static class RopeStyle {
        private final ResourceLocation associatedTexture;
        private final RenderStyle renderStyle;
        private final String langKey;
        private final String style;
        private final PrimitiveRopeStyle basicStyle;

        public RopeStyle(String style, PrimitiveRopeStyle basicStyle, String langKey) {
            this.langKey = langKey;
            this.style = style;
            this.basicStyle = basicStyle;
            this.renderStyle = basicStyle == PrimitiveRopeStyle.CHAIN ? RenderStyle.CHAIN : RenderStyle.NORMAL;
            switch (basicStyle) {
                case WOOL: {
                    this.associatedTexture = RopeStyles.getDyedWoolStyle(style);
                    break;
                }
                case CHAIN: {
                    this.associatedTexture = RopeStyles.getChainStyle();
                    break;
                }
                case LOG: {
                    this.associatedTexture = RopeStyles.getLogStyle(style);
                    break;
                }
                default: {
                    this.associatedTexture = RopeStyles.getRopeStyle(style);
                }
            }
        }

        public RopeStyle(String style, String basicStyleSTR, String langKey) {
            PrimitiveRopeStyle basicStyle = switch (basicStyleSTR) {
                case "wool" -> PrimitiveRopeStyle.WOOL;
                case "chain" -> PrimitiveRopeStyle.CHAIN;
                case "log" -> PrimitiveRopeStyle.LOG;
                default -> PrimitiveRopeStyle.NORMAL;
            };
            this.langKey = langKey;
            this.style = style;
            this.basicStyle = basicStyle;
            this.renderStyle = basicStyle == PrimitiveRopeStyle.CHAIN ? RenderStyle.CHAIN : RenderStyle.NORMAL;
            switch (basicStyle) {
                case WOOL: {
                    this.associatedTexture = RopeStyles.getDyedWoolStyle(style);
                    break;
                }
                case CHAIN: {
                    this.associatedTexture = RopeStyles.getChainStyle();
                    break;
                }
                case LOG: {
                    this.associatedTexture = RopeStyles.getLogStyle(style);
                    break;
                }
                default: {
                    this.associatedTexture = RopeStyles.getRopeStyle(style);
                }
            }
        }

        public String asString() {
            return "RopeStyle with style " + this.style + ", basicStyle " + this.basicStyle.toString() + ", renderStyle " + this.renderStyle.toString() + ", texture at " + this.associatedTexture.m_135815_() + ", langKey " + this.langKey;
        }

        public ResourceLocation getTexture() {
            return this.associatedTexture;
        }

        public RenderStyle getRenderStyle() {
            return this.renderStyle;
        }

        public String getLangKey() {
            return this.langKey;
        }

        public String getStyle() {
            return this.style;
        }

        public PrimitiveRopeStyle getBasicStyle() {
            return this.basicStyle;
        }

        public boolean isDyeable() {
            return this.basicStyle == PrimitiveRopeStyle.WOOL || this.basicStyle == PrimitiveRopeStyle.NORMAL;
        }
    }

    public static enum PrimitiveRopeStyle {
        NORMAL,
        WOOL,
        CHAIN,
        OTHER,
        LOG;

    }

    public static enum RenderStyle {
        NORMAL,
        CHAIN;

    }
}

