/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.util.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import yay.evy.everest.vstuff.client.ClientConstraintTracker;
import yay.evy.everest.vstuff.util.RopeStyles;

public class ConstraintSyncPacket {
    private final Action action;
    private final Integer constraintId;
    private final Long shipA;
    private final Long shipB;
    private final Vector3d localPosA;
    private final Vector3d localPosB;
    private final double maxLength;
    private final RopeStyles.RopeStyle ropeStyle;
    private final String style;
    private final RopeStyles.PrimitiveRopeStyle basicStyle;
    private final String styleLKey;

    public ConstraintSyncPacket(Integer constraintId, Long shipA, Long shipB, Vector3d localPosA, Vector3d localPosB, double maxLength, RopeStyles.RopeStyle ropeStyle) {
        this.action = Action.ADD;
        this.constraintId = constraintId;
        this.shipA = shipA;
        this.shipB = shipB;
        this.localPosA = localPosA != null ? new Vector3d((Vector3dc)localPosA) : new Vector3d();
        this.localPosB = localPosB != null ? new Vector3d((Vector3dc)localPosB) : new Vector3d();
        this.maxLength = maxLength;
        this.ropeStyle = ropeStyle;
        this.style = ropeStyle.getStyle();
        this.basicStyle = ropeStyle.getBasicStyle();
        this.styleLKey = ropeStyle.getLangKey();
    }

    public ConstraintSyncPacket() {
        this.action = Action.CLEAR_ALL;
        this.constraintId = null;
        this.shipA = null;
        this.shipB = null;
        this.localPosA = null;
        this.localPosB = null;
        this.maxLength = 0.0;
        this.ropeStyle = new RopeStyles.RopeStyle("none", RopeStyles.PrimitiveRopeStyle.NORMAL, "none");
        this.style = this.ropeStyle.getStyle();
        this.basicStyle = this.ropeStyle.getBasicStyle();
        this.styleLKey = this.ropeStyle.getLangKey();
    }

    public ConstraintSyncPacket(Integer constraintId) {
        this.action = Action.REMOVE;
        this.constraintId = constraintId;
        this.shipA = null;
        this.shipB = null;
        this.localPosA = null;
        this.localPosB = null;
        this.maxLength = 0.0;
        this.ropeStyle = new RopeStyles.RopeStyle("none", RopeStyles.PrimitiveRopeStyle.NORMAL, "none");
        this.style = this.ropeStyle.getStyle();
        this.basicStyle = this.ropeStyle.getBasicStyle();
        this.styleLKey = this.ropeStyle.getLangKey();
    }

    public ConstraintSyncPacket(FriendlyByteBuf buf) {
        this.action = (Action)buf.m_130066_(Action.class);
        switch (this.action) {
            case ADD: {
                this.constraintId = buf.readInt();
                boolean hasShipA = buf.readBoolean();
                this.shipA = hasShipA ? Long.valueOf(buf.readLong()) : null;
                boolean hasShipB = buf.readBoolean();
                this.shipB = hasShipB ? Long.valueOf(buf.readLong()) : null;
                this.localPosA = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
                this.localPosB = new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
                this.maxLength = buf.readDouble();
                this.style = buf.m_130277_();
                this.basicStyle = (RopeStyles.PrimitiveRopeStyle)buf.m_130066_(RopeStyles.PrimitiveRopeStyle.class);
                this.styleLKey = buf.m_130277_();
                this.ropeStyle = new RopeStyles.RopeStyle(this.style, this.basicStyle, this.styleLKey);
                break;
            }
            case REMOVE: {
                this.constraintId = buf.readInt();
                this.shipA = null;
                this.shipB = null;
                this.localPosA = null;
                this.localPosB = null;
                this.maxLength = 0.0;
                this.style = "none";
                this.basicStyle = RopeStyles.PrimitiveRopeStyle.NORMAL;
                this.styleLKey = "none";
                this.ropeStyle = new RopeStyles.RopeStyle(this.style, this.basicStyle, this.styleLKey);
                break;
            }
            default: {
                this.constraintId = null;
                this.shipA = null;
                this.shipB = null;
                this.localPosA = null;
                this.localPosB = null;
                this.maxLength = 0.0;
                this.style = "none";
                this.basicStyle = RopeStyles.PrimitiveRopeStyle.NORMAL;
                this.styleLKey = "none";
                this.ropeStyle = new RopeStyles.RopeStyle(this.style, this.basicStyle, this.styleLKey);
            }
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.action);
        switch (this.action) {
            case ADD: {
                if (this.constraintId == null) {
                    throw new IllegalStateException("Cannot encode ADD packet with null constraintId");
                }
                buf.writeInt(this.constraintId.intValue());
                buf.writeBoolean(this.shipA != null);
                if (this.shipA != null) {
                    buf.writeLong(this.shipA.longValue());
                }
                buf.writeBoolean(this.shipB != null);
                if (this.shipB != null) {
                    buf.writeLong(this.shipB.longValue());
                }
                if (this.localPosA == null || this.localPosB == null) {
                    throw new IllegalStateException("Cannot encode ADD packet with null positions");
                }
                buf.writeDouble(this.localPosA.x);
                buf.writeDouble(this.localPosA.y);
                buf.writeDouble(this.localPosA.z);
                buf.writeDouble(this.localPosB.x);
                buf.writeDouble(this.localPosB.y);
                buf.writeDouble(this.localPosB.z);
                buf.writeDouble(this.maxLength);
                buf.m_130070_(this.style);
                buf.m_130068_((Enum)this.basicStyle);
                buf.m_130070_(this.styleLKey);
                break;
            }
            case REMOVE: {
                if (this.constraintId == null) {
                    throw new IllegalStateException("Cannot encode REMOVE packet with null constraintId");
                }
                buf.writeInt(this.constraintId.intValue());
                break;
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            try {
                switch (this.action) {
                    case ADD: {
                        ClientConstraintTracker.addClientConstraint(this.constraintId, this.shipA, this.shipB, this.localPosA, this.localPosB, this.maxLength, this.ropeStyle);
                        break;
                    }
                    case REMOVE: {
                        ClientConstraintTracker.removeClientConstraint(this.constraintId);
                        break;
                    }
                    case CLEAR_ALL: {
                        ClientConstraintTracker.clearAllClientConstraints();
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error handling constraint sync packet: " + e.getMessage());
                e.printStackTrace();
            }
        });
        context.setPacketHandled(true);
    }

    public static enum Action {
        ADD,
        REMOVE,
        CLEAR_ALL;

    }
}

