/*
 * Decompiled with CFR 0.152.
 */
package yay.evy.everest.vstuff.util.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.network.NetworkEvent;
import yay.evy.everest.vstuff.sound.RopeSoundHandler;
import yay.evy.everest.vstuff.util.RopeStyles;

public class RopeSoundPacket {
    private final boolean breakSound;
    private final RopeStyles.PrimitiveRopeStyle style;

    public RopeSoundPacket(boolean breakSound, RopeStyles.PrimitiveRopeStyle style) {
        this.breakSound = breakSound;
        this.style = style;
    }

    public static void encode(RopeSoundPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.breakSound);
        buf.m_130068_((Enum)msg.style);
    }

    public static RopeSoundPacket decode(FriendlyByteBuf buf) {
        return new RopeSoundPacket(buf.readBoolean(), (RopeStyles.PrimitiveRopeStyle)buf.m_130066_(RopeStyles.PrimitiveRopeStyle.class));
    }

    public static void handle(RopeSoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (RopeSoundHandler.isEnabled()) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null && mc.f_91073_ != null) {
                    SoundEvent sound = msg.breakSound ? (msg.style == RopeStyles.PrimitiveRopeStyle.CHAIN ? SoundEvents.f_11794_ : SoundEvents.f_12033_) : (msg.style == RopeStyles.PrimitiveRopeStyle.CHAIN ? SoundEvents.f_11745_ : SoundEvents.f_12087_);
                    mc.f_91073_.m_7785_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

