/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags;

import java.util.ArrayList;
import java.util.logging.Level;
import me.itsskeptical.displaytags.commands.DisplayTagsCommand;
import me.itsskeptical.displaytags.config.DisplayTagsConfig;
import me.itsskeptical.displaytags.listeners.PlayerListener;
import me.itsskeptical.displaytags.nametags.NametagManager;
import me.itsskeptical.displaytags.nametags.NametagScheduler;
import me.itsskeptical.displaytags.utils.UpdateChecker;
import me.itsskeptical.displaytags.utils.handlers.NametagHandler;
import me.itsskeptical.displaytags.utils.helpers.DependencyHelper;
import me.itsskeptical.displaytags.utils.helpers.MessageHelper;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class DisplayTags
extends JavaPlugin {
    private static DisplayTags instance;
    private static UpdateChecker updateChecker;
    private static DisplayTagsConfig config;
    private NametagManager nametagManager;
    private NametagScheduler nametagScheduler;

    public void onEnable() {
        instance = this;
        updateChecker = new UpdateChecker(this, "voqEPXf8");
        PluginManager pluginManager = this.getServer().getPluginManager();
        this.saveDefaultConfig();
        config = new DisplayTagsConfig(this);
        config.load();
        this.nametagManager = new NametagManager();
        this.nametagScheduler = new NametagScheduler(this);
        this.nametagScheduler.start();
        pluginManager.registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.registerCommands();
        DependencyHelper.load();
        NametagHandler.load();
        this.checkForUpdates((CommandSender)this.getServer().getConsoleSender());
        String version = this.getPluginMeta().getVersion();
        this.getLogger().info(String.format("DisplaysTags v%s has been enabled.", version));
    }

    public void onDisable() {
        this.nametagScheduler.stop();
        this.getLogger().info("DisplayTags has been disabled.");
    }

    private void registerCommands() {
        this.getServer().getCommandMap().register("displaytags", (Command)new DisplayTagsCommand(this));
    }

    public void checkForUpdates(CommandSender sender) {
        String version = this.getPluginMeta().getVersion();
        updateChecker.getLatestVersion(latest -> {
            if (latest == null) {
                return;
            }
            if (latest.equals(version)) {
                MessageHelper.success(sender, "This server is using the latest version of DisplayTags (v{latest}).".replace("{latest}", (CharSequence)latest));
            } else {
                ArrayList<String> text = new ArrayList<String>();
                text.add("This server is running an outdated version of DisplayTags (v{current})".replace("{current}", version));
                text.add("<u><click:open_url:'{url}'><hover:show_text:'<#00BFFF>\u27a1 <reset><u>{url}'>Click to download the latest version (v{latest})".replace("{latest}", (CharSequence)latest).replace("{url}", "https://modrinth.com/plugin/displaytags/version/" + latest));
                text.forEach(line -> MessageHelper.warning(sender, line));
            }
        });
    }

    public boolean reloadPlugin() {
        try {
            this.getLogger().info("Reloading...");
            config.reload();
            this.nametagScheduler.stop();
            this.nametagManager.removeAll();
            if (this.config().getNametagConfig().isEnabled()) {
                this.nametagManager.createAll();
                this.nametagScheduler.start();
            }
            this.getLogger().info("Reloaded!");
            return true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to reload plugin: " + e.getMessage(), e);
            return false;
        }
    }

    public static DisplayTags getInstance() {
        return instance;
    }

    public DisplayTagsConfig config() {
        return config;
    }

    public NametagManager getNametagManager() {
        return this.nametagManager;
    }
}

