/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.commands.displaytags;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.itsskeptical.displaytags.DisplayTags;
import me.itsskeptical.displaytags.commands.framework.CommandGroup;
import me.itsskeptical.displaytags.commands.framework.Subcommand;
import me.itsskeptical.displaytags.config.NametagConfig;
import me.itsskeptical.displaytags.entities.DisplayBillboard;
import me.itsskeptical.displaytags.entities.TextAlignment;
import me.itsskeptical.displaytags.utils.helpers.MessageHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.util.Vector;

public class ConfigCommand
extends Subcommand {
    public ConfigCommand(DisplayTags plugin, CommandGroup parentCommand) {
        super(plugin, parentCommand);
        super.setName("config");
        super.setDescription("View the plugin configuration.");
        super.setPermission("displaytags.admin");
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        NametagConfig config = this.plugin.config().getNametagConfig();
        boolean enabled = config.isEnabled();
        boolean hideSelf = config.shouldHideSelf();
        int updateInterval = config.getUpdateInterval();
        int visibilityDistance = config.getVisibilityDistance();
        List<String> lines = config.getLines();
        boolean textShadow = config.hasTextShadow();
        boolean seeThrough = config.isSeeThrough();
        TextAlignment textAlignment = config.getTextAlignment();
        String background = config.getBackground();
        DisplayBillboard billboard = config.getBillboard();
        Vector scale = config.getScale();
        ArrayList<CallSite> scaleText = new ArrayList<CallSite>();
        scaleText.add((CallSite)((Object)("<white>X <dark_gray>\u2192 <gray>" + scale.getX())));
        scaleText.add((CallSite)((Object)("<white>Y <dark_gray>\u2192 <gray>" + scale.getY())));
        scaleText.add((CallSite)((Object)("<white>Z <dark_gray>\u2192 <gray>" + scale.getZ())));
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("<dark_gray>\u2022 <white>Nametags");
        messages.add("  <white>Enabled <dark_gray>\u2192 " + this.booleanToString(enabled));
        messages.add("  <white>Show Self <dark_gray>\u2192 " + this.booleanToString(!hideSelf));
        messages.add("  <white>Update Interval <dark_gray>\u2192 <gray>" + updateInterval + " ticks");
        messages.add("  <white>Visibility Distance <dark_gray>\u2192 <gray>" + visibilityDistance + " blocks");
        messages.add("<dark_gray>\u2022 <white>Display");
        messages.add("  <white>Lines <dark_gray>\u2192 <hover:show_text:'{lines}'><gray><u>Hover".replace("{lines}", String.join((CharSequence)"\n", lines)));
        messages.add("  <white>Text Shadow <dark_gray>\u2192 " + this.booleanToString(textShadow));
        messages.add("  <white>See Through <dark_gray>\u2192 " + this.booleanToString(seeThrough));
        messages.add("  <white>Text Alignment <dark_gray>\u2192 <gray>" + textAlignment.name());
        messages.add("  <white>Background <dark_gray>\u2192 " + this.color(background) + this.background(background));
        messages.add("  <white>Billboard <dark_gray>\u2192 <gray>" + billboard.name());
        messages.add("  <white>Scale <dark_gray>\u2192 <hover:show_text:'{scale}'><gray><u>Hover".replace("{scale}", String.join((CharSequence)"\n", scaleText)));
        sender.sendMessage("");
        MessageHelper.send(sender, "<dark_gray>[<#00BFFF>&l\u1d18\u029f\u1d1c\u0262\u026a\u0274 \u1d04\u1d0f\u0274\ua730\u026a\u0262\u1d1c\u0280\u1d00\u1d1b\u026a\u1d0f\u0274<dark_gray>]");
        MessageHelper.send(sender, messages);
        sender.sendMessage("");
    }

    private String booleanToString(boolean b) {
        if (b) {
            return "<green>Yes";
        }
        return "<red>No";
    }

    private String background(String background) {
        if (Objects.equals(background, "default")) {
            return "Default";
        }
        if (Objects.equals(background, "Transparent")) {
            return "Transparent";
        }
        return background;
    }

    private String color(String hex) {
        if (Objects.equals(hex, "default")) {
            return "<gray>";
        }
        if (Objects.equals(hex, "transparent")) {
            return "<white>";
        }
        return "<" + hex + ">";
    }
}

