/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.commands.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.itsskeptical.displaytags.commands.framework.Subcommand;
import me.itsskeptical.displaytags.utils.helpers.MessageHelper;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class CommandGroup
extends Command {
    Map<String, Subcommand> commands = new HashMap<String, Subcommand>();

    protected CommandGroup(@NotNull String name) {
        super(name);
    }

    public void createCommand(Subcommand command) {
        this.commands.put(command.getName(), command);
    }

    public void sendSubcommands(CommandSender sender) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("Commands <dark_gray>(<white>{commands}<dark_gray>)<white>:".replace("{commands}", String.valueOf(this.commands.size())));
        for (Subcommand command : this.commands.values()) {
            messages.add("<gray>/{name} <dark_gray>\u2192 <white>{description}".replace("{name}", command.getName()).replace("{description}", command.getDescription()));
        }
        MessageHelper.send(sender, messages);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 0) {
            MessageHelper.error(sender, "Unknown sub-command.");
            return true;
        }
        String name = args[0].toLowerCase();
        Subcommand command = this.commands.get(name);
        if (command == null) {
            MessageHelper.error(sender, "Unknown sub-command.");
            return true;
        }
        if (command.getPermission() != null && !sender.hasPermission(command.getPermission())) {
            MessageHelper.error(sender, "You do not have permission to execute this command.");
            return true;
        }
        command.execute(sender, this.sliceArgs(args));
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) throws IllegalArgumentException {
        String name = args[0].toLowerCase();
        if (args.length == 1) {
            return this.commands.keySet().stream().filter(cmd -> cmd.startsWith(name)).toList();
        }
        Subcommand command = this.commands.get(name);
        if (command != null) {
            return command.tabComplete(sender, this.sliceArgs(args));
        }
        return List.of();
    }

    private String[] sliceArgs(String[] args) {
        if (args.length <= 1) {
            return new String[0];
        }
        String[] sliced = new String[args.length - 1];
        System.arraycopy(args, 1, sliced, 0, sliced.length);
        return sliced;
    }
}

