/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.config;

import java.util.List;
import me.itsskeptical.displaytags.DisplayTags;
import me.itsskeptical.displaytags.entities.DisplayBillboard;
import me.itsskeptical.displaytags.entities.TextAlignment;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.util.Vector;

public class NametagConfig {
    private final DisplayTags plugin;
    private boolean enabled;
    private boolean showSelf;
    private int updateInterval;
    private int visibilityDistance;
    private List<String> lines;
    private boolean textShadow;
    private boolean seeThrough;
    private TextAlignment textAlignment;
    private String background;
    private DisplayBillboard billboard;
    private Vector scale;

    public NametagConfig(DisplayTags plugin) {
        this.plugin = plugin;
    }

    public void load() {
        this.load(this.plugin.getConfig());
    }

    public void load(FileConfiguration config) {
        this.enabled = config.getBoolean("nametags.enabled", false);
        this.showSelf = config.getBoolean("nametags.show-self", true);
        this.updateInterval = config.getInt("nametags.update-interval", 1);
        this.visibilityDistance = config.getInt("nametags.visibility-distance", 64);
        this.lines = config.getStringList("nametags.display.lines");
        this.textShadow = config.getBoolean("nametags.display.text-shadow", false);
        this.seeThrough = config.getBoolean("nametags.display.see-through", false);
        this.textAlignment = TextAlignment.valueOf(config.getString("nametags.display.text-alignment", "center").toUpperCase());
        this.background = config.getString("nametags.display.background", "default");
        this.billboard = DisplayBillboard.valueOf(config.getString("nametags.display.billboard", "center").toUpperCase());
        this.scale = this.parseScale(config);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public boolean shouldHideSelf() {
        return !this.showSelf;
    }

    public int getVisibilityDistance() {
        return this.visibilityDistance;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public boolean hasTextShadow() {
        return this.textShadow;
    }

    public boolean isSeeThrough() {
        return this.seeThrough;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public String getBackground() {
        return this.background;
    }

    public DisplayBillboard getBillboard() {
        return this.billboard;
    }

    public Vector getScale() {
        return this.scale;
    }

    private Vector parseScale(FileConfiguration config) {
        return new Vector().setX(config.getDouble("scale.x", 1.0)).setY(config.getDouble("scale.y", 1.0)).setZ(config.getDouble("scale.z", 1.0));
    }
}

