/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.entities;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetPassengers;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ClientEntity {
    private final int entityId = SpigotReflectionUtil.generateEntityId();
    private final UUID uuid = UUID.randomUUID();
    private final EntityType type;
    private Location location;

    public ClientEntity(org.bukkit.entity.EntityType type, Location location) {
        this.type = SpigotConversionUtil.fromBukkitEntityType((org.bukkit.entity.EntityType)type);
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public List<EntityData<?>> getEntityData() {
        return new ArrayList();
    }

    public void spawn(Player viewer) {
        WrapperPlayServerSpawnEntity packet = new WrapperPlayServerSpawnEntity(this.entityId, this.uuid, this.type, SpigotConversionUtil.fromBukkitLocation((Location)this.location), this.location.getYaw(), 0, null);
        this.sendPacket((PacketWrapper<?>)packet, viewer);
    }

    public void update(Player viewer) {
        WrapperPlayServerEntityMetadata packet = new WrapperPlayServerEntityMetadata(this.entityId, this.getEntityData());
        this.sendPacket((PacketWrapper<?>)packet, viewer);
    }

    public void despawn(Player viewer) {
        WrapperPlayServerDestroyEntities packet = new WrapperPlayServerDestroyEntities(this.entityId);
        this.sendPacket((PacketWrapper<?>)packet, viewer);
    }

    public void mount(Entity entity, Player viewer) {
        WrapperPlayServerSetPassengers packet = new WrapperPlayServerSetPassengers(entity.getEntityId(), new int[]{this.entityId});
        this.sendPacket((PacketWrapper<?>)packet, viewer);
    }

    private void sendPacket(PacketWrapper<?> packet, Player player) {
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, packet);
    }
}

