/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.entities;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import java.util.List;
import me.itsskeptical.displaytags.entities.ClientDisplay;
import me.itsskeptical.displaytags.entities.TextAlignment;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;

public class ClientTextDisplay
extends ClientDisplay {
    private Component text;
    private int background = -1;
    private int flags = 0;

    public ClientTextDisplay(Location location) {
        super(EntityType.TEXT_DISPLAY, location);
    }

    public Component getText() {
        return this.text;
    }

    public void setText(Component text) {
        this.text = text;
    }

    public int getBackground() {
        return this.background;
    }

    public void setBackground(int background) {
        this.background = background;
    }

    public void setTextShadow(boolean enabled) {
        this.setFlag(1, enabled);
    }

    public void setSeeThrough(boolean enabled) {
        this.setFlag(2, enabled);
    }

    public void setTextAlignment(TextAlignment alignment) {
        this.flags &= 0xFFFFFFE7;
        switch (alignment) {
            case CENTER: {
                break;
            }
            case LEFT: {
                this.flags |= 8;
                break;
            }
            case RIGHT: {
                this.flags |= 0x10;
            }
        }
    }

    @Override
    public List<EntityData<?>> getEntityData() {
        List<EntityData<?>> data = super.getEntityData();
        if (this.text != null) {
            data.add(new EntityData(23, EntityDataTypes.ADV_COMPONENT, (Object)this.text));
        }
        if (this.background != -1) {
            data.add(new EntityData(25, EntityDataTypes.INT, (Object)this.background));
        }
        if (this.flags != 0) {
            data.add(new EntityData(27, EntityDataTypes.BYTE, (Object)((byte)this.flags)));
        }
        return data;
    }

    private void setFlag(int mask, boolean enabled) {
        this.flags = enabled ? (this.flags |= mask) : (this.flags &= ~mask);
    }
}

