/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.listeners;

import io.papermc.paper.event.player.PlayerClientLoadedWorldEvent;
import me.itsskeptical.displaytags.DisplayTags;
import me.itsskeptical.displaytags.nametags.Nametag;
import me.itsskeptical.displaytags.nametags.NametagManager;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerListener
implements Listener {
    private final DisplayTags plugin = DisplayTags.getInstance();
    private final NametagManager nametagManager = DisplayTags.getInstance().getNametagManager();

    @EventHandler
    public void onPlayerLoad(PlayerClientLoadedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.config().getNametagConfig().isEnabled()) {
            this.nametagManager.create(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.config().getNametagConfig().isEnabled()) {
            Player player = event.getPlayer();
            this.nametagManager.remove(player);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (this.plugin.config().getNametagConfig().isEnabled()) {
            Nametag nametag = this.nametagManager.get(event.getPlayer());
            nametag.hideForAll();
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.plugin.config().getNametagConfig().isEnabled()) {
            Nametag nametag = this.nametagManager.get(event.getPlayer());
            nametag.updateVisibilityForAll();
        }
    }

    @EventHandler
    public void onPlayerWorldChange(PlayerChangedWorldEvent event) {
        if (this.plugin.config().getNametagConfig().isEnabled()) {
            Nametag nametag = this.nametagManager.get(event.getPlayer());
            nametag.hideForAll();
            nametag.updateVisibilityForAll();
        }
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        Nametag nametag;
        if (this.plugin.config().getNametagConfig().isEnabled() && (nametag = this.nametagManager.get(event.getPlayer())) != null) {
            if (event.getNewGameMode() == GameMode.SPECTATOR) {
                nametag.hideForAll();
            } else if (event.getPlayer().getPreviousGameMode() == GameMode.SPECTATOR) {
                nametag.updateVisibilityForAll();
            }
        }
    }
}

