/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.nametags;

import com.github.retrooper.packetevents.util.Vector3f;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.itsskeptical.displaytags.DisplayTags;
import me.itsskeptical.displaytags.config.NametagConfig;
import me.itsskeptical.displaytags.entities.ClientTextDisplay;
import me.itsskeptical.displaytags.utils.ComponentUtils;
import me.itsskeptical.displaytags.utils.handlers.NametagHandler;
import me.itsskeptical.displaytags.utils.helpers.DependencyHelper;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Nametag {
    private final DisplayTags plugin = DisplayTags.getInstance();
    private final Player player;
    private final ClientTextDisplay display;
    private final Set<UUID> viewers;
    private final List<String> lines;
    private final boolean hideSelf;
    private final int visibilityDistance;

    public Nametag(Player player) {
        this.player = player;
        this.viewers = new HashSet<UUID>();
        NametagConfig config = this.plugin.config().getNametagConfig();
        this.lines = config.getLines();
        this.hideSelf = config.shouldHideSelf();
        this.visibilityDistance = config.getVisibilityDistance();
        this.display = new ClientTextDisplay(player.getLocation().setRotation(0.0f, 0.0f));
        this.display.setTranslation(new Vector3f(0.0f, 0.25f, 0.0f));
        this.display.setScale(config.getScale());
        this.display.setTextShadow(config.hasTextShadow());
        this.display.setTextAlignment(config.getTextAlignment());
        this.display.setSeeThrough(config.isSeeThrough());
        this.display.setBillboard(config.getBillboard());
        this.display.setBackground(this.getBackground());
    }

    public Player getPlayer() {
        return this.player;
    }

    public void showForAll() {
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            this.show(viewer);
        }
    }

    public void hideForAll() {
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            this.hide(viewer);
        }
    }

    public void updateVisibilityForAll() {
        this.display.setLocation(this.player.getLocation().setRotation(0.0f, 0.0f));
        this.viewers.removeIf(uuid -> {
            Player viewer = Bukkit.getPlayer((UUID)uuid);
            return viewer == null || !viewer.isOnline();
        });
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            boolean shouldSee = this.shouldSee(viewer);
            boolean isVisible = this.viewers.contains(viewer.getUniqueId());
            if (shouldSee) {
                if (isVisible) {
                    this.update(viewer);
                    continue;
                }
                this.show(viewer);
                continue;
            }
            if (!isVisible) continue;
            this.hide(viewer);
        }
    }

    private boolean shouldSee(Player viewer) {
        if (viewer == null || !viewer.isOnline() || viewer.isDead()) {
            return false;
        }
        if (this.hideSelf && this.player.getUniqueId().equals(viewer.getUniqueId())) {
            return false;
        }
        if (this.player.isDead() || this.player.getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return false;
        }
        if (!viewer.getWorld().getName().equals(this.player.getWorld().getName())) {
            return false;
        }
        if (this.player.isInvisible() || !viewer.canSee(this.player)) {
            return false;
        }
        return viewer.getLocation().distanceSquared(this.player.getLocation()) < (double)(this.visibilityDistance * this.visibilityDistance);
    }

    public void show(Player viewer) {
        NametagHandler.hide(this.player, viewer);
        if (this.hideSelf && this.player.getUniqueId().equals(viewer.getUniqueId())) {
            return;
        }
        this.viewers.add(viewer.getUniqueId());
        this.display.spawn(viewer);
        this.update(viewer);
    }

    public void hide(Player viewer) {
        this.viewers.remove(viewer.getUniqueId());
        this.display.despawn(viewer);
    }

    public void update(Player viewer) {
        this.display.setLocation(this.player.getLocation());
        this.display.setText(this.getText());
        this.display.mount((Entity)this.player, viewer);
        this.display.update(viewer);
    }

    private Component getText() {
        ArrayList<Component> components = new ArrayList<Component>(this.lines.size());
        for (String line : this.lines) {
            String modified = line.replace("{player}", this.player.getName()).replace("{health}", String.valueOf(new DecimalFormat("#.##").format(this.player.getHealth())));
            if (DependencyHelper.isPlaceholderAPIEnabled()) {
                modified = PlaceholderAPI.setPlaceholders((Player)this.player, (String)modified);
            }
            components.add(ComponentUtils.format(modified));
        }
        return ComponentUtils.join(components);
    }

    private int getBackground() {
        String background = this.plugin.config().getNametagConfig().getBackground();
        if (background == null || background.equalsIgnoreCase("default")) {
            return -1;
        }
        if (background.equalsIgnoreCase("transparent")) {
            return 0;
        }
        if (background.startsWith("#")) {
            background = background.substring(1);
        }
        Color color = Color.fromARGB((int)((int)Long.parseLong(background, 16)));
        if (background.length() == 6) {
            color = color.setAlpha(255);
        }
        return color.asARGB();
    }
}

