/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.nametags;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.itsskeptical.displaytags.nametags.Nametag;
import me.itsskeptical.displaytags.utils.handlers.NametagHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class NametagManager {
    private final Map<UUID, Nametag> nametags = new ConcurrentHashMap<UUID, Nametag>();

    public Nametag get(Player player) {
        return this.nametags.get(player.getUniqueId());
    }

    public Collection<Nametag> getAll() {
        return this.nametags.values();
    }

    public void create(Player player) {
        Nametag nametag = new Nametag(player);
        nametag.updateVisibilityForAll();
        this.nametags.put(player.getUniqueId(), nametag);
    }

    public void remove(Player player) {
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            NametagHandler.show(player, viewer);
        }
        Nametag nametag = this.nametags.get(player.getUniqueId());
        if (nametag != null) {
            nametag.hideForAll();
            this.nametags.remove(player.getUniqueId());
        }
    }

    public void createAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.create(player);
        }
    }

    public void removeAll() {
        for (Nametag nametag : this.nametags.values()) {
            this.remove(nametag.getPlayer());
        }
    }
}

