/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.nametags;

import me.itsskeptical.displaytags.DisplayTags;
import me.itsskeptical.displaytags.nametags.Nametag;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class NametagScheduler {
    private final DisplayTags plugin;
    private BukkitTask task;

    public NametagScheduler(DisplayTags plugin) {
        this.plugin = plugin;
    }

    public void start() {
        if (this.plugin.config().getNametagConfig().isEnabled()) {
            this.plugin.getLogger().info("Starting Nametag scheduler...");
            int interval = this.plugin.config().getNametagConfig().getUpdateInterval() * 20;
            this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
                for (Nametag nametag : this.plugin.getNametagManager().getAll()) {
                    nametag.updateVisibilityForAll();
                }
            }, (long)interval, (long)interval);
        } else {
            this.plugin.getLogger().warning("Nametags are disabled for this server, therefore the nametag scheduler has not been started.");
            this.plugin.getLogger().warning("If you want to enable the nametags again, enable them in config.yml and run /displaytags reload.");
        }
    }

    public void stop() {
        if (this.task != null) {
            this.plugin.getLogger().info("Stopping Nametag scheduler...");
            this.task.cancel();
        }
    }
}

