/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.function.Consumer;
import me.itsskeptical.displaytags.DisplayTags;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    DisplayTags plugin;
    String latest;
    String apiUrl;
    String projectId;

    public UpdateChecker(DisplayTags plugin, String projectId) {
        this.plugin = plugin;
        this.projectId = projectId;
        this.apiUrl = "https://api.modrinth.com/v2";
    }

    public void getLatestVersion(Consumer<String> consumer) {
        if (this.latest != null) {
            consumer.accept(this.latest);
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = URI.create(this.apiUrl + "/project/" + this.projectId + "/version").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                JsonArray versions = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                String[] latestVersion = new String[]{null};
                versions.forEach(element -> {
                    JsonObject object = element.getAsJsonObject();
                    String versionType = object.get("version_type").getAsString();
                    if (Objects.equals(versionType, "release")) {
                        String versionNumber = object.get("version_number").getAsString();
                        if (latestVersion[0] == null) {
                            latestVersion[0] = versionNumber;
                        }
                    }
                });
                if (latestVersion[0] != null) {
                    this.latest = latestVersion[0];
                    consumer.accept(latestVersion[0]);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Unable to fetch latest version: " + e.getMessage());
            }
        });
    }
}

