/*
 * Decompiled with CFR 0.152.
 */
package me.itsskeptical.displaytags.utils.helpers;

import java.util.List;
import me.itsskeptical.displaytags.utils.ComponentUtils;
import org.bukkit.command.CommandSender;

public class MessageHelper {
    private static final String PREFIX = "<#00BFFF>DisplayTags";
    static String SUCCESS = "<#7EFF00>";
    static String WARN = "<#FFFF00>";
    static String DANGER = "<#FF0000>";

    public static void success(CommandSender sender, String message) {
        MessageHelper.send(sender, MessageHelper.format("{success} <reset>{success_color}" + message));
    }

    public static void warning(CommandSender sender, String message) {
        MessageHelper.send(sender, MessageHelper.format("{warn} <reset>{warn_color}" + message));
    }

    public static void error(CommandSender sender, String message) {
        MessageHelper.send(sender, MessageHelper.format("{danger} <reset>{danger_color}" + message));
    }

    public static void send(CommandSender sender, String message) {
        sender.sendMessage(ComponentUtils.format(MessageHelper.format("{prefix} <dark_gray>\u00bb <reset>" + message)));
    }

    public static void send(CommandSender sender, List<String> messages) {
        for (String message : messages) {
            MessageHelper.send(sender, message);
        }
    }

    private static String format(String input) {
        return input.replace("{prefix}", PREFIX).replace("{success}", "{start}{success_color}\u2714{end}").replace("{warn}", "{start}{warn_color}\u26a0{end}").replace("{danger}", "{start}{danger_color}\u274c{end}").replace("{success_color}", SUCCESS).replace("{warn_color}", WARN).replace("{danger_color}", DANGER).replace("{start}", "<dark_gray>[").replace("{end}", "<dark_gray>]");
    }
}

