/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.mossy.blocks.data.worldgen.features;

import com.devnemo.nemos.mossy.blocks.data.worldgen.features.NemosMossyVegetationFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class NemosMossyVegetationPlacements {
    public static final ResourceKey<PlacedFeature> CRIMSON_MOSS_PATCH = NemosMossyVegetationPlacements.of("crimson_moss_patch");
    public static final ResourceKey<PlacedFeature> WARPED_MOSS_PATCH = NemosMossyVegetationPlacements.of("warped_moss_patch");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatureHolderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference crimsonMossPatchRegistryEntry = configuredFeatureHolderGetter.getOrThrow(NemosMossyVegetationFeatures.CRIMSON_MOSS_PATCH);
        Holder.Reference warpedMossPatchRegistryEntry = configuredFeatureHolderGetter.getOrThrow(NemosMossyVegetationFeatures.WARPED_MOSS_PATCH);
        PlacementUtils.register(context, CRIMSON_MOSS_PATCH, (Holder)crimsonMossPatchRegistryEntry, (PlacementModifier[])new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)2), BiomeFilter.biome()});
        PlacementUtils.register(context, WARPED_MOSS_PATCH, (Holder)warpedMossPatchRegistryEntry, (PlacementModifier[])new PlacementModifier[]{CountOnEveryLayerPlacement.of((int)2), BiomeFilter.biome()});
    }

    private static ResourceKey<PlacedFeature> of(String id) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"nemos_mossy_blocks", (String)id));
    }
}

