/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.mossy.blocks.mixin;

import com.devnemo.nemos.mossy.blocks.helper.BlockReplacementHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public class AxeItemMixin {
    @Inject(method={"evaluateNewBlockState*"}, at={@At(value="HEAD")}, cancellable=true)
    private void evaluateNewBlockState(Level level, BlockPos pos, @Nullable Player player, BlockState state, UseOnContext useOnContext, CallbackInfoReturnable<Optional<BlockState>> callbackInfoReturnable) {
        Optional<BlockState> optional = this.nemosMossyBlocks$getMossyStrippedState(state);
        if (optional.isPresent()) {
            level.playSound((Entity)player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            callbackInfoReturnable.setReturnValue(optional);
        }
    }

    @Unique
    private Optional<BlockState> nemosMossyBlocks$getMossyStrippedState(BlockState state) {
        return Optional.ofNullable(BlockReplacementHelper.STRIPPED_MOSSY_BLOCKS.get(state.getBlock())).map(block -> (BlockState)block.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS))));
    }
}

