/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.mossy.blocks.world.item;

import com.devnemo.nemos.mossy.blocks.world.entity.projectile.MossBall;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MossBallItem
extends Item
implements ProjectileItem {
    public MossBallItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult use(Level level, Player user, @NotNull InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        level.playSound(null, user.getX(), user.getY(), user.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Projectile.spawnProjectileFromRotation(MossBall::new, (ServerLevel)serverLevel, (ItemStack)itemStack, (LivingEntity)user, (float)0.0f, (float)1.5f, (float)1.0f);
        }
        itemStack.consume(1, (LivingEntity)user);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public Projectile asProjectile(@NotNull Level level, Position pos, @NotNull ItemStack stack, @NotNull Direction direction) {
        return new MossBall(level, pos.x(), pos.y(), pos.z(), stack);
    }
}

