/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.tcgadditions.networking;

import com.bawnorton.tcgadditions.TCGAdditions;
import com.bawnorton.tcgadditions.extend.Album$MutableExtension;
import com.bawnorton.tcgadditions.networking.Networking;
import com.bawnorton.tcgadditions.networking.S2C_OpenAlbumScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.init.RegistryTags;
import team.tnt.collectorsalbum.common.menu.AlbumCategoryMenu;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;

public class C2S_InsertCards {
    public void handle(Player player) {
        ItemStack itemStack = player.m_21205_();
        if (!itemStack.m_204117_(RegistryTags.Items.ALBUM)) {
            return;
        }
        Album album = Album.get((ItemStack)itemStack);
        if (album == null) {
            return;
        }
        AlbumCategoryManager manager = AlbumCategoryManager.getInstance();
        AlbumCardManager cardManager = AlbumCardManager.getInstance();
        List<ResourceLocation> categories = manager.listCategories().stream().map(AlbumCategory::identifier).toList();
        Map inventoryCards = player.m_150109_().f_35974_.stream().filter(stack -> cardManager.isCard(stack.m_41720_())).collect(HashMap::new, (map, stack) -> map.put((AlbumCard)cardManager.getCardInfo(stack.m_41720_()).orElseThrow(), stack), Map::putAll);
        if (inventoryCards.isEmpty()) {
            return;
        }
        HashMap<ResourceLocation, List<Integer>> slotsToHighlight = new HashMap<ResourceLocation, List<Integer>>();
        Map emptySlotMap = player.f_36096_.f_38839_.stream().filter(slot -> TCGAdditions.CARD_SLOT_CLASS.isInstance(slot)).collect(HashMap::new, (map, slot) -> map.put(slot.f_40219_, !slot.m_6657_()), Map::putAll);
        int insertCount = 0;
        try {
            Album.Mutable mutable = new Album.Mutable(album);
            Album$MutableExtension mutableExtension = (Album$MutableExtension)mutable;
            for (ResourceLocation category : categories) {
                AlbumCategoryMenu albumCategoryMenu;
                Collection cards = album.getCardsForCategory(category);
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (abstractContainerMenu instanceof AlbumCategoryMenu && (albumCategoryMenu = (AlbumCategoryMenu)abstractContainerMenu).getCategory().identifier().equals((Object)category)) {
                    cards.removeIf(card -> (Boolean)emptySlotMap.get(card.cardNumber() - 1));
                }
                for (Map.Entry entry : inventoryCards.entrySet()) {
                    AlbumCard inventoryCard = (AlbumCard)entry.getKey();
                    if (!inventoryCard.category().equals((Object)category)) continue;
                    ItemStack stack2 = mutableExtension.tcgadditions$get(category, inventoryCard.cardNumber() - 1);
                    if (stack2.m_41619_()) {
                        mutable.set(category, inventoryCard.cardNumber() - 1, inventoryCard.asItem());
                        ((ItemStack)entry.getValue()).m_41774_(1);
                        slotsToHighlight.computeIfAbsent(category, k -> new ArrayList()).add(inventoryCard.cardNumber() - 1);
                        ++insertCount;
                        continue;
                    }
                    AlbumCard existingCard = (AlbumCard)cardManager.getCardInfo(stack2.m_41720_()).orElseThrow();
                    if (existingCard.compareTo(inventoryCard) >= 0) continue;
                    mutable.set(category, inventoryCard.cardNumber() - 1, inventoryCard.asItem());
                    ((ItemStack)entry.getValue()).m_41774_(1);
                    slotsToHighlight.computeIfAbsent(category, k -> new ArrayList()).add(inventoryCard.cardNumber() - 1);
                    ++insertCount;
                    if (player.m_36356_(stack2)) continue;
                    player.m_7197_(stack2, true, false);
                }
            }
            Album updated = mutable.toImmutable();
            Album.set((ItemStack)itemStack, (Album)updated);
            player.m_150109_().m_6596_();
            if (insertCount == 0) {
                player.m_213846_((Component)Component.m_237115_((String)"tcgadditions.inserted.cards.none"));
            } else if (insertCount == 1) {
                player.m_213846_((Component)Component.m_237115_((String)"tcgadditions.inserted.cards.single"));
            } else {
                player.m_213846_((Component)Component.m_237110_((String)"tcgadditions.inserted.cards.multiple", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(insertCount)).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA))}));
            }
            Networking.sendClientMessage((ServerPlayer)player, new S2C_OpenAlbumScreen(slotsToHighlight));
        }
        catch (RuntimeException e) {
            TCGAdditions.LOGGER.error("Failed to insert card into album", (Throwable)e);
        }
    }
}

