/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.tcgadditions.networking;

import com.bawnorton.tcgadditions.TCGAdditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectorsalbum.client.screen.AlbumCategoryScreen;
import team.tnt.collectorsalbum.client.screen.AlbumNavigationHelper;
import team.tnt.collectorsalbum.common.Album;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.init.RegistryTags;

public class S2C_OpenAlbumScreen {
    private final Map<ResourceLocation, List<Integer>> slotsToHighlight;

    public S2C_OpenAlbumScreen(Map<ResourceLocation, List<Integer>> slotsToHighlight) {
        this.slotsToHighlight = slotsToHighlight;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(this.slotsToHighlight.size());
        for (Map.Entry<ResourceLocation, List<Integer>> entry : this.slotsToHighlight.entrySet()) {
            friendlyByteBuf.m_130085_(entry.getKey());
            friendlyByteBuf.writeInt(entry.getValue().size());
            for (int slot : entry.getValue()) {
                friendlyByteBuf.writeInt(slot);
            }
        }
    }

    public static S2C_OpenAlbumScreen read(FriendlyByteBuf friendlyByteBuf) {
        int size = friendlyByteBuf.readInt();
        HashMap<ResourceLocation, List<Integer>> slotsToHighlight = new HashMap<ResourceLocation, List<Integer>>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation category = friendlyByteBuf.m_130281_();
            int slotSize = friendlyByteBuf.readInt();
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int j = 0; j < slotSize; ++j) {
                slots.add(friendlyByteBuf.readInt());
            }
            slotsToHighlight.put(category, slots);
        }
        return new S2C_OpenAlbumScreen(slotsToHighlight);
    }

    public void handle(Player player) {
        ItemStack itemStack = player.m_21205_();
        if (!itemStack.m_204117_(RegistryTags.Items.ALBUM)) {
            return;
        }
        Album album = Album.get((ItemStack)itemStack);
        if (album == null) {
            return;
        }
        TCGAdditions.SLOTS_TO_HIGHLIGHT.set(this.slotsToHighlight);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AlbumCategoryScreen) {
            AlbumCategoryScreen albumCategoryScreen = (AlbumCategoryScreen)screen;
            AlbumNavigationHelper.navigateCategory((AlbumCategory)albumCategoryScreen.getCategory());
        }
    }
}

