/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschi47.basichud;

import com.github.marschi47.basichud.CpsTracker;
import com.github.marschi47.basichud.KeystrokesTracker;
import com.github.marschi47.basichud.MyModConfig;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HudRenderer {
    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Text event) {
        Collection effects;
        int ping;
        int xPos;
        int textWidth;
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        ScaledResolution sr = new ScaledResolution(mc);
        int width = sr.func_78326_a();
        if (mc.field_71474_y.field_74330_P) {
            return;
        }
        if (MyModConfig.fpsEnabled) {
            int fps = Minecraft.func_175610_ah();
            String fpsText = "FPS: " + fps;
            if (MyModConfig.fpsRightAlign) {
                textWidth = fr.func_78256_a(fpsText);
                xPos = width - MyModConfig.fpsX - textWidth;
            } else {
                xPos = MyModConfig.fpsX;
            }
            fr.func_175063_a(fpsText, (float)xPos, (float)MyModConfig.fpsY, this.hexToInt(MyModConfig.fpsColor));
        }
        if (MyModConfig.pingEnabled && (ping = this.getPlayerPing(mc)) > 0) {
            String pingText = "Ping: " + ping + "ms";
            if (MyModConfig.pingRightAlign) {
                textWidth = fr.func_78256_a(pingText);
                xPos = width - MyModConfig.pingX - textWidth;
            } else {
                xPos = MyModConfig.pingX;
            }
            fr.func_175063_a(pingText, (float)xPos, (float)MyModConfig.pingY, this.hexToInt(MyModConfig.pingColor));
        }
        if (MyModConfig.cpsEnabled) {
            int xPos2;
            String cpsText = "CPS: " + CpsTracker.leftCps + "|" + CpsTracker.rightCps;
            if (MyModConfig.cpsRightAlign) {
                int textWidth2 = fr.func_78256_a(cpsText);
                xPos2 = width - MyModConfig.cpsX - textWidth2;
            } else {
                xPos2 = MyModConfig.cpsX;
            }
            fr.func_175063_a(cpsText, (float)xPos2, (float)MyModConfig.cpsY, this.hexToInt(MyModConfig.cpsColor));
        }
        if (MyModConfig.keystrokesEnabled) {
            int hudWidth = 60;
            int yPos = MyModConfig.keystrokesY;
            int xPos3 = MyModConfig.keystrokesRightAlign ? width - MyModConfig.keystrokesX - hudWidth : MyModConfig.keystrokesX;
            fr.func_175063_a("W", (float)(xPos3 + 25), (float)yPos, this.getKeyColor(KeystrokesTracker.wPressed));
            fr.func_175063_a("A", (float)(xPos3 + 5), (float)(yPos + 14), this.getKeyColor(KeystrokesTracker.aPressed));
            fr.func_175063_a("S", (float)(xPos3 + 25), (float)(yPos + 14), this.getKeyColor(KeystrokesTracker.sPressed));
            fr.func_175063_a("D", (float)(xPos3 + 45), (float)(yPos + 14), this.getKeyColor(KeystrokesTracker.dPressed));
            fr.func_175063_a("LMB", (float)(xPos3 + 2), (float)(yPos + 28), this.getKeyColor(KeystrokesTracker.leftClickPressed()));
            fr.func_175063_a("RMB", (float)(xPos3 + 34), (float)(yPos + 28), this.getKeyColor(KeystrokesTracker.rightClickPressed()));
            fr.func_175063_a("Space", (float)(xPos3 + 12), (float)(yPos + 42), this.getKeyColor(KeystrokesTracker.spacePressed));
            fr.func_175063_a("Shift", (float)(xPos3 + 14), (float)(yPos + 56), this.getKeyColor(KeystrokesTracker.shiftPressed));
        }
        if (MyModConfig.potionHudEnabled && !(effects = mc.field_71439_g.func_70651_bq()).isEmpty()) {
            int xPos4 = MyModConfig.potionHudX;
            int yOffset = MyModConfig.potionHudY;
            int color = this.hexToInt(MyModConfig.potionHudColor);
            int lineHeight = fr.field_78288_b + 2;
            if (MyModConfig.potionHudVerticalCenter) {
                int screenHeight = sr.func_78328_b();
                int totalListHeight = effects.size() * lineHeight;
                yOffset = screenHeight / 2 - totalListHeight / 2;
            }
            for (PotionEffect effect : effects) {
                Potion potion = Potion.field_76425_a[effect.func_76456_a()];
                String name = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
                if (effect.func_76458_c() == 1) {
                    name = name + " II";
                } else if (effect.func_76458_c() == 2) {
                    name = name + " III";
                } else if (effect.func_76458_c() == 3) {
                    name = name + " IV";
                }
                String duration = Potion.func_76389_a((PotionEffect)effect);
                String displayText = name + ": " + duration;
                fr.func_175063_a(displayText, (float)xPos4, (float)yOffset, color);
                yOffset += lineHeight;
            }
        }
    }

    private int getKeyColor(boolean pressed) {
        return pressed ? this.hexToInt(MyModConfig.keystrokesActivatedColor) : this.hexToInt(MyModConfig.keystrokesColor);
    }

    private int hexToInt(String hex) {
        try {
            return Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException e) {
            return 0xFFFFFF;
        }
    }

    private int getPlayerPing(Minecraft mc) {
        if (!mc.func_71356_B() && mc.field_71439_g != null) {
            try {
                NetHandlerPlayClient connection = mc.func_147114_u();
                if (connection != null) {
                    return connection.func_175102_a(mc.field_71439_g.func_110124_au()).func_178853_c();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }
}

