/*
 * Decompiled with CFR 0.152.
 */
package com.example.homeplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class Homeplugin
extends JavaPlugin
implements TabCompleter {
    private Location spawnLocation;
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.spawnLocation = this.loadLocation("spawn");
        this.getCommand("setspawn").setExecutor((CommandExecutor)this);
        this.getCommand("spawn").setExecutor((CommandExecutor)this);
        this.getCommand("sethome").setExecutor((CommandExecutor)this);
        this.getCommand("home").setExecutor((CommandExecutor)this);
        this.getCommand("delhome").setExecutor((CommandExecutor)this);
        this.getCommand("homereload").setExecutor((CommandExecutor)this);
        this.getCommand("home").setTabCompleter((TabCompleter)this);
        this.getCommand("delhome").setTabCompleter((TabCompleter)this);
        this.getLogger().info("Homeplugin \u0432\u043a\u043b\u044e\u0447\u0451\u043d!");
    }

    public void onDisable() {
        this.getLogger().info("Homeplugin \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd = command.getName().toLowerCase();
        if (cmd.equals("homereload")) {
            if (!sender.hasPermission("homeplugin.reload")) {
                sender.sendMessage(this.colorMessage(this.config.getString("messages.ru.no_permission", "&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443.")));
                return true;
            }
            this.reloadPluginConfig(sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("Use this command in-game.");
            return true;
        }
        final Player player = (Player)sender;
        final String lang = "ru";
        switch (cmd) {
            case "setspawn": {
                if (!player.hasPermission("homeplugin.setspawn")) {
                    this.sendMessage(player, lang, "no_permission");
                    return true;
                }
                this.spawnLocation = player.getLocation();
                this.saveLocation("spawn", this.spawnLocation);
                this.sendMessage(player, lang, "setspawn_success");
                this.playSound(player, "setspawn");
                break;
            }
            case "spawn": {
                if (!player.hasPermission("homeplugin.spawn")) {
                    this.sendMessage(player, lang, "no_permission");
                    return true;
                }
                if (this.spawnLocation == null) {
                    player.sendMessage(this.colorMessage("&c\u0421\u043f\u0430\u0432\u043d \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d."));
                    return true;
                }
                int spawnDelay = this.config.getInt("settings.delay.spawn", 0);
                if (spawnDelay > 0) {
                    this.sendMessageWithDelay(player, lang, "spawn_teleport_start", spawnDelay, null);
                    new BukkitRunnable(){

                        public void run() {
                            player.teleport(Homeplugin.this.spawnLocation);
                            Homeplugin.this.sendMessage(player, lang, "spawn_teleported");
                            Homeplugin.this.playSound(player, "spawn");
                        }
                    }.runTaskLater((Plugin)this, (long)spawnDelay * 20L);
                    break;
                }
                player.teleport(this.spawnLocation);
                this.sendMessage(player, lang, "spawn_teleported");
                this.playSound(player, "spawn");
                break;
            }
            case "sethome": {
                if (!player.hasPermission("homeplugin.sethome")) {
                    this.sendMessage(player, lang, "no_permission");
                    return true;
                }
                String homeNameSet = args.length > 0 ? args[0].toLowerCase() : "home";
                int maxHomes = this.config.getInt("settings.max-homes", 1);
                Set<String> currentHomes = this.getCurrentHomes(player);
                if (currentHomes.size() >= maxHomes && !currentHomes.contains(homeNameSet)) {
                    this.sendMessage(player, lang, "too_many_homes");
                    return true;
                }
                this.setHome(player, homeNameSet, player.getLocation());
                this.sendMessage(player, lang, "sethome_success", homeNameSet);
                this.playSound(player, "sethome");
                break;
            }
            case "home": {
                if (!player.hasPermission("homeplugin.home")) {
                    this.sendMessage(player, lang, "no_permission");
                    return true;
                }
                final String homeName = args.length > 0 ? args[0].toLowerCase() : "home";
                final Location homeLoc = this.loadHome(player, homeName);
                if (homeLoc == null) {
                    this.sendMessage(player, lang, "home_not_found");
                    return true;
                }
                int homeDelay = this.config.getInt("settings.delay.home", 0);
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("home", homeName);
                if (homeDelay > 0) {
                    this.sendMessageWithDelay(player, lang, "home_teleport_start", homeDelay, placeholders);
                    new BukkitRunnable(){

                        public void run() {
                            player.teleport(homeLoc);
                            Homeplugin.this.sendMessage(player, lang, "home_teleported", homeName);
                            Homeplugin.this.playSound(player, "home");
                        }
                    }.runTaskLater((Plugin)this, (long)homeDelay * 20L);
                    break;
                }
                player.teleport(homeLoc);
                this.sendMessage(player, lang, "home_teleported", homeName);
                this.playSound(player, "home");
                break;
            }
            case "delhome": {
                String homeToDelete;
                if (!player.hasPermission("homeplugin.delhome")) {
                    this.sendMessage(player, lang, "no_permission");
                    return true;
                }
                String string = homeToDelete = args.length > 0 ? args[0].toLowerCase() : "home";
                if (this.deleteHome(player, homeToDelete)) {
                    this.sendMessage(player, lang, "delhome_success", homeToDelete);
                    this.playSound(player, "delhome");
                    break;
                }
                this.sendMessage(player, lang, "home_not_found");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("home") || command.getName().equalsIgnoreCase("delhome")) {
            Set<String> homes = this.getCurrentHomes(player);
            if (args.length == 1) {
                String prefix = args[0].toLowerCase();
                ArrayList<String> completions = new ArrayList<String>();
                for (String home : homes) {
                    if (!home.toLowerCase().startsWith(prefix)) continue;
                    completions.add(home);
                }
                return completions;
            }
        }
        return Collections.emptyList();
    }

    private void sendMessage(Player player, String lang, String path) {
        this.sendMessage(player, lang, path, null);
    }

    private void sendMessage(Player player, String lang, String path, String homeName) {
        String msg = this.config.getString("messages." + lang + "." + path, "Message not found");
        if (homeName != null) {
            msg = msg.replace("{home}", homeName);
        }
        msg = this.colorMessage(msg);
        player.sendMessage(msg);
    }

    private void sendMessageWithDelay(Player player, String lang, String path, int delaySeconds, Map<String, String> placeholders) {
        String msg = this.config.getString("messages." + lang + "." + path, "Message not found");
        msg = msg.replace("{delay}", String.valueOf(delaySeconds));
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                msg = msg.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        msg = this.colorMessage(msg);
        player.sendMessage(msg);
    }

    private String colorMessage(String msg) {
        return msg.replace('&', '\u00a7');
    }

    private void playSound(Player player, String command) {
        if (!this.config.getBoolean("settings.play-sound." + command + ".enabled", true)) {
            return;
        }
        String soundName = this.config.getString("settings.play-sound." + command + ".sound", "ENTITY_ENDERMAN_TELEPORT");
        try {
            Sound sound = Sound.valueOf((String)soundName.toUpperCase());
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(this.colorMessage("&cSound not found: " + soundName));
        }
    }

    private Set<String> getCurrentHomes(Player player) {
        ConfigurationSection homesSection = this.config.getConfigurationSection("homes." + String.valueOf(player.getUniqueId()));
        if (homesSection == null) {
            return new HashSet<String>();
        }
        return homesSection.getKeys(false);
    }

    private void setHome(Player player, String home, Location loc) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + home;
        this.config.set(path + ".world", (Object)loc.getWorld().getName());
        this.config.set(path + ".x", (Object)loc.getX());
        this.config.set(path + ".y", (Object)loc.getY());
        this.config.set(path + ".z", (Object)loc.getZ());
        this.config.set(path + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        this.config.set(path + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        this.saveConfig();
    }

    private Location loadHome(Player player, String home) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + home;
        if (!this.config.contains(path)) {
            return null;
        }
        World world = Bukkit.getWorld((String)this.config.getString(path + ".world"));
        if (world == null) {
            return null;
        }
        double x = this.config.getDouble(path + ".x");
        double y = this.config.getDouble(path + ".y");
        double z = this.config.getDouble(path + ".z");
        float yaw = (float)this.config.getDouble(path + ".yaw");
        float pitch = (float)this.config.getDouble(path + ".pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }

    private boolean deleteHome(Player player, String home) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + home;
        if (!this.config.contains(path)) {
            return false;
        }
        this.config.set(path, null);
        this.saveConfig();
        return true;
    }

    private void saveLocation(String path, Location loc) {
        this.config.set(path + ".world", (Object)loc.getWorld().getName());
        this.config.set(path + ".x", (Object)loc.getX());
        this.config.set(path + ".y", (Object)loc.getY());
        this.config.set(path + ".z", (Object)loc.getZ());
        this.config.set(path + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        this.config.set(path + ".pitch", (Object)Float.valueOf(loc.getPitch()));
        this.saveConfig();
    }

    private Location loadLocation(String path) {
        if (!this.config.contains(path)) {
            return null;
        }
        World world = Bukkit.getWorld((String)this.config.getString(path + ".world"));
        if (world == null) {
            return null;
        }
        double x = this.config.getDouble(path + ".x");
        double y = this.config.getDouble(path + ".y");
        double z = this.config.getDouble(path + ".z");
        float yaw = (float)this.config.getDouble(path + ".yaw");
        float pitch = (float)this.config.getDouble(path + ".pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }

    private void reloadPluginConfig(CommandSender sender) {
        this.reloadConfig();
        this.config = this.getConfig();
        this.spawnLocation = this.loadLocation("spawn");
        sender.sendMessage(this.colorMessage(this.config.getString("messages.ru.reload_success", "&a\u041f\u043b\u0430\u0433\u0438\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d!")));
        this.getLogger().info("Homeplugin config reloaded by " + sender.getName());
    }
}

