/*
 * Decompiled with CFR 0.152.
 */
package com.skitbet.redstoneer.feature;

import com.skitbet.redstoneer.RedstoneerPlugin;
import com.skitbet.redstoneer.feature.Features;
import com.skitbet.redstoneer.feature.type.AbstractFeature;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class FeatureManager
implements CommandExecutor {
    private Map<String, AbstractFeature> featuresMap = new HashMap<String, AbstractFeature>();
    private final Player player;
    private final RedstoneerPlugin plugin = RedstoneerPlugin.getInstance();

    public FeatureManager(Player player) {
        this.player = player;
        for (Features feature : Features.values()) {
            this.register(feature);
        }
        this.registerCommands();
    }

    public void register(Features feature) {
        this.featuresMap.put(feature.getName(), feature.getFeature());
    }

    public void registerCommands() {
        for (AbstractFeature abstractFeature : this.featuresMap.values()) {
            this.plugin.getCommand(abstractFeature.getCommandName()).setExecutor((CommandExecutor)this);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandName, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Redstoneer commands can only be ran by players.");
            return true;
        }
        for (AbstractFeature abstractFeature : this.featuresMap.values()) {
            if (!commandName.equals(abstractFeature.getCommandName())) continue;
            abstractFeature.onCommand(this.player, args);
        }
        return true;
    }

    public AbstractFeature getFeatureByName(String name) {
        System.out.println(this.featuresMap.toString());
        return this.featuresMap.getOrDefault(name, null);
    }

    public void handleBlockPlaceEvent(BlockPlaceEvent event) {
        this.featuresMap.values().forEach(abstractFeature -> abstractFeature.handleBlockPlace(event));
    }

    public void handleInteractionEvent(PlayerInteractEvent event) {
        this.featuresMap.values().forEach(abstractFeature -> abstractFeature.handleInteraction(event));
    }
}

