/*
 * Decompiled with CFR 0.152.
 */
package com.skitbet.redstoneer.feature.type;

import com.skitbet.redstoneer.feature.type.FeatureData;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public abstract class AbstractFeature {
    private final FeatureData data = this.getClass().getAnnotation(FeatureData.class);
    private final String id;
    public boolean toggled;

    public AbstractFeature() {
        if (this.data == null) {
            throw new IllegalStateException("Feature " + this.getClass() + " does not have a FeatureData annotation.");
        }
        this.id = this.data.name().toLowerCase().replace(" ", "");
    }

    public abstract void onCommand(Player var1, String[] var2);

    protected void onBlockPlace(BlockPlaceEvent event) {
    }

    protected void onInteractEvent(PlayerInteractEvent event) {
    }

    public void handleBlockPlace(BlockPlaceEvent event) {
        if (this.toggled) {
            this.onBlockPlace(event);
        }
    }

    public void handleInteraction(PlayerInteractEvent event) {
        if (this.toggled) {
            this.onInteractEvent(event);
        }
    }

    public String getName() {
        return this.data.name();
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.data.description();
    }

    public String getCommandName() {
        return this.data.command();
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }
}

